/********************************************************************
        Actel A500K Verilog Library
        NAME: a500k.v
        DATE: March 09, 2006
*********************************************************************/

`timescale 1 ns / 100 ps

//----------------------------------------------------------------------
//---             VERILOG LIBRRAY PRIMITIVE SECTION                     
//----------------------------------------------------------------------

 //---------------------------------------------------------------------
 // primitibe module (Dffpr) state table definition
 // FUNCTION : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
 //            ASYNCHRONOUS SET AND CLEAR. CLR PRIORITY WHEN BOTH
 //            SET AND CLEAR ARE LOW ( Q OUTPUT UDP ).
 //            Enable active low.

 //----------------------------------------------------------------------
primitive Dffpr (Q, D, CLK, CLR, PRE, E, NOTIFIER_REG);
  output Q;
  input  NOTIFIER_REG;
  input  D, CLK, E, CLR, PRE;
  reg Q;

	table

	//  D   CLK   CLR  PRE   E  NOTIFIER_REG  :   Qt  :  Qt+1

	    1   (01)    1   1    0      ?         :   ?   :   1;  // clocked data
	    0   (01)    1   1    0      ?         :   ?   :   0;  // clocked data
	    1   (01)    1   1    x      ?         :   1   :   1;  // clocked data
	    0   (01)    1   1    x      ?         :   0   :   0; 
	    0   (01)    1   1    x      ?         :   1   :   x;
	    1   (01)    1   1    x      ?         :   0   :   x;
	    0   (01)    x   1    0      ?         :   ?   :   0;  // pessimism
	    1   (01)    1   x    0      ?         :   ?   :   1;  // pessimism
	    ?    ?      1   x    ?      ?         :   1   :   1;  // pessimism
	    0    ?      1   x    ?      ?         :   x   :   x;  // pessimism
	    ?    ?      1   x    ?      ?         :   0   :   x;
	    ?    ?      x   x    ?      ?         :   ?   :   x;
	    ?    ?      x   0    ?      ?         :   ?   :   x;
	    ?    ?      x   1    ?      ?         :   0   :   0;
	    ?    ?      x   1    ?      ?         :   1   :   x;
	    ?    ?      0   ?    ?      ?         :   ?   :   0;
	    ?    ?      1   0    ?      ?         :   ?   :   1;
	    1   (x1)    1   1    0      ?         :   1   :   1;  // reducing pessimism
	    0   (x1)    1   1    0      ?         :   0   :   0;
	    1   (0x)    1   1    0      ?         :   1   :   1;
     0   (0x)    1   1    0      ?         :   0   :   0;
	    1   (x1)    1   1    x      ?         :   1   :   1;  // reducing pessimism
	    0   (x1)    1   1    x      ?         :   0   :   0;
	    1   (0x)    1   1    x      ?         :   1   :   1;
	    0   (0x)    1   1    x      ?         :   0   :   0;
	    ?  (?1)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	    ?  (0x)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	    ?   ?       ?   ?    *      ?         :   ?   :   -;
	    ?   (?0)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	    ?   (1x)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	    *    ?      ?   ?    ?      ?         :   ?   :   -;  // ignore data edges
	    ?   ?     (?1)  ?    ?      ?         :   ?   :   -;  // ignore the edges on
	    ?   ?       ?  (?1)  ?      ?         :   ?   :   -;  //       set and clear
	    ?   ?       ?   ?    ?      *         :   ?   :   x;

	endtable
 endprimitive


 //---------------------------------------------------------------------
 // primitibe module (Dffpf) logic table definition
 // FUNCTION : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
 //            ASYNCHRONOUS SET AND CLEAR. CLR PRIORITY WHEN BOTH
 //            SET AND CLEAR ARE LOW ( Q OUTPUT UDP ).
 //            Enable active low.

 //----------------------------------------------------------------------
primitive Dffpf (Q, D, CLK, CLR, PRE, E, NOTIFIER_REG);
  output Q;
  input  NOTIFIER_REG;
  input  D, CLK, E, CLR, PRE;
  reg Q;

 table

//    D   CLK     CLR PRE  E  NOTIFIER_REG  :   Qt  :  Qt+1	
	     1   (10)    1   1    0      ?         :   ?   :   1;  // clocked data
	     0   (10)    1   1    0      ?         :   ?   :   0;  // clocked data
	     1   (10)    1   1    x      ?         :   1   :   1;  // clocked data
	     0   (10)    1   1    x      ?         :   0   :   0;
	     0   (10)    1   x    x      ?         :   1   :   1;
	     0   (10)    1   1    x      ?         :   1   :   x;
	     1   (10)    1   1    x      ?         :   0   :   x;
	     0   (10)    1   x    0      ?         :   1   :   1;
	     0   (10)    x   1    0      ?         :   ?   :   0;
	     1   (10)    1   ?    0      ?         :   ?   :   1;  // pessimism
	     1    ?      1   x    0      ?         :   1   :   1;  // pessimism
	     ?    ?      1   x    ?      ?         :   0   :   x;
	     0    1      1   x    0      ?         :   1   :   1;  // pessimism
	     0    x      1 (?x)   0      ?         :   1   :   1;  // pessimism
	     0    ?      1 (?x)   0      ?         :   1   :   1;  // baoxian
	     0    ?      x   1    ?      ?         :   0   :   0;
	     0    ?      x   0    ?      ?         :   ?   :   x;
	     0    ?      x   1    ?      ?         :   1   :   x;
	     x    1      1   x    0      ?         :   1   :   1;  // pessimism
	     x    x      1 (?x)   0      ?         :   1   :   1;  // pessimism
	     x    0      1   x    0      ?         :   1   :   1;  // pessimism
	     1    ?      1   x    x      ?         :   1   :   1;  // pessimism
	     0    1      1   x    x      ?         :   1   :   1;  // pessimism
	     0    x      1 (?x)   x      ?         :   1   :   1;  // pessimism
	     0    0      1 (?x)   x      ?         :   1   :   1;  // pessimism
	     x    1      1   x    x      ?         :   1   :   1;  // pessimism
	     x    ?      1   x    x      ?         :   1   :   1;  // pessimism
	     1    0      x   1    0      ?         :   0   :   0;  // pessimism
	     1    x    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     1    1    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     x    0      x   1    0      ?         :   0   :   0;  // pessimism
	     x    x    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     x    1    (?x)  1    0      ?         :   0   :   0;  // pessimism
	     1    0      x   1    x      ?         :   0   :   0;  // pessimism
	     1    x    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     1    1    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     x    0      x   1    x      ?         :   0   :   0;  // pessimism
	     x    x    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     x    1    (?x)  1    x      ?         :   0   :   0;  // pessimism
	     1   (1x)    1   1    0      ?         :   1   :   1;  // reducing pessimism
	     0   (1x)    1   1    0      ?         :   0   :   0;
	     1   (x0)    1   1    0      ?         :   1   :   1;
	     0   (x0)    1   1    0      ?         :   0   :   0;
	     1   (1x)    1   1    x      ?         :   1   :   1;  // reducing pessimism
	     0   (1x)    1   1    x      ?         :   0   :   0;
	     1   (x0)    1   1    x      ?         :   1   :   1;
	     0   (x0)    1   1    x      ?         :   0   :   0;
	     ?   ?       0   1    ?      ?         :   ?   :   0;  // asynchronous clear
	     ?   ?       1   0    ?      ?         :   ?   :   1;  // asynchronous set
	     ?  (?0)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	     ?  (1x)     1   1    1      ?         :   ?   :   -;  //no action for CE = 1
	     ?   (?0)    x   1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?   (1x)    x   1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?    ?    (?x)  1    1      ?         :   0   :   0;  // chip is not enabled pessimism with reset
	     ?   (?0)    1   x    1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?   (1x)    1   x    1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?    ?      1  (?x)  1      ?         :   1   :   1;  // chip is not enabled pessimism with reset
	     ?   ?       ?   ?    *      ?         :   ?   :   -;
	     ?   (?1)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	     ?   (0x)    ?   ?    ?      ?         :   ?   :   -;  // ignore falling clock
	     *    ?      ?   ?    ?      ?         :   ?   :   -;  // ignore data edges
	     ?   ?     (?1)  ?    ?      ?         :   ?   :   -;  // ignore the edges on
	     ?   ?       ?  (?1)  ?      ?         :   ?   :   -;  //       set and clear
	     ?   ?       0   0    ?      ?         :   ?   :   0; // CLR Priority (added 0n 11/12/97)
	     ?   ?       0   x    ?      ?         :   ?   :   0; // CLR Priority (added 0n 11/12/97)
	     ?   ?       ?   ?    ?      *         :   ?   :   x;
	endtable
 endprimitive

//--------------------------------------------------------------------
//-                    cell  UFPRB.v                                  -
//--------------------------------------------------------------------

primitive UFPRB (Q, D, CP, RB, NOTIFIER_REG);

    output Q;
    input  NOTIFIER_REG,
           D, CP, RB;
    reg    Q;

// FUNCTION : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
//            ASYNCHRONOUS CLEAR ( Q OUTPUT UDP ).

    table
    //  D   CP      RB     NOTIFIER_REG  :   Qt  :   Qt+1

        1   (01)    1         ?          :   ?   :   1;  // clocked data
        0   (01)    1         ?          :   ?   :   0;

        0   (01)    x         ?          :   ?   :   0;  // pessimism
        0    ?      x         ?          :   0   :   0;  // pessimism

        1    0      x         ?          :   0   :   0;  // pessimism
        1    x    (?x)        ?          :   0   :   0;  // pessimism
        1    1    (?x)        ?          :   0   :   0;  // pessimism
        x    0      x         ?          :   0   :   0;  // pessimism
        x    x    (?x)        ?          :   0   :   0;  // pessimism
        x    1    (?x)        ?          :   0   :   0;  // pessimism
        1   (x1)    1         ?          :   1   :   1;  // reducing pessimism
        0   (x1)    1         ?          :   0   :   0;
        1   (0x)    1         ?          :   1   :   1;
        0   (0x)    1         ?          :   0   :   0;
        ?   ?       0         ?          :   ?   :   0;  // asynchronous clear
        ?   (?0)    ?         ?          :   ?   :   -;  // ignore falling clock
        ?   (1x)    ?         ?          :   ?   :   -;  // ignore falling clock
        *    ?      ?         ?          :   ?   :   -;  // ignore the edges on data
        ?    ?    (?1)        ?          :   ?   :   -;  // ignore the edges on clear
        ?    ?      ?         *          :   ?   :   x;
    endtable
endprimitive

//--------------------------------------------------------------------
//-                    cell  UFNRB.v                                  -
//--------------------------------------------------------------------
primitive UFNRB (Q, D, CP, RB, NOTIFIER_REG);
    output Q;
    input  NOTIFIER_REG,
           D, CP, RB;
    reg    Q;
// FUNCTION : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
//            ASYNCHRONOUS CLEAR ( Q OUTPUT UDP ).
    table
    //  D   CP      RB     NOTIFIER_REG  :   Qt  :   Qt+1
        1   (10)    1         ?          :   ?   :   1;  // clocked data
        0   (10)    1         ?          :   ?   :   0;
        0   (10)    x         ?          :   ?   :   0;  // pessimism
        0    ?      x         ?          :   0   :   0;  // pessimism
        1    1      x         ?          :   0   :   0;  // pessimism
        1    x    (?x)        ?          :   0   :   0;  // pessimism
        1    0    (?x)        ?          :   0   :   0;  // pessimism
        x    1      x         ?          :   0   :   0;  // pessimism
        x    x    (?x)        ?          :   0   :   0;  // pessimism
        x    0    (?x)        ?          :   0   :   0;  // pessimism
        1   (1x)    1         ?          :   1   :   1;  // reducing pessimism
        0   (1x)    1         ?          :   0   :   0;
        1   (x0)    1         ?          :   1   :   1;
        0   (x0)    1         ?          :   0   :   0;
        ?   ?       0         ?          :   ?   :   0;  // asynchronous clear
        ?   (?1)    ?         ?          :   ?   :   -;  // ignore falling clock
        ?   (0x)    ?         ?          :   ?   :   -;  // ignore falling clock
        *    ?      ?         ?          :   ?   :   -;  // ignore the edges on data
        ?    ?    (?1)        ?          :   ?   :   -;  // ignore the edges on clear
        ?    ?      ?         *          :   ?   :   x;
    endtable
endprimitive

//------------------------------------------------------------------------
// primitive DL2C_UDP functional description
// FUNCTION : NEGATIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE HIGH
//            ASYNCHRONOUS SET AND RESET.
//-------------------------------------------------------------------------


primitive DL2C_UDP (q, d, g, c, p, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        g,              // CLOCK
        c,              // CLEAR ACTIVE HIGH
        p,              // SET ACTIVE HIGH
        NOTIFIER_REG;

 reg q;

    table
    //  D     G     C     P  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     1     ?     ?          :   ?   :   0;  // active low clear
        ?     ?     0     1     ?          :   ?   :   1;  // active high preset

        ?     1     0     0     ?          :   ?   :   -;  // latch
        0     0     0     0     ?          :   ?   :   0;  // transparent

        0     0     x     0     ?          :   ?   :   0;  // CLR==x
        ?     1     x     0     ?          :   0   :   0;  // CLR==x
        0     x     ?     0     ?          :   0   :   0;  // CLR,G==x

        1     x     0     ?     ?          :   1   :   1;  // PRE==x/?,G==x
        1     0     0     ?     ?          :   ?   :   1;  // PRE==x/?
        ?     1     0     x     ?          :   1   :   1;  // PRE==x
    endtable


endprimitive

//--------------------------------------------------------------------------
// primitive DLE3B_UDP
// FUNCTION : D LATCH WITH DUAL CLOCK INPUTS ACTIVE HIGH ASYNCHRONOUS PRESET.
//            TWO CLOCKS: E G
//-------------------------------------------------------------------------

primitive DLE3B_UDP (q, d, g, e, p, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        g,              // CLOCK
        e,              // CLEAR ACTIVE HIGH
        p,              // SET ACTIVE HIGH
        NOTIFIER_REG;

 reg    q;

    table
    //  D     G     E     P  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     ?     1     ?          :   ?   :   1;  // active high preset

        ?     1     ?     0     ?          :   ?   :   -;  // latch
        ?     ?     1     0     ?          :   ?   :   -;  // latch

        1     0     0     0     ?          :   ?   :   1;  // transparent
        0     0     0     0     ?          :   ?   :   0;  // transparent

        1     x     ?     0     ?          :   1   :   1;  // o/p mux pessimism
        1     ?     x     0     ?          :   1   :   1;  // o/p mux pessimism
        0     x     ?     0     ?          :   0   :   0;  // o/p mux pessimism
        0     ?     x     0     ?          :   0   :   0;  // o/p mux pessimism

        1     0     0     x     ?          :   ?   :   1;  // PRE==x
        ?     1     ?     x     ?          :   1   :   1;  // PRE==x
        ?     ?     1     x     ?          :   1   :   1;  // PRE==x
        1     0     x     x     ?          :   1   :   1;  // PRE==x
        1     x     0     x     ?          :   1   :   1;  // PRE==x
        1     x     x     x     ?          :   1   :   1;  // PRE==x
    endtable

endprimitive


//--------------------------------------------------------------------------
// primitive DLE2B_UDP
// FUNCTION : D LATCH WITH DUAL CLOCK INPUTS ACTIVE HIGH ASYNCHRONOUS CLEAR.
//            TWO CLOCKS: E G
//-------------------------------------------------------------------------

primitive DLE2B_UDP (q, d, e, g, c, NOTIFIER_REG);

 output q;
 input  d,              // DATA
        e,              // CLOCK
        g,              // CLOCK
        c,              // CLEAR ACTIVE HIGH
        NOTIFIER_REG;

 reg    q;

    table
    //  D     E     G     C  NOTIFIER_REG  :   Qt  :   Qt+1
        ?     ?     ?     0     ?          :   ?   :   0;  // active low clear

        ?     ?     1     1     ?          :   ?   :   -;  // latch
        ?     1     ?     1     ?          :   ?   :   -;  // latch

        1     0     0     1     ?          :   ?   :   1;  // transparent
        0     0     0     1     ?          :   ?   :   0;  // transparent

        0     ?     ?     1     ?          :   0   :   0;  // o/p mux pessimism
        1     ?     ?     1     ?          :   1   :   1;  // o/p mux pessimism

        0     ?     ?     x     ?          :   0   :   0;  // CLR==x, o/p mux pessimism
        ?     ?     1     x     ?          :   0   :   0;  // PRE==x, o/p mux pessimism, latch
        ?     1     ?     x     ?          :   0   :   0;  // PRE==x, o/p mux pessimism, latch
        0     0     0     x     ?          :   ?   :   0;  // PRE==x, o/p mux pessimism
    endtable

endprimitive


//--------------------------------------------------------------------
//-                 primitive  JKFFF  -- falling edge                -
//--------------------------------------------------------------------

primitive JKFFF (Q, J, K, CP, RB, SB, NOTIFIER_REG);
    output Q;
    reg    Q; 
    input  NOTIFIER_REG,
           J,K,
            CP,                                  // Clock.
            RB,                                  // Clear input
            SB;                                  // Set input
// FUNCTION :NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW
//           ASYNCHRONOUS CLEAR AND  SET
//           OUTPUT GOES TO X WHEN BOTH CLEAR AND SET ARE ACTIVE
    table
      // J   K   CP  RB   SB       NOTIFIER_REG  : Qtn : Qtn+1
         0   1  (10) 1    1           ?          :  ?  :   - ;    // Output retains the
         0   0  (10) 1    1           ?          :  ?  :   0 ;    // Clocked J and K.
         0   0  (10) x    1           ?          :  ?  :   0 ;    // pessimism
         ?   ?   ?   x    1           ?          :  0  :   0 ;    // pessimism
         1   1  (10) 1    1           ?          :  ?  :   1 ;
         1   1  (10) 1    x           ?          :  ?  :   1 ;    // pessimism
         ?   ?   ?   1    x           ?          :  1  :   1 ;    // pessimis
         1   0  (10) 1    1           ?          :  0  :   1 ;    // Clocked toggle.
         1   0  (10) 1    1           ?          :  1  :   0 ;
         ?   0  (10) x    1           ?          :  1  :   0 ;    //pessimism
         1   ?  (10) 1    x           ?          :  0  :   1 ;
         0   1  (1x) 1    1           ?          :  ?  :   - ;    //possible clocked JK
         0   0  (1x) 1    1           ?          :  0  :   0 ;
         1   1  (1x) 1    1           ?          :  1  :   1 ;
         0   1  (x0) 1    1           ?          :  ?  :   - ;
         0   0  (x0) 1    1           ?          :  0  :   0 ;
         1   1  (x0) 1    1           ?          :  1  :   1 ;
         *   ?   ?   1    1           ?          :  ?  :   - ;    // Insensitive to
         ?   *   ?   1    1           ?          :  ?  :   - ;    // transitions on J and K
         ?   ?   ?   0    1           ?          :  ?  :   0 ;    // Clear
         ?   ?   ?   1    0           ?          :  ?  :   1 ;    // Set.
         ?   ?   ?   0    0           ?          :  ?  :   x ;    // ILLEGAL
         x   1   f   1    1           ?          :  1  :   1 ;
         x   0   f   1    1           ?          :  1  :   0 ;
         0   x   f   1    1           ?          :  0  :   0 ;
         1   x   f   1    1           ?          :  0  :   1 ;
         x   1 (1x)  1    1           ?          :  1  :   1 ;    //possible clocked with
         0   x (1x)  1    1           ?          :  0  :   0 ;    //possible J & K
         x   1 (x0)  1    1           ?          :  1  :   1 ;
         0   x (x0)  1    1           ?          :  0  :   0 ;
         ?   ? (?1)  ?    ?           ?          :  ?  :   - ;
         ?   ? (0x)  ?    ?           ?          :  ?  :   - ;
         ?   ?   ? (?1)   1           ?          :  ?  :   - ;    //ignore changes on set and
         ?   ?   ?   1  (?1)          ?          :  ?  :   - ;    //reset.
         ?   ?   ?   ?    ?           *          :  ?  :   x ;
    endtable
endprimitive

//--------------------------------------------------------------------
//-                   primitive  JKFFR                                -
//--------------------------------------------------------------------
primitive JKFFR (Q, J, K, CP, RB, SB, NOTIFIER_REG);
    output Q;
    reg    Q; 
    input  NOTIFIER_REG,
           J,K,
           CP,                                  // Clock.
           RB,                                  // Clear input
           SB;                                  // Set input
// FUNCTION :POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW
//           ASYNCHRONOUS CLEAR AND  SET
//           OUTPUT GOES TO x WHEN BOTH CLEAR AND SET ARE ACTIVE
    table
      // J   K  CP  RB   SB        NOTIFIER_REG  : Qtn : Qtn+1
         0   1  (01) 1    1           ?          :  ?  :   - ;    // Output retains the
         0   0  (01) 1    1           ?          :  ?  :   0 ;    // Clocked J and K.
         0   0  (01) x    1           ?          :  ?  :   0 ;    // pessimism
         ?   ?   ?   x    1           ?          :  0  :   0 ;    // pessimism
         1   1  (01) 1    1           ?          :  ?  :   1 ;
         1   1  (01) 1    x           ?          :  ?  :   1 ;    // pessimism
         ?   ?   ?   1    x           ?          :  1  :   1 ;    // pessimism
         1   0  (01) 1    1           ?          :  0  :   1 ;    // Clocked toggle.
         1   0  (01) 1    1           ?          :  1  :   0 ;
         ?   0  (01) x    1           ?          :  1  :   0 ;     //pessimism
         1   ?  (01) 1    x           ?          :  0  :   1 ;
         0   1  (x1) 1    1           ?          :  ?  :   - ;   //possible clocked JK
         0   0  (x1) 1    1           ?          :  0  :   0 ;
         1   1  (x1) 1    1           ?          :  1  :   1 ;
         0   1  (0x) 1    1           ?          :  ?  :   - ;
         0   0  (0x) 1    1           ?          :  0  :   0 ;
         1   1  (0x) 1    1           ?          :  1  :   1 ;
         *   ?   ?   1    1           ?          :  ?  :   - ;    // Insensitive to
         ?   *   ?   1    1           ?          :  ?  :   - ;    // transitions on J and K
         ?   ?   ?   0    1           ?          :  ?  :   0 ;    // Clear
         ?   ?   ?   1    0           ?          :  ?  :   1 ;    // Set.
         ?   ?   ?   0    0           ?          :  ?  :   x ;    // ILLEGAL
         x   1   r   1    1           ?          :  1  :   1 ;
         x   0   r   1    1           ?          :  1  :   0 ;
         0   x   r   1    1           ?          :  0  :   0 ;
         1   x   r   1    1           ?          :  0  :   1 ;
         x   1 (x1)  1    1           ?          :  1  :   1 ;        //possible clocked with
         0   x (x1)  1    1           ?          :  0  :   0 ;        //possible J & K
         x   1 (0x)  1    1           ?          :  1  :   1 ;
         0   x (0x)  1    1           ?          :  0  :   0 ;
         ?   ? (?0)  1    1           ?          :  ?  :   - ;    //ignore falling clock.
         ?   ? (1x)  1    1           ?          :  ?  :   - ;
         ?   ?   ? (?1)   1           ?          :  ?  :   - ;    //ignore changes on set and
         ?   ?   ?   1  (?1)          ?          :  ?  :   - ;    //reset.
         ?   ?   ?   ?    ?           *          :  ?  :   x ;
    endtable
endprimitive
 // --------------------------------------------------------------------
 // 2-1 MUX  primitive   
 // FUNCTION : when select signal S= 1, A will be selected, S= 0, B will 
 //            be selected; when S=X, if A=B, A will be selected, if A!=B,
 //            X will be the output!
 // --------------------------------------------------------------------
primitive UDP_MUX2 (Q, A, B, SL);
output Q;
input A, B, SL;

// FUNCTION :  TWO TO ONE MULTIPLEXER

    table
    //  A   B   SL  :   Q
        0   0   ?   :   0 ;
        1   1   ?   :   1 ;

        0   ?   1   :   0 ;
        1   ?   1   :   1 ;

        ?   0   0   :   0 ;
        ?   1   0   :   1 ;

    endtable
endprimitive

primitive UDPN_MUX2 (Q, A, B, SL);
output Q;
input A, B, SL;

// FUNCTION :  TWO TO ONE MULTIPLEXER

    table
    //  A   B   SL  :   Q
        0   0   ?   :   1 ;
        1   1   ?   :   0 ;

        0   ?   1   :   1 ;
        1   ?   1   :   0 ;

        ?   0   0   :   1 ;
        ?   1   0   :   0 ;

    endtable
endprimitive


//---------------  END OF VERILOG PRIMITIVE SECTION --------------------

primitive CMA9_primitive (Y, D0,DB, D3,S01,S11);
output Y;
input D0,DB, D3,S01,S11;


	table
	// D0   DB   D3   S01  S11 :       Y
	   ?    0    ?    0    ?  :       1;
	   ?    1    ?    ?    1  :       0;
	   ?    0    0    1    ?  :       0;
	   1    1    ?    ?    0  :       1;
	   1    ?    1    ?    0  :       1;
	   ?    0    1    ?    ?  :       1;
	   0    1    ?    ?    ?  :       0;
	   0    ?    0    1    ?  :       0;
	   1    ?    ?    0    0  :       1;
	   ?    ?    0    1    1  :       0;

	endtable
endprimitive

primitive CMAF_primitive (Y, D0, D2,  D3, DB, S01, S11);
output Y;
input D0, D2,  D3, DB, S01, S11;


	table
	// D0   D2   D3   DB   S01  S11       Y
	   0    0    0     ?    ?    ? :    0;
	   1    1    1     ?    ?    ? :    1;
	   0    0    ?     ?    0    0 :    0;
	   1    1    ?     ?    0    0 :    1;
	   0    0    ?     1    ?    ? :    0;
	   1    1    ?     1    ?    ? :    1;
	   0    0    ?     ?    0    ? :    0;
	   1    1    ?     ?    0    ? :    1;
	   ?    0    0     ?    1    1 :    0;
	   ?    1    1     ?    1    1 :    1;
	   ?    0    0     0    ?    ? :    0;
	   ?    1    1     0    ?    ? :    1;
	   ?    0    0     ?    ?    1 :    0;
	   ?    1    1     ?    ?    1 :    1;
	   0    ?    0     ?    1    0 :    0;
	   1    ?    1     ?    1    0 :    1;
	   ?    0    ?     0    0    ? :    0;
	   ?    1    ?     0    0    ? :    1;
	   ?    0    ?     1    ?    1 :    0;
	   ?    1    ?     1    ?    1 :    1;
	   ?    0    ?     ?    0    1 :    0;
	   ?    1    ?     ?    0    1 :    1;
	   ?    ?    0     0    1    ? :    0;
	   ?    ?    1     0    1    ? :    1;
	   0    ?    ?     1    ?    0 :    0;
	   1    ?    ?     1    ?    0 :     1;

	endtable
endprimitive

primitive CMB7_primitive (Y, D0, D1, D2, DB, S00, S01, S11);
output Y;
input D0, D1, D2, DB, S00, S01, S11;


   table
	//D0   D1   D2   DB   S00  S01  S11          Y
	  0    0    0    1    ?    ?    ?  :       0;
	  ?    ?    1    0    ?    ?    ?  :      1;
	  ?    0    ?    1    1    1    0  :      0;
	  ?    1    ?    ?    1    1    0  :      1;
	  0    ?    ?    1    0    ?    0  :      0;
	  0    ?    ?    1    ?    0    0  :      0;
	  1    ?    ?    1    0    ?    0  :      1;
	  1    ?    ?    1    ?    0    0  :      1;
	  ?    ?    ?    1    1    1    1  :      0;
	  ?    ?    ?    0    1    1    ?  :      1;
	  ?    ?    0    0    0    ?    ?  :      0;
	  ?    ?    0    0    ?    0    ?  :      0;
	  ?    ?    0    ?    0    ?    1  :      0;
	  ?    ?    0    ?    ?    0    1  :      0;
	  0    ?    0    ?    0    ?    ?  :      0;
	  0    ?    0    ?    ?    0    ?  :      0;
	  1    ?    1    ?    0    ?    ?  :      1;
	  1    ?    1    ?    ?    0    ?  :      1;
	  ?    ?    1    ?    0    ?    1  :      1;
	  ?    ?    1    ?    ?    0    1  :      1;
	  ?    0    ?    1    1    1    ?  :      0;
	  0    0    ?    1    ?    ?    0  :      0;
	  1    1    ?    1    ?    ?    0  :      1;
	  ?    ?    0    1    ?    ?    1  :      0;
	  1    1    1    ?    ?    ?    0  :      1;

	endtable
endprimitive

primitive CMBB_primitive (Y, D0,D1,DB,D3,S00,S01,S11);
output Y;
input D0,D1,DB,D3,S00,S01,S11;


	table
// D0   D1   DB   D3   S00  S01  S11          Y
	0    0    1    0    ?    ?    ? :        0;
	?    ?    0    1    ?    ?    ? :       1;
	?    ?    0    ?    ?    0    ? :       1;
	?    ?    1    ?    ?    0    1 :       0;
	?    ?    0    ?    0    ?    ? :       1;
	?    ?    1    ?    0    ?    1 :       0;
	0    ?    1    ?    ?    0    0 :       0;
	1    ?    ?    ?    ?    0    0 :       1;
	0    ?    1    ?    0    ?    0 :       0;
	1    ?    ?    ?    0    ?    0 :       1;
	?    0    1    ?    1    1    0 :       0;
	?    1    1    ?    1    1    0 :       1;
	?    ?    ?    0    1    1    1 :       0;
	?    ?    ?    1    1    1    1 :       1;
	?    ?    0    0    1    1    ? :       0;
	?    ?    1    0    ?    ?    1 :       0;
	?    0    ?    0    1    1    ? :       0;
	?    1    ?    1    1    1    ? :       1;
	0    ?    1    ?    0    ?    ? :       0;
	0    0    1    ?    ?    ?    0 :       0;
	1    1    1    ?    ?    ?    0 :       1;
	0    ?    1    ?    ?    0    ? :       0;
	1    1    ?    1    ?    ?    0 :       1;

	endtable
endprimitive

primitive CMEA_primitive (Y, DB,D1,D3,S01,S10,S11);
output Y;
input DB,D1,D3,S01,S10,S11;


	table
// DB   D1   D3   S01  S10  S11          Y
	1     ?    ?    ?   ?    ? :       0;
	0     1    1    ?   ?    ? :       1;
	0     0    ?    1   0    0 :       0;
	0     1    ?    ?   0    0 :       1;
	0     ?    0    1   1    ? :       0;
	0     ?    0    1   ?    1 :       0;
	0     ?    ?    0   ?    ? :       1;
	?     0    0    1   ?    ? :       0;
	0     ?    1    ?   1    ? :       1;
	0     ?    1    ?   ?    1 :       1;

   endtable
endprimitive

primitive CMEB_primitive (Y,D0,D1,DB,D3,S01,S10,S11);
output Y;
input D0,D1,DB,D3,S01,S10,S11;


   table
	// D0   D1   DB   D3   S01  S10  S11          Y
	0   0   1   0   ?   ?   ? :        0;
	1   1   0   1   ?   ?   ? :       1;
	0   ?   ?   ?   0   0   0 :       0;
	1   ?   ?   ?   0   0   0 :       1;
	0   ?   1   ?   ?   0   0 :       0;
	1   ?   1   ?   ?   0   0 :       1;
	?   ?   0   1   1   1   ? :       1;
	?   ?   0   1   1   ?   1 :       1;
	?   0   0   ?   1   0   0 :       0;
	?   1   0   ?   1   0   0 :       1;
	?   ?   ?   0   1   1   ? :       0;
	?   ?   ?   0   1   ?   1 :       0;
	?   ?   1   ?   ?   1   ? :       0;
	?   ?   1   ?   ?   ?   1 :       0;
	?   ?   0   ?   0   1   ? :       1;
	?   0   0   0   1   ?   ? :       0;
	?   1   0   1   1   ?   ? :       1;
	0   0   ?   ?   ?   0   0 :       0;
	1   1   ?   ?   ?   0   0 :       1;
	0   ?   1   ?   ?   ?   ? :       0;
	1   ?   0   ?   0   ?   ? :       1;
	?   ?   0   1   ?   1   ? :       1;
	?   ?   0   1   ?   ?   1 :       1;
	?   ?   0   ?   0   ?   1 :       1;
	0   0   ?   0   1   ?   ? :       0;

	endtable
endprimitive

primitive CMEE_primitive (Y,DB, D1, D2, D3, S01,S10, S11);
output Y;
input DB, D1, D2, D3, S01,S10, S11;


   table
	//DB   D1   D2   D3   S01  S10  S11          Y
	1 0 0 0 ? ? ? :       0;
	0 1 1 1 ? ? ? :       1;
	? 0 ? ? 1 0 0 :       0;
	0 1 ? ? 1 0 0 :       1;
	0 ? ? 0 1 1 ? :       0;
	0 ? ? 1 1 1 ? :       1;
	0 ? ? 0 1 ? 1 :       0;
	0 ? ? 1 1 ? 1 :       1;
	1 ? ? ? ? 0 0 :       0;
	0 ? ? ? 0 0 0 :       1;
	? ? 0 ? 0 ? 1 :       0;
	? ? 1 ? 0 ? 1 :       1;
	? ? 0 ? 0 1 ? :       0;
	? ? 1 ? 0 1 ? :       1;
	1 ? 0 ? ? ? 1 :       0;
	1 ? 1 ? ? ? 1 :       1;
	1 ? 0 ? ? 1 ? :       0;
	1 ? 1 ? ? 1 ? :       1;
	1 ? 0 ? ? ? ? :       0;
	0 ? 1 ? 0 ? ? :       1;
	? ? 0 0 ? 1 ? :       0;
	? ? 1 1 ? 1 ? :       1;
	? ? 0 0 ? ? 1 :       0;
	0 0 ? 0 1 ? ? :       0;
	0 1 ? 1 1 ? ? :       1;
	? ? 1 1 ? ? 1 :       1;
	0 1 ? ? ? 0 0 :       1;
	? 0 0 0 1 ? ? :       0;

   endtable
endprimitive




/*--------------------------------------------------------------------
 CELL NAME : AND2
 CELL TYPE : comb
 CELL LOGIC : Y = A & B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND2(Y,A,B);
 input A,B;
 output Y;

 and      U2(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND2FT
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_0(A_, A);
 and      U5(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U9(NET_0_0, A, B);
 and      U10(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3FFT
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3FFT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_1(A_, A);
 not	INV_2(B_, B);
 and      U14(NET_0_0, A_, B_);
 and      U15(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AND3FTT
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B & C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AND3FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_3(A_, A);
 and      U19(NET_0_0, A_, B);
 and      U20(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO21
 CELL TYPE : comb
 CELL LOGIC : Y = (A & B) + (C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO21(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 and      U24(NET_0_0, A, B);
 or       U25(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO21FTF
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO21FTF(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_4(A_, A);
 not	INV_5(C_, C);
 and      U29(NET_0_0, A_, B);
 or       U30(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO21FTT
 CELL TYPE : comb
 CELL LOGIC : Y = !A & B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO21FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_6(A_, A);
 and      U34(NET_0_0, A_, B);
 or       U35(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AO21TTF
 CELL TYPE : comb
 CELL LOGIC : Y = A & B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AO21TTF(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_7(C_, C);
 and      U39(NET_0_0, A, B);
 or       U40(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI21
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !C) + (!B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI21(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_8(A_, A);
 not	INV_9(C_, C);
 not	INV_10(B_, B);
 and      U44(NET_0_0, A_, C_);
 or       U45(Y, NET_0_0, NET_0_1);
 and      U47(NET_0_1, B_, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI21FTF
 CELL TYPE : comb
 CELL LOGIC : Y = (A & C) + (!B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI21FTF(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_11(B_, B);
 and      U51(NET_0_0, A, C);
 or       U52(Y, NET_0_0, NET_0_1);
 and      U54(NET_0_1, B_, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI21FTT
 CELL TYPE : comb
 CELL LOGIC : Y = (A & !C) + (!B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI21FTT(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_12(C_, C);
 not	INV_13(B_, B);
 and      U58(NET_0_0, A, C_);
 or       U59(Y, NET_0_0, NET_0_1);
 and      U61(NET_0_1, B_, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : AOI21TTF
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & C) + (!B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module AOI21TTF(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_14(A_, A);
 not	INV_15(B_, B);
 and      U65(NET_0_0, A_, C);
 or       U66(Y, NET_0_0, NET_0_1);
 and      U68(NET_0_1, B_, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BFR
 CELL TYPE : comb
 CELL LOGIC : Y = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BFR(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : BUBBLE
 CELL TYPE : comb
 CELL LOGIC : Y = !A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module BUBBLE(Y,A);
 input A;
 output Y;

 not	INV_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : DMUX
 CELL TYPE : comb
 CELL LOGIC : Y = A & !S + B & S
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DMUX(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_16(S_, S);
 UDP_MUX2   U71(Y, A, B, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25
 CELL TYPE : comb
 CELL LOGIC : GL = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25(GL,PAD);
 input PAD;
 output GL;

 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25LP
 CELL TYPE : comb
 CELL LOGIC : GL = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25LP(GL,PAD);
 input PAD;
 output GL;

 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25LPU
 CELL TYPE : comb
 CELL LOGIC : GL#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25LPU(GL,PAD);
 input PAD;
 output GL;

 pullup	UP(PAD);
 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL25U
 CELL TYPE : comb
 CELL LOGIC : GL#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL25U(GL,PAD);
 input PAD;
 output GL;

 pullup	UP(PAD);
 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL33
 CELL TYPE : comb
 CELL LOGIC : GL = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL33(GL,PAD);
 input PAD;
 output GL;

 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GL33U
 CELL TYPE : comb
 CELL LOGIC : GL#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GL33U(GL,PAD);
 input PAD;
 output GL;

 pullup	UP(PAD);
 buf	BUF_U_00(GL,PAD);

       specify

		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLINT
 CELL TYPE : comb
 CELL LOGIC : GL = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLINT(GL,A);
 input A;
 output GL;

 buf	BUF_U_00(GL,A);

       specify

		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GND
 CELL TYPE : comb
 CELL LOGIC : Y = 0
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GND(Y);
 output Y;

 supply0	Y;

       specify

		specparam MacroType = "comb";

		//pin to pin path delay 

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25
 CELL TYPE : comb
 CELL LOGIC : Y = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25LP
 CELL TYPE : comb
 CELL LOGIC : Y = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25LP(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25LPU
 CELL TYPE : comb
 CELL LOGIC : Y#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25LPU(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB25U
 CELL TYPE : comb
 CELL LOGIC : Y#up = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB25U(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB33
 CELL TYPE : comb
 CELL LOGIC : Y = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB33(Y,PAD);
 input PAD;
 output Y;

 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IB33U
 CELL TYPE : comb
 CELL LOGIC : Y#UP = PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IB33U(Y,PAD);
 input PAD;
 output Y;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : INV
 CELL TYPE : comb
 CELL LOGIC : Y = !A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module INV(Y,A);
 input A;
 output Y;

 not	INV_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LD
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =EN, D=D ];
-----------------------------------------------------------------*/

module LD(EN, Q,D);
 input D,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(Q, D, EN_, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	buf U_c1 (Enable2, EN);
	buf U_c3 (Enable4, EN);
	buf U_c5 (Enable6, EN);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	(posedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN, 0.0, NOTIFY_REG);
	$hold(negedge EN, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN, 0.0, NOTIFY_REG);
	$hold(negedge EN, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDB
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =EN, CLR=CLR, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDB(SET, CLR, EN, Q,D);
 input D,SET,CLR,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLR(CLR_, CLR);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(Q, D, EN_, CLR, SET, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I1 (_SET, SET);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _SET);
	and U_c1 (Enable2, EN, _CLR, _SET);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, EN, _CLR);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, EN, _SET);
	and U_c6 (Enable7, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !CLR && !SET )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	if(!CLR)
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);
       if(EN && !CLR )
	(negedge SET => (Q+:D)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, negedge EN &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (negedge EN &&& Enable3 , negedge SET, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, negedge EN &&& Enable5, 0.0, NOTIFY_REG);
	$hold (negedge EN &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDBI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, CLK =EN, CLR=CLR, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDBI(SET, CLR, EN, QBAR,D);
 input D,SET,CLR,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLR(CLR_, CLR);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(QBAR_, D, EN_, CLR, SET, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I1 (_SET, SET);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _SET);
	and U_c1 (Enable2, EN, _CLR, _SET);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, EN, _CLR);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, EN, _SET);
	and U_c6 (Enable7, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !CLR && !SET )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(posedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(negedge CLR => (QBAR+:D)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	if(!CLR)
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);
       if(EN && !CLR )
	(negedge SET => (QBAR+:D)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, negedge EN &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (negedge EN &&& Enable3 , negedge SET, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, negedge EN &&& Enable5, 0.0, NOTIFY_REG);
	$hold (negedge EN &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDC
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =EN, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module LDC(CLR, EN, Q,D);
 input D,CLR,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(Q, D, EN_, CLR, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, EN,_CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, EN, _CLR);
	buf U_c5 (Enable6, EN);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, negedge EN, 0.0, NOTIFY_REG);
	$hold (negedge EN, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDCI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, CLK =EN, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module LDCI(CLR, EN, QBAR,D);
 input D,CLR,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(QBAR_, D, EN_, CLR, GND, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, EN,_CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, EN, _CLR);
	buf U_c5 (Enable6, EN);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !CLR )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(posedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(negedge CLR => (QBAR+:D)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, negedge EN, 0.0, NOTIFY_REG);
	$hold (negedge EN, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, CLK =EN, D=D ];
-----------------------------------------------------------------*/

module LDI(EN, QBAR,D);
 input D,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(QBAR_, D, EN_, GND, GND, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	buf U_c1 (Enable2, EN);
	buf U_c3 (Enable4, EN);
	buf U_c5 (Enable6, EN);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	(posedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN, 0.0, NOTIFY_REG);
	$hold(negedge EN, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN, 0.0, NOTIFY_REG);
	$hold(negedge EN, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDL
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=EN, D=D ];
-----------------------------------------------------------------*/

module LDL(EN, Q,D);
 input D,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 DL2C_UDP DL_U0(Q, D, EN, GND, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	buf U_c1 (Enable2, _EN);
	buf U_c3 (Enable4, _EN);
	buf U_c5 (Enable6, _EN);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	(negedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN, 0.0, NOTIFY_REG);
	$hold(posedge EN, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN, 0.0, NOTIFY_REG);
	$hold(posedge EN, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLB
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=EN, CLR=CLR, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDLB(SET, CLR, EN, Q,D);
 input D,SET,CLR,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(Q, D, EN, CLR, SET, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I1 (_SET, SET);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _SET);
	and U_c1 (Enable2, _EN, _CLR, _SET);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _EN, _CLR);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, _EN, _SET);
	and U_c6 (Enable7, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !CLR && !SET )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	if(!CLR)
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);
       if(!EN && !CLR )
	(negedge SET => (Q+:D)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, posedge EN &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (posedge EN &&& Enable3 , negedge SET, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, posedge EN &&& Enable5, 0.0, NOTIFY_REG);
	$hold (posedge EN &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLBI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, _CLK=EN, CLR=CLR, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDLBI(SET, CLR, EN, QBAR,D);
 input D,SET,CLR,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(QBAR_, D, EN, CLR, SET, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I1 (_SET, SET);
	not U_I2 (_CLR, CLR);
	and U_c0 (Enable1, _CLR, _SET);
	and U_c1 (Enable2, _EN, _CLR, _SET);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _EN, _CLR);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, _EN, _SET);
	and U_c6 (Enable7, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !CLR && !SET )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(negedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(negedge CLR => (QBAR+:D)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	if(!CLR)
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);
       if(!EN && !CLR )
	(negedge SET => (QBAR+:D)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, posedge EN &&&  Enable3, 0.0, NOTIFY_REG);
	$hold (posedge EN &&& Enable3 , negedge SET, 0.0, NOTIFY_REG);
	$recovery (negedge CLR, posedge EN &&& Enable5, 0.0, NOTIFY_REG);
	$hold (posedge EN &&& Enable5, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLC
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=EN, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module LDLC(CLR, EN, Q,D);
 input D,CLR,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(Q, D, EN, CLR, GND, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, _EN, _CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _EN, _CLR);
	buf U_c5 (Enable6, _EN);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !CLR )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(negedge CLR => (Q+:D)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, posedge EN, 0.0, NOTIFY_REG);
	$hold (posedge EN, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLCI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, _CLK=EN, CLR=CLR, D=D ];
-----------------------------------------------------------------*/

module LDLCI(CLR, EN, QBAR,D);
 input D,CLR,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_CLR(CLR_, CLR);
 DL2C_UDP DL_U0(QBAR_, D, EN, CLR, GND, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I2 (_CLR, CLR);
	buf U_c0 (Enable1,_CLR);
	and U_c1 (Enable2, _EN, _CLR);
	buf U_c2 (Enable3, _CLR);
	and U_c3 (Enable4, _EN, _CLR);
	buf U_c5 (Enable6, _EN);
	buf U_c6 (Enable7, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !CLR )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(negedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(negedge CLR => (QBAR+:D)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	$recovery (negedge CLR, posedge EN, 0.0, NOTIFY_REG);
	$hold (posedge EN, negedge CLR, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, _CLK=EN, D=D ];
-----------------------------------------------------------------*/

module LDLI(EN, QBAR,D);
 input D,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 DL2C_UDP DL_U0(QBAR_, D, EN, GND, GND, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	buf U_c1 (Enable2, _EN);
	buf U_c3 (Enable4, _EN);
	buf U_c5 (Enable6, _EN);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	(negedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN, 0.0, NOTIFY_REG);
	$hold(posedge EN, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN, 0.0, NOTIFY_REG);
	$hold(posedge EN, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN, 0.0, 0, NOTIFY_REG);


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLS
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,_CLK=EN, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDLS(SET, EN, Q,D);
 input D,SET,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 DL2C_UDP DL_U0(Q, D, EN, GND, SET, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I1 (_SET, SET);
	buf U_c0 (Enable1,_SET);
	and U_c1 (Enable2, _EN, _SET);
	buf U_c3 (Enable4, _EN);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, _EN, _SET);
	buf U_c6 (Enable7, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !SET )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(negedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);
       if(!EN )
	(negedge SET => (Q+:D)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, posedge EN, 0.0, NOTIFY_REG);
	$hold (posedge EN, negedge SET, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDLSI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, _CLK=EN, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDLSI(SET, EN, QBAR,D);
 input D,SET,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 DL2C_UDP DL_U0(QBAR_, D, EN, GND, SET, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I0 (_EN, EN);
	not U_I1 (_SET, SET);
	buf U_c0 (Enable1,_SET);
	and U_c1 (Enable2, _EN, _SET);
	buf U_c3 (Enable4, _EN);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, _EN, _SET);
	buf U_c6 (Enable7, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(!EN && !SET )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(negedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);
       if(!EN )
	(negedge SET => (QBAR+:D)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,posedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(negedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, posedge EN, 0.0, NOTIFY_REG);
	$hold (posedge EN, negedge SET, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDS
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[Q=Q,CLK =EN, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDS(SET, EN, Q,D);
 input D,SET,EN;
 output Q;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(Q, D, EN_, GND, SET, NOTIFY_REG);

// some temp signals created for timing checking sections

	not U_I1 (_SET, SET);
	buf U_c0 (Enable1,_SET);
	and U_c1 (Enable2, EN, _SET);
	buf U_c3 (Enable4, EN);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, EN, _SET);
	buf U_c6 (Enable7, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_Q = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_Q = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_Q = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !SET )
        (D => Q) = (tpdLH_D_to_Q, tpdHL_D_to_Q);

	if(Enable1)
	(posedge EN => (Q+:D))=(tpdLH_EN_to_Q, tpdHL_EN_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);
       if(EN )
	(negedge SET => (Q+:D)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, negedge EN, 0.0, NOTIFY_REG);
	$hold (negedge EN, negedge SET, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*---------------------------------------------------------------
 CELL NAME : LDSI
 CELL TYPE : D-Latch Logic
 CELL SEQ EQN : DL[QN=QBAR, CLK =EN, PRE=SET, D=D ];
-----------------------------------------------------------------*/

module LDSI(SET, EN, QBAR,D);
 input D,SET,EN;
 output QBAR;
 supply1 VCC;
 supply0 GND;
 reg NOTIFY_REG;

 not INV_PRE(SET_, SET);
 not INV_CLK(EN_, EN);
 DL2C_UDP DL_U0(QBAR_, D, EN_, GND, SET, NOTIFY_REG);
  not INV_Q(QBAR, QBAR_);

// some temp signals created for timing checking sections

	not U_I1 (_SET, SET);
	buf U_c0 (Enable1,_SET);
	and U_c1 (Enable2, EN, _SET);
	buf U_c3 (Enable4, EN);
	buf U_c4 (Enable5, _SET);
	and U_c5 (Enable6, EN, _SET);
	buf U_c6 (Enable7, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam    libname	="A500K";
	specparam    macroType   ="seq_dlatch";
	specparam    InputLoad$EN = 0.0;
	specparam    InputLoad$SET = 0.0;
	specparam    InputLoad$D = 0.0;
        specparam    tpdLH_D_to_QBAR = (0.1:0.1:0.1);
        specparam    tpdHL_D_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_EN_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam    tpdHL_SET_to_QBAR = (0.1:0.1:0.1);

        //check timing delay for output



	if(EN && !SET )
        (D => QBAR) = (tpdLH_D_to_QBAR, tpdHL_D_to_QBAR);

	if(Enable1)
	(posedge EN => (QBAR+:D))=(tpdLH_EN_to_QBAR, tpdHL_EN_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);
       if(EN )
	(negedge SET => (QBAR+:D)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$setup(negedge D,negedge EN &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge EN &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	// check signal width

	$width(posedge EN &&& Enable1, 0.0, 0, NOTIFY_REG);
	$width(posedge SET, 0.0, 0, NOTIFY_REG);

	$recovery (negedge SET, negedge EN, 0.0, NOTIFY_REG);
	$hold (negedge EN, negedge SET, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MUX2H
 CELL TYPE : comb
 CELL LOGIC : Y = (A & !S) + (B & S)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MUX2H(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_17(S_, S);
 UDP_MUX2   U75(Y, A, B, S_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : MUX2L
 CELL TYPE : comb
 CELL LOGIC : Y = A & S + B & !S
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module MUX2L(Y,A,S,B);
 input A,S,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_18(S_, S);
 UDP_MUX2   U79(Y, A, B, S);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_S_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_S_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(S => Y ) = ( tpdLH_S_to_Y, tpdHL_S_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND2
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND2(Y,A,B);
 input A,B;
 output Y;

 not	INV_19(A_, A);
 not	INV_20(B_, B);
 or       U83(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND2FT
 CELL TYPE : comb
 CELL LOGIC : Y = A + !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_21(B_, B);
 or       U86(Y, A, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_22(A_, A);
 not	INV_23(B_, B);
 not	INV_24(C_, C);
 or       U90(NET_0_0, A_, B_);
 or       U91(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3FFT
 CELL TYPE : comb
 CELL LOGIC : Y = A + B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3FFT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_25(C_, C);
 or       U95(NET_0_0, A, B);
 or       U96(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NAND3FTT
 CELL TYPE : comb
 CELL LOGIC : Y = A + !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NAND3FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_26(B_, B);
 not	INV_27(C_, C);
 or       U100(NET_0_0, A, B_);
 or       U101(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR2
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR2(Y,A,B);
 input A,B;
 output Y;

 not	INV_28(A_, A);
 not	INV_29(B_, B);
 and      U104(Y, A_, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR2FT
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_30(B_, B);
 and      U107(Y, A, B_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_31(A_, A);
 not	INV_32(B_, B);
 not	INV_33(C_, C);
 and      U111(NET_0_0, A_, B_);
 and      U112(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3FFT
 CELL TYPE : comb
 CELL LOGIC : Y = A & B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3FFT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_34(C_, C);
 and      U116(NET_0_0, A, B);
 and      U117(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NOR3FTT
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B & !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NOR3FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_35(B_, B);
 not	INV_36(C_, C);
 and      U121(NET_0_0, A, B_);
 and      U122(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : NUBBLE
 CELL TYPE : comb
 CELL LOGIC : Y = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module NUBBLE(Y,A);
 input A;
 output Y;

 buf	BUF_U_00(Y,A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA21
 CELL TYPE : comb
 CELL LOGIC : Y = (A & C) + (B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA21(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 and      U126(NET_0_0, A, C);
 or       U127(Y, NET_0_0, NET_0_1);
 and      U129(NET_0_1, B, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA21FTF
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & !C) + (B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA21FTF(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_37(A_, A);
 not	INV_38(C_, C);
 and      U133(NET_0_0, A_, C_);
 or       U134(Y, NET_0_0, NET_0_1);
 and      U136(NET_0_1, B, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA21FTT
 CELL TYPE : comb
 CELL LOGIC : Y = (!A & C) + (B & C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA21FTT(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_39(A_, A);
 and      U140(NET_0_0, A_, C);
 or       U141(Y, NET_0_0, NET_0_1);
 and      U143(NET_0_1, B, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OA21TTF
 CELL TYPE : comb
 CELL LOGIC : Y = (A & !C) + (B & !C)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OA21TTF(Y,A,C,B);
 input A,C,B;
 output Y;
 wire NET_0_0, NET_0_1;

 not	INV_40(C_, C);
 and      U147(NET_0_0, A, C_);
 or       U148(Y, NET_0_0, NET_0_1);
 and      U150(NET_0_1, B, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI21
 CELL TYPE : comb
 CELL LOGIC : Y = !A & !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI21(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_41(A_, A);
 not	INV_42(B_, B);
 not	INV_43(C_, C);
 and      U154(NET_0_0, A_, B_);
 or       U155(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI21FTF
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI21FTF(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_44(B_, B);
 and      U159(NET_0_0, A, B_);
 or       U160(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI21FTT
 CELL TYPE : comb
 CELL LOGIC : Y = A & !B + !C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI21FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_45(B_, B);
 not	INV_46(C_, C);
 and      U164(NET_0_0, A, B_);
 or       U165(Y, NET_0_0, C_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OAI21TTF
 CELL TYPE : comb
 CELL LOGIC : Y = C + !A & !B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OAI21TTF(Y,C,A,B);
 input C,A,B;
 output Y;
 wire NET_0_0;

 not	INV_47(A_, A);
 not	INV_48(B_, B);
 or       U168(Y, C, NET_0_0);
 and      U170(NET_0_0, A_, B_);

       specify

		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25HH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25HH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25HL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25HL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25HN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25HN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPHH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPHL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPHN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPLH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPLL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB25LPLN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33LH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33LH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33LL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33LL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33LN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33LN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33PH
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33PH(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33PL
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33PL(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OB33PN
 CELL TYPE : comb
 CELL LOGIC : PAD = A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OB33PN(PAD,A);
 input A;
 output PAD;

 buf	BUF_U_00(PAD,A);

       specify

		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => PAD ) = ( tpdLH_A_to_PAD, tpdHL_A_to_PAD );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR2
 CELL TYPE : comb
 CELL LOGIC : Y = A + B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR2(Y,A,B);
 input A,B;
 output Y;

 or       U173(Y, A, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR2FT
 CELL TYPE : comb
 CELL LOGIC : Y = !A + B
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_49(A_, A);
 or       U176(Y, A_, B);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3
 CELL TYPE : comb
 CELL LOGIC : Y = A + B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 or       U180(NET_0_0, A, B);
 or       U181(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3FFT
 CELL TYPE : comb
 CELL LOGIC : Y = !A + !B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3FFT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_50(A_, A);
 not	INV_51(B_, B);
 or       U185(NET_0_0, A_, B_);
 or       U186(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OR3FTT
 CELL TYPE : comb
 CELL LOGIC : Y = !A + B + C
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OR3FTT(Y,A,B,C);
 input A,B,C;
 output Y;
 wire NET_0_0;

 not	INV_52(A_, A);
 or       U190(NET_0_0, A_, B);
 or       U191(Y, NET_0_0, C);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_C_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_C_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
		(C => Y ) = ( tpdLH_C_to_Y, tpdHL_C_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : PWR
 CELL TYPE : comb
 CELL LOGIC : Y = 1
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module PWR(Y);
 output Y;

 supply1    Y;

       specify

		specparam MacroType = "comb";

		//pin to pin path delay 

   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XNOR2
 CELL TYPE : comb
 CELL LOGIC : Y = !(A ^ B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XNOR2(Y,A,B);
 input A,B;
 output Y;

 not	INV_53(A_, A);
 not	INV_54(B_, B);
 UDPN_MUX2  U194(Y, B, B_, A_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XNOR2FT
 CELL TYPE : comb
 CELL LOGIC : Y = !(!A ^ B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XNOR2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_55(A_, A);
 not	INV_56(B_, B);
 UDPN_MUX2  U198(Y, B, B_, A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XOR2
 CELL TYPE : comb
 CELL LOGIC : Y = (A ^ B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XOR2(Y,A,B);
 input A,B;
 output Y;

 not	INV_57(A_, A);
 not	INV_58(B_, B);
 UDP_MUX2   U202(Y, B, B_, A_);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : XOR2FT
 CELL TYPE : comb
 CELL LOGIC : Y = (!A ^ B)
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module XOR2FT(Y,A,B);
 input A,B;
 output Y;

 not	INV_59(A_, A);
 not	INV_60(B_, B);
 UDP_MUX2   U206(Y, B, B_, A);

       specify

		specparam tpdLH_A_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_A_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_B_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_B_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(A => Y ) = ( tpdLH_A_to_Y, tpdHL_A_to_Y );
		(B => Y ) = ( tpdLH_B_to_Y, tpdHL_B_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFF
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFF(CLK, Q,D);
 input D,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(Q, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, CLR=CLR, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFB(SET, CLR, CLK, Q,D);
 input D,SET,CLR,CLK;
 output Q;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);
 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(Q, D,CLK,CLR_0, SET_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_SET, SET);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, _CLR, _SET);
       buf U_c2 (Enable2, _CLR);
       buf U_c4 (Enable4, _SET);
      and U_c6 (Enable5, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK &&& Enable2, negedge SET,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFBI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, CLK =CLK, CLR=CLR, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFBI(SET, CLR, CLK, QBAR,D);
 input D,SET,CLR,CLK;
 output QBAR;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);
 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(q_tmp, D,CLK,CLR_0, SET_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I1 (_SET, SET);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, _CLR, _SET);
       buf U_c2 (Enable2, _CLR);
       buf U_c4 (Enable4, _SET);
      and U_c6 (Enable5, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK &&& Enable2, negedge SET,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable4, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, posedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, posedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFC(CLR, CLK, Q,D);
 input D,CLR,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(Q, D,CLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,_CLR);
       buf U_c2 (Enable2, _CLR);
      buf U_c6 (Enable5, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFCI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, CLK =CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFCI(CLR, CLK, QBAR,D);
 input D,CLR,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpr DF_0(q_tmp, D,CLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,_CLR);
       buf U_c2 (Enable2, _CLR);
      buf U_c6 (Enable5, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(posedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, CLK =CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFI(CLK, QBAR,D);
 input D,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpr DF_0(q_tmp, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK, 0.0, NOTIFY_REG);
	$hold(posedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFL
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFL(CLK, Q,D);
 input D,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(Q, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLB
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, CLR=CLR, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLB(SET, CLR, CLK, Q,D);
 input D,SET,CLR,CLK;
 output Q;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);
 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(Q, D,CLK,CLR_0, SET_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_SET, SET);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, _CLR, _SET);
       buf U_c2 (Enable2, _CLR);
       buf U_c4 (Enable4, _SET);
      and U_c6 (Enable5, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK &&& Enable2, negedge SET,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLBI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, _CLK=CLK, CLR=CLR, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLBI(SET, CLR, CLK, QBAR,D);
 input D,SET,CLR,CLK;
 output QBAR;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);
 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(q_tmp, D,CLK,CLR_0, SET_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_SET, SET);
      not U_I2 (_CLR, CLR);
      and U_c0 (Enable1, _CLR, _SET);
       buf U_c2 (Enable2, _CLR);
       buf U_c4 (Enable4, _SET);
      and U_c6 (Enable5, _CLR, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK &&& Enable2, negedge SET,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable4, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);
	$width(posedge SET &&& _CLR,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, negedge CLK &&& Enable2, 0.0, NOTIFY_REG);
	$recovery(negedge CLR, negedge CLK &&& Enable4, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLC
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLC(CLR, CLK, Q,D);
 input D,CLR,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(Q, D,CLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,_CLR);
       buf U_c2 (Enable2, _CLR);
      buf U_c6 (Enable5, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge CLR => (Q +: 1'b0)) = (tpdLH_CLR_to_Q, tpdHL_CLR_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLCI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, _CLK=CLK, CLR=CLR, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLCI(CLR, CLK, QBAR,D);
 input D,CLR,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_CLR_0(CLR_0, CLR);

 Dffpf DF_0(q_tmp, D,CLK,CLR_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I2 (_CLR, CLR);
      buf U_c0 (Enable1,_CLR);
       buf U_c2 (Enable2, _CLR);
      buf U_c6 (Enable5, _CLR);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_CLR_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLR_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge CLR => (QBAR +: 1'b0)) = (tpdLH_CLR_to_QBAR, tpdHL_CLR_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals

	$hold(negedge CLK, negedge CLR,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge CLR, 0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge CLR, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, _CLK=CLK, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLI(CLK, QBAR,D);
 input D,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;


 Dffpf DF_0(q_tmp, D,CLK,VCC_0, VCC_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK, 0.0, NOTIFY_REG);
	$hold(negedge CLK, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	//checking the pulse width

	$width(posedge CLK,0,  0, NOTIFY_REG);
	$width(negedge CLK, 0, 0, NOTIFY_REG);

	//checing the recovery data


 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLS
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,_CLK=CLK, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLS(SET, CLK, Q,D);
 input D,SET,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);

 Dffpf DF_0(Q, D,CLK,VCC_0, SET_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_SET, SET);
      buf U_c0 (Enable1, _SET);
       buf U_c4 (Enable4, _SET);
       buf U_c6 (Enable5, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK, negedge SET,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge SET,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFLSI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, _CLK=CLK, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFLSI(SET, CLK, QBAR,D);
 input D,SET,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);

 Dffpf DF_0(q_tmp, D,CLK,VCC_0, SET_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I0 (_CLK, CLK);
      not U_I1 (_SET, SET);
      buf U_c0 (Enable1, _SET);
       buf U_c4 (Enable4, _SET);
       buf U_c6 (Enable5, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(negedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,negedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(negedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(negedge CLK, negedge SET,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge SET,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, negedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFS
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[Q=Q,CLK =CLK, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFS(SET, CLK, Q,D);
 input D,SET,CLK;
 output Q;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);

 Dffpr DF_0(Q, D,CLK,VCC_0, SET_0, GND_0, NOTIFY_REG);

// some temp signals created for timing checking sections

      not U_I1 (_SET, SET);
      buf U_c0 (Enable1, _SET);
       buf U_c4 (Enable4, _SET);
       buf U_c6 (Enable5, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_Q = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_Q = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_Q = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (Q +: D))=(tpdLH_CLK_to_Q, tpdHL_CLK_to_Q);
	(posedge SET => (Q +: 1'b1)) = (tpdLH_SET_to_Q, tpdHL_SET_to_Q);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, negedge SET,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge SET,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------
 CELL NAME : DFFSI
 CELL TYPE : sequential Logic
 CELL SEQ EQN : DFF[QN=QBAR, CLK =CLK, PRE=SET, D=D ];
----------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module DFFSI(SET, CLK, QBAR,D);
 input D,SET,CLK;
 output QBAR;
 supply1 VCC_0;
 supply0 GND_0;
 reg NOTIFY_REG;

 not INV_PRE_0(SET_0, SET);

 Dffpr DF_0(q_tmp, D,CLK,VCC_0, SET_0, GND_0, NOTIFY_REG);
  not INV_Q_0(QBAR,q_tmp);

// some temp signals created for timing checking sections

      not U_I1 (_SET, SET);
      buf U_c0 (Enable1, _SET);
       buf U_c4 (Enable4, _SET);
       buf U_c6 (Enable5, _SET);

//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

 specify

	specparam   tpdLH_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_CLK_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdLH_SET_to_QBAR = (0.1:0.1:0.1);
	specparam   tpdHL_SET_to_QBAR = (0.1:0.1:0.1);



	//check timing delay for output

	(posedge CLK => (QBAR +: D))=(tpdLH_CLK_to_QBAR, tpdHL_CLK_to_QBAR);
	(posedge SET => (QBAR +: 1'b1)) = (tpdLH_SET_to_QBAR, tpdHL_SET_to_QBAR);

	//checking setup and hold timing for inputs

	$setup(posedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$setup(negedge D,posedge CLK &&& Enable1, 0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, posedge D,0.0, NOTIFY_REG);
	$hold(posedge CLK &&& Enable1, negedge D,0.0, NOTIFY_REG);

	//checking timing for control signals


	$hold(posedge CLK, negedge SET,0.0, NOTIFY_REG);

	//checking the pulse width

	$width(posedge CLK &&& Enable5 ,0,  0, NOTIFY_REG);
	$width(negedge CLK &&& Enable5, 0, 0, NOTIFY_REG);
	$width(posedge SET,  0.0, 0, NOTIFY_REG);

	//checing the recovery data

	$recovery(negedge SET, posedge CLK, 0.0, NOTIFY_REG);

 endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25LP
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25LP(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25LPU
 CELL TYPE : comb
 CELL LOGIC : Y#up=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25LPU(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB25U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB25U(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB33
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB33(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLIB33U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=A
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLIB33U(Y,GL,PAD,A);
 input PAD,A;
 output Y,GL;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 buf	BUF_U_01(GL,A);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_61(EN_, EN);
 UDP_MUX2   U210(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB33
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB33(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_62(EN_, EN);
 UDP_MUX2   U214(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25LP
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25LP(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_63(EN_, EN);
 UDP_MUX2   U218(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25U(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_64(EN_, EN);
 UDP_MUX2   U222(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB33U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB33U(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_65(EN_, EN);
 UDP_MUX2   U226(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIB25LPU
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & !EN + A & EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIB25LPU(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_66(EN_, EN);
 UDP_MUX2   U230(GL, PAD, A, EN_);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_67(EN_, EN);
 UDP_MUX2   U234(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL33
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL33(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_68(EN_, EN);
 UDP_MUX2   U238(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25LP
 CELL TYPE : comb
 CELL LOGIC : Y=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25LP(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 buf	BUF_U_00(Y,PAD);
 not	INV_69(EN_, EN);
 UDP_MUX2   U242(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25LPU
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25LPU(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_70(EN_, EN);
 UDP_MUX2   U246(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL33U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL33U(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_71(EN_, EN);
 UDP_MUX2   U250(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : GLMIBL25U
 CELL TYPE : comb
 CELL LOGIC : Y#UP=PAD ; GL=PAD & EN + A & !EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module GLMIBL25U(Y,GL,PAD,EN,A);
 input PAD,EN,A;
 output Y,GL;
 wire NET_1_0, NET_1_1;

 pullup	UP(PAD);
 buf	BUF_U_00(Y,PAD);
 not	INV_72(EN_, EN);
 UDP_MUX2   U254(GL, PAD, A, EN);

       specify

		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_EN_to_GL = (0.1:0.1:0.1);
		specparam tpdLH_A_to_GL = (0.1:0.1:0.1);
		specparam tpdHL_A_to_GL = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
		(PAD => GL ) = ( tpdLH_PAD_to_GL, tpdHL_PAD_to_GL );
		(EN => GL ) = ( tpdLH_EN_to_GL, tpdHL_EN_to_GL );
		(A => GL ) = ( tpdLH_A_to_GL, tpdHL_A_to_GL );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U258(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U261(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U264(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U267(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U270(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U273(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U276(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U279(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25HNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25HNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U282(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U285(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U288(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U291(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U294(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U297(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U300(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U303(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U306(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U309(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U312(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U315(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPHNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPHNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U318(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U321(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U324(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB25LPLNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB25LPLNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U327(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U330(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U333(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U336(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U339(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U342(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 bufif1   U345(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U348(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U351(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33LNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33LNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U354(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U357(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U360(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOB33PNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOB33PNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 bufif1   U363(PAD, A, EN);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_73(EN_, EN);
 bufif1   U366(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_74(EN_, EN);
 bufif1   U369(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_75(EN_, EN);
 bufif1   U372(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_76(EN_, EN);
 bufif1   U375(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_77(EN_, EN);
 bufif1   U378(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_78(EN_, EN);
 bufif1   U381(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_79(EN_, EN);
 bufif1   U384(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_80(EN_, EN);
 bufif1   U387(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25HNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25HNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_81(EN_, EN);
 bufif1   U390(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_82(EN_, EN);
 bufif1   U393(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_83(EN_, EN);
 bufif1   U396(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_84(EN_, EN);
 bufif1   U399(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_85(EN_, EN);
 bufif1   U402(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_86(EN_, EN);
 bufif1   U405(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_87(EN_, EN);
 bufif1   U408(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_88(EN_, EN);
 bufif1   U411(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_89(EN_, EN);
 bufif1   U414(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_90(EN_, EN);
 bufif1   U417(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_91(EN_, EN);
 bufif1   U420(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_92(EN_, EN);
 bufif1   U423(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPHNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPHNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_93(EN_, EN);
 bufif1   U426(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_94(EN_, EN);
 bufif1   U429(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_95(EN_, EN);
 bufif1   U432(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL25LPLNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL25LPLNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_96(EN_, EN);
 bufif1   U435(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_97(EN_, EN);
 bufif1   U438(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_98(EN_, EN);
 bufif1   U441(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_99(EN_, EN);
 bufif1   U444(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PH(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_100(EN_, EN);
 bufif1   U447(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PL(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_101(EN_, EN);
 bufif1   U450(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PN(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 not	INV_102(EN_, EN);
 bufif1   U453(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_103(EN_, EN);
 bufif1   U456(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_104(EN_, EN);
 bufif1   U459(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33LNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33LNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_105(EN_, EN);
 bufif1   U462(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PHU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PHU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_106(EN_, EN);
 bufif1   U465(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PLU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PLU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_107(EN_, EN);
 bufif1   U468(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : IOBL33PNU
 CELL TYPE : comb
 CELL LOGIC : PAD#UP=A@!EN ; Y=PAD
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module IOBL33PNU(Y,A,EN,PAD);
 input A,EN;
 output Y;
 inout PAD;

 tri1 PAD;
 not	INV_108(EN_, EN);
 bufif1   U471(PAD, A, EN_);
 buf	BUF_U_01(Y,PAD);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_PAD_to_Y = (0.1:0.1:0.1);
		specparam tpdHL_PAD_to_Y = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
		(A => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(EN => Y ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(PAD => Y ) = ( tpdLH_PAD_to_Y, tpdHL_PAD_to_Y );
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25HH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25HH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U474(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25HL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25HL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U477(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25HN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25HN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U480(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U483(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U486(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U489(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPLH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U492(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPLL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U495(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPLN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U498(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPHH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U501(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPHL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U504(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB25LPHN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U507(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33LH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U510(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33LL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U513(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33LN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U516(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33PH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33PH(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U519(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33PL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33PL(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U522(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTB33PN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTB33PN(PAD,A,EN);
 input A,EN;
 output PAD;

 bufif1   U525(PAD, A, EN);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25HH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25HH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_109(EN_, EN);
 bufif1   U528(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25HL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25HL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_110(EN_, EN);
 bufif1   U531(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25HN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25HN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_111(EN_, EN);
 bufif1   U534(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_112(EN_, EN);
 bufif1   U537(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_113(EN_, EN);
 bufif1   U540(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_114(EN_, EN);
 bufif1   U543(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPLH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPLH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_115(EN_, EN);
 bufif1   U546(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPLL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPLL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_116(EN_, EN);
 bufif1   U549(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPLN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPLN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_117(EN_, EN);
 bufif1   U552(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPHH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPHH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_118(EN_, EN);
 bufif1   U555(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPHL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPHL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_119(EN_, EN);
 bufif1   U558(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL25LPHN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL25LPHN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_120(EN_, EN);
 bufif1   U561(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33LH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33LH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_121(EN_, EN);
 bufif1   U564(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33LL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33LL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_122(EN_, EN);
 bufif1   U567(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33LN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33LN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_123(EN_, EN);
 bufif1   U570(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33PH
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33PH(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_124(EN_, EN);
 bufif1   U573(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33PL
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33PL(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_125(EN_, EN);
 bufif1   U576(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults



/*--------------------------------------------------------------------
 CELL NAME : OTBL33PN
 CELL TYPE : comb
 CELL LOGIC : PAD=A@!EN
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

module OTBL33PN(PAD,A,EN);
 input A,EN;
 output PAD;

 not	INV_126(EN_, EN);
 bufif1   U579(PAD, A, EN_);

       specify

                specparam tpdLH_EN_to_PAD = (0.0:0.0:0.0);
                specparam tpdHL_EN_to_PAD = (0.0:0.0:0.0);
		specparam tpdLZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZL_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdHZ_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdZH_EN_to_PAD = (0.1:0.1:0.1);
		specparam tpdLH_A_to_PAD = (0.1:0.1:0.1);
		specparam tpdHL_A_to_PAD = (0.1:0.1:0.1);
		specparam MacroType = "comb";

		//pin to pin path delay 

	    //if(~A)
		(EN => PAD ) = ( tpdLH_EN_to_PAD,tpdHL_EN_to_PAD,tpdLZ_EN_to_PAD,tpdZH_EN_to_PAD,tpdHZ_EN_to_PAD,tpdZL_EN_to_PAD);

	        (A => PAD ) = ( tpdLH_A_to_PAD,tpdHL_A_to_PAD);
   endspecify

endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

//------------------------
// CELL NAME: UJTAG
//------------------------

/*
 * Simple TAP for simulation of designs using the ProASIC user JTAG interface
 * Note:
 * 1. This TAP is not a model of the actual TAP used in the ProASIC. The
 *    only instruction implemented is BYPASS. An instruction scan operation
 *    will capture the pattern 8'bxxxxxx01
 * 2. This model is meant for the A500K family only.  It should not be used
 *    for the APA family, as it uses a different set of interface signals.
 *
 */

`timescale 1ns/10ps

`define Bypass 8'hff

`define Test_Logic_Reset        4'hf
`define Run_Test_Idle           4'hc
`define Select_DR                       4'h7
`define Capture_DR                      4'h6
`define Shift_DR                                4'h2
`define Exit1_DR                                4'h1
`define Pause_DR                                4'h3
`define Exit2_DR                                4'h0
`define Update_DR                       4'h5
`define Select_IR                       4'h4
`define Capture_IR                      4'he
`define Shift_IR                                4'ha
`define Exit1_IR                                4'h9
`define Pause_IR                                4'hb
`define Exit2_IR                                4'h8
`define Update_IR                       4'hd


module UJTAG(UIREG0, UIREG1, UIREG2, UIREG3, UIREG4, UIREG5, UIREG6, UIREG7,
URSTB, UDRCK, UDRSH, UDRUPD, UTDI, UTDO,
TDO, TMS, TDI, TCK, TRSTB);

output UIREG0, UIREG1, UIREG2, UIREG3, UIREG4, UIREG5, UIREG6, UIREG7;

output UTDI, URSTB, UDRCK, UDRSH, UDRUPD;
input UTDO;

input TMS, TDI, TCK, TRSTB;
output TDO;


reg [3:0] STATE;
reg [7:0] IR, SHREG;
reg TDO, UDRUPD, UDRSH;

assign {UIREG7,UIREG6,UIREG5,UIREG4,UIREG3,UIREG2,UIREG1,UIREG0} = IR;
assign UTDI = TDI;
assign UDRCK = TCK || !((STATE == `Shift_DR) || (STATE == `Capture_DR));
assign URSTB = STATE != `Test_Logic_Reset;


always @(negedge TCK or negedge TRSTB)
begin
        if (!TRSTB) begin
                UDRUPD <= 0;
                UDRSH  <= 0;
        end else begin
                UDRUPD <= (STATE == `Update_DR);
                UDRSH  <= (STATE == `Shift_DR);
        end
end

always @(posedge TCK or negedge TRSTB)
begin
        if (!TRSTB)
                STATE <= `Test_Logic_Reset;
        else case (STATE)
                `Test_Logic_Reset: STATE <= TMS ? `Test_Logic_Reset : `Run_Test_Idle;
                `Run_Test_Idle    : STATE <= TMS ? `Select_DR : `Run_Test_Idle;
                `Select_DR           : STATE <= TMS ? `Select_IR : `Capture_DR;
                `Capture_DR,
      `Shift_DR           : STATE <= TMS ? `Exit1_DR : `Shift_DR;
                `Exit1_DR            : STATE <= TMS ? `Update_DR : `Pause_DR;
                `Pause_DR        : STATE <= TMS ? `Exit2_DR : `Pause_DR;
                `Exit2_DR            : STATE <= TMS ? `Update_DR : `Shift_DR;
                `Select_IR           : STATE <= TMS ? `Test_Logic_Reset :  `Capture_IR;
                `Capture_IR,
                `Shift_IR            : STATE <= TMS ? `Exit1_IR : `Shift_IR;
                `Exit1_IR        : STATE <= TMS ? `Update_IR : `Pause_IR;
                `Pause_IR            : STATE <= TMS ? `Exit2_IR : `Pause_IR;
                `Exit2_IR            : STATE <= TMS ? `Update_IR : `Shift_IR;
           `Update_DR,
           `Update_IR        : STATE <= TMS ? `Select_DR : `Run_Test_Idle;

                endcase
end

always @(posedge TCK)
case (STATE)
                `Capture_IR : SHREG <=  8'bxxxxxx01;
                `Capture_DR : SHREG <=  8'b00000000;
                `Shift_IR,
                `Shift_DR   : SHREG <= { TDI, SHREG[7:1] };
endcase

always @(negedge TCK or negedge TRSTB)
begin
  if (!TRSTB) begin
         IR <= `Bypass;
         TDO <= 'bz;
  end else if (STATE == `Shift_IR)
         TDO <= SHREG[0];
  else if (STATE == `Shift_DR)
        casez (IR)
          8'b01??????,
          8'b0?1?????,
          8'b0??1????:       TDO <= UTDO;
          default:           TDO <= SHREG[7];
        endcase
  else if (STATE == `Update_IR) begin
                TDO <= 'bz;
                IR <= SHREG;
  end else
                TDO <= 'bz;
end

endmodule



`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ps / 1 ps

 module RAM256x9AA(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, WPE, RPE, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RBLKB, WBLKB, PARODD;
 output  WPE, RPE, DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;
 reg WB_dlyd;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg ADDRS_MATCH;
 
 time RDB_re;
 time RDB_fe;
 time WRB_re;
 time WRB_fe;
 time WB_re;
 time WB_fe;
 time RBLKB_re;
 time RBLKB_fe;
 time WBLKB_re;
 time WBLKB_fe;
 time RADDR_change;
 time ADDRS_MATCH_re;
 time ADDRS_MATCH_fe;

 integer Write_OK;
 
/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);
 //buf #10 WBDELAYBUF ( WB_dlyd, WB_int );

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RBLKB_int, RBLKB);
 buf BUF_U30 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U31 (WPE, WPE_int);
 buf OUTBUF_U32 (RPE, RPE_int);
 buf OUTBUF_U33 (DOS, DIS_int);
 buf OUTBUF_U34 (DO0, DO0_int);
 buf OUTBUF_U35 (DO1, DO1_int);
 buf OUTBUF_U36 (DO2, DO2_int);
 buf OUTBUF_U37 (DO3, DO3_int);
 buf OUTBUF_U38 (DO4, DO4_int);
 buf OUTBUF_U39 (DO5, DO5_int);
 buf OUTBUF_U40 (DO6, DO6_int);
 buf OUTBUF_U41 (DO7, DO7_int);
 buf OUTBUF_U42 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    
/************************ edge detect section *********************************/

 always @ ( RDB_int )
 begin
   if ( RDB_int == 1'b1 )
     RDB_re = $time;
   else if ( RDB_int == 1'b0 )
     RDB_fe = $time;
 end

 always @ ( WRB_int )
 begin
   if ( WRB_int == 1'b1 )
     WRB_re = $time;
   else if ( WRB_int == 1'b0 )
     WRB_fe = $time;
 end

 always @ ( RBLKB_int )
 begin
   if ( RBLKB_int == 1'b1 )
     RBLKB_re = $time;
   else if ( RBLKB_int == 1'b0 ) 
     RBLKB_fe = $time;
 end

 always @ ( WBLKB_int )
 begin
   if ( WBLKB_int == 1'b1 )
     WBLKB_re = $time;
   else if ( WBLKB_int == 1'b0 )
     WBLKB_fe = $time;
 end

 always @ ( WB_int )
 begin
   WB_dlyd <= #1 WB_int;
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end

 always @ ( `RAM_raddr )
 begin
   RADDR_change = $time;
 end

 always @ ( `RAM_raddr or `RAM_waddr )
 begin
   if ( `RAM_raddr === `RAM_waddr ) begin
     ADDRS_MATCH_re = $time;
     ADDRS_MATCH = 1'b1;
   end else begin
     ADDRS_MATCH_fe = $time;
     ADDRS_MATCH = 1'b0;
   end
 end
 /************************ the memory read section *********************************/

 // READ: ASYNC

 // there will be two blocks to start the async read 
 // the first block is the read enable controlled aync reading as following

 always @ ( RDB_int or RBLKB_int or `RAM_raddr or WRB_int or WBLKB_int or
            `RAM_waddr )
 begin : ASYNC_READ
   # 0;
   if ( `RAM_raddr >= 0 ) begin
     if ( `RAM_waddr === `RAM_raddr ) begin
       if (( RB_int == 1'b0 ) && 
           (( RDB_fe == $time ) || ( RBLKB_fe == $time ))  &&
           ( WB_int == 1'b1 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WB_int == 1'b1 ) && 
                (( WRB_re == $time ) || ( WBLKB_re == $time ))  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b1 ) && 
                (( RDB_re == $time ) || ( RBLKB_re == $time ))  &&
                ( WB_dlyd == 1'b0 ))
                //( WB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WB_int == 1'b1 ) && 
                ( ADDRS_MATCH_re == $time )  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end else begin // addresses not equal
       if (( RB_int == 1'b0 ) && ( WB_int == 1'b0 ) &&
           ( ADDRS_MATCH_fe == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && 
                (( RDB_fe == $time ) || ( RBLKB_fe == $time )))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && ( RADDR_change == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end
   end
   if (( RDB_int === 1'b0 ) && ( RBLKB_int === 1'b0 ))  
     begin
       f_address_is_x_g = address_is_x(`RAM_raddr);
       if (f_address_is_x_g == `RAM_TRUE)
         begin
           `RAM_do_out = 9'hx;
           //$display("Warning : Data on output bus unknown because of unknown read address");
         end
       //else
       //  read_memory (`RAM_do_out, `RAM_raddr);
     end
   else
     begin
       if((RDB_int === 1'bx) || (RBLKB === 1'bx)) begin
        `RAM_do_out = 9'hx;
        //$display("Warning : Data on output bus unknown because of unknown RDB or RBLKB bit");
       end
     end
 end

 // the following is the read parity checking, SYNC reading and aSYNC reading is different

 //always @(`RAM_do_out or negedge RB_int)
 always @ ( `RAM_do_out or PARODD_int )
   begin
     par_f = ram_par9(`RAM_do_out);    // previously  `RAM_par_do_out);
     RPE_int = par_f ^ PARODD_int;
   end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 //always @(`RAM_par_di_in or DI8_int or negedge WB_int )
 always @(`RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     par_f2 = par_f ^ DI8_int;
     WPE_int = par_f2 ^ PARODD_int;
     DI8_int_reg  = DI8_int;
   end

 // async memory write 

 always @ ( negedge WB_int or `RAM_di_in or `RAM_waddr )
   begin: ASYNC_WRITE
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );
     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay
	      (DI0 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI1 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI2 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI3 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI4 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI5 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI6 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI7 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI8 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);

	    // async read. address controlled
	    (RADDR0 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // async read rdb controlled RB=RDB+RBLKB 
	     (RDB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // read enable signal pulse width
            $width(posedge RDB, 0.0, 0, NOTIFY_REG);
            $width(negedge RDB, 0.0, 0, NOTIFY_REG);
            $width(posedge RBLKB, 0.0, 0, NOTIFY_REG);
            $width(negedge RBLKB, 0.0, 0, NOTIFY_REG);
            // read address bit pulse width check
            $width(posedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR7, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR7, 0.0, 0, NOTIFY_REG);


 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9AAP(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RBLKB, WBLKB, PARODD;
 output  DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;
 reg WB_dlyd;
 integer Write_OK;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg ADDRS_MATCH;
 
 time RDB_re;
 time RDB_fe;
 time WRB_re;
 time WRB_fe;
 time WB_re;
 time WB_fe;
 time RBLKB_re;
 time RBLKB_fe;
 time WBLKB_re;
 time WBLKB_fe;
 time RADDR_change;
 time ADDRS_MATCH_re;
 time ADDRS_MATCH_fe;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RBLKB_int, RBLKB);
 buf BUF_U30 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U31 (DOS, DIS_int);
 buf OUTBUF_U32 (DO0, DO0_int);
 buf OUTBUF_U33 (DO1, DO1_int);
 buf OUTBUF_U34 (DO2, DO2_int);
 buf OUTBUF_U35 (DO3, DO3_int);
 buf OUTBUF_U36 (DO4, DO4_int);
 buf OUTBUF_U37 (DO5, DO5_int);
 buf OUTBUF_U38 (DO6, DO6_int);
 buf OUTBUF_U39 (DO7, DO7_int);
 buf OUTBUF_U40 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    
/************************ edge detect section *********************************/

 always @ ( RDB_int )
 begin
   if ( RDB_int == 1'b1 )
     RDB_re = $time;
   else if ( RDB_int == 1'b0 )
     RDB_fe = $time;
 end

 always @ ( WRB_int )
 begin
   if ( WRB_int == 1'b1 )
     WRB_re = $time;
   else if ( WRB_int == 1'b0 )
     WRB_fe = $time;
 end

 always @ ( RBLKB_int )
 begin
   if ( RBLKB_int == 1'b1 )
     RBLKB_re = $time;
   else if ( RBLKB_int == 1'b0 )
     RBLKB_fe = $time;
 end

 always @ ( WBLKB_int )
 begin
   if ( WBLKB_int == 1'b1 )
     WBLKB_re = $time;
   else if ( WBLKB_int == 1'b0 )
     WBLKB_fe = $time;
 end

 always @ ( WB_int )
 begin
   WB_dlyd <= #1 WB_int;
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end
 
 always @ ( `RAM_raddr )
 begin
   RADDR_change = $time;
 end

 always @ ( `RAM_raddr or `RAM_waddr )
 begin
   if ( `RAM_raddr === `RAM_waddr ) begin
     ADDRS_MATCH_re = $time;
     ADDRS_MATCH = 1'b1;
   end else begin
     ADDRS_MATCH_fe = $time;
     ADDRS_MATCH = 1'b0;
   end
 end


/************************ the memory read section *********************************/

 // READ: ASYNC

 // there will be two blocks to start the async read 
 // the first block is the read enable controlled aync reading as following

 always @ ( RDB_int or RBLKB_int or `RAM_raddr or WRB_int or WBLKB_int or
            `RAM_waddr )
 begin : ASYNC_READ
   #0;
   if ( `RAM_raddr >= 0 ) begin
     if ( `RAM_waddr === `RAM_raddr ) begin
       if (( RB_int == 1'b0 ) && 
           (( RDB_fe == $time ) || ( RBLKB_fe == $time ))  &&
           ( WB_int == 1'b1 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WB_int == 1'b1 ) && 
                (( WRB_re == $time ) || ( WBLKB_re == $time ))  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b1 ) && 
                (( RDB_re == $time ) || ( RBLKB_re == $time ))  &&
                ( WB_dlyd == 1'b0 ))
                //( WB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WB_int == 1'b1 ) && 
                ( ADDRS_MATCH_re == $time )  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end else begin // addresses not equal
       if (( RB_int == 1'b0 ) && ( WB_int == 1'b0 ) &&
           ( ADDRS_MATCH_fe == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && 
                (( RDB_fe == $time ) || ( RBLKB_fe == $time )))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && ( RADDR_change == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end
   end
   if ((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
     begin
       f_address_is_x_g = address_is_x(`RAM_raddr);
       if (f_address_is_x_g == `RAM_TRUE)
         begin
           `RAM_do_out = 9'hx;
           //$display("Warning : Data on output bus unknown because of unknown read address");
         end
       //else
       //  read_memory (`RAM_do_out, `RAM_raddr);
     end
   else
     begin
       if((RDB_int === 1'bx) || (RBLKB === 1'bx)) begin
        `RAM_do_out = 9'hx;
        //$display("Warning : Data on output bus unknown because of unknown RDB or RBLKB bit");
       end
     end
 end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 always @(`RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     WPE_int = par_f ^ PARODD_int;
     DI8_int_reg  = WPE_int;
   end

 // async memory write 

 always @ ( negedge WB_int or `RAM_di_in or DI8_int or `RAM_waddr )
   begin: ASYNC_WRITE
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );       
     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);

	    // async read. address controlled
	    (RADDR0 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // async read rdb controlled RB=RDB+RBLKB 
	     (RDB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // read enable signal pulse width
            $width(posedge RDB, 0.0, 0, NOTIFY_REG);
            $width(negedge RDB, 0.0, 0, NOTIFY_REG);
            $width(posedge RBLKB, 0.0, 0, NOTIFY_REG);
            $width(negedge RBLKB, 0.0, 0, NOTIFY_REG);
            // read address bit pulse width check
            $width(posedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR7, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR7, 0.0, 0, NOTIFY_REG);


 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9AST(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, RCLKS, WPE, RPE, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;
 output  WPE, RPE, DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 time WB_re;
 time WB_fe;
 integer Write_OK;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RCLKS_int, RCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (WPE, WPE_int);
 buf OUTBUF_U33 (RPE, RPE_int);
 buf OUTBUF_U34 (DOS, DIS_int);
 buf OUTBUF_U35 (DO0, DO0_int);
 buf OUTBUF_U36 (DO1, DO1_int);
 buf OUTBUF_U37 (DO2, DO2_int);
 buf OUTBUF_U38 (DO3, DO3_int);
 buf OUTBUF_U39 (DO4, DO4_int);
 buf OUTBUF_U40 (DO5, DO5_int);
 buf OUTBUF_U41 (DO6, DO6_int);
 buf OUTBUF_U42 (DO7, DO7_int);
 buf OUTBUF_U43 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    



 always @ ( WB_int )
 begin
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end

 
  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      //WPE_int  = ~ WPE_int;
    end


/************************ the memory read section *********************************/

 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          `RAM_do_out = 9'hx;
          RPE_int = 1'bx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
               read_memory (`RAM_do_out, `RAM_raddr);

               par_f = ram_par9(`RAM_do_out);    // previously  `RAM_par_do_out);
               RPE_int = par_f ^ PARODD_int;
         end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
        `RAM_do_out = 9'hx;
        RPE_int = 1'bx;
        end
      end
  end

 // the following is the read parity checking, SYNC reading and aSYNC reading is different



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 always @(`RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     par_f2 = par_f ^ DI8_int;
     WPE_int = par_f2 ^ PARODD_int;
     DI8_int_reg  = DI8_int;
   end

 // async memory write 

 always @( WB_int or `RAM_di_in or `RAM_waddr )
   begin: ASYNC_WRITE
     # 0;
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );

     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay
	      (DI0 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI1 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI2 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI3 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI4 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI5 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI6 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI7 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI8 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9ASTP(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, RCLKS, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;
 output  DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 time WB_re;
 time WB_fe;
 integer Write_OK;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RCLKS_int, RCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (DOS, DIS_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    



 always @ ( WB_int )
 begin
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end

 
 
/************************ the memory read section *********************************/

 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          `RAM_do_out = 9'hx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
               read_memory (`RAM_do_out, `RAM_raddr);
         end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
        `RAM_do_out = 9'hx;
        end
      end
  end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 always @ ( `RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     WPE_int = par_f ^ PARODD_int;
     DI8_int_reg  = WPE_int;
   end

 // async memory write 

 always @( WB_int or `RAM_di_in or `RAM_waddr )
   begin: ASYNC_WRITE
     # 0;
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );

     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9ASR(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, RCLKS, WPE, RPE, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;
 output  WPE, RPE, DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg [8:0] RAM_do_out_stg1;
 reg RPE_stg1;
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 time WB_re;
 time WB_fe;
 integer Write_OK;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RCLKS_int, RCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (WPE, WPE_int);
 buf OUTBUF_U33 (RPE, RPE_int);
 buf OUTBUF_U34 (DOS, DIS_int);
 buf OUTBUF_U35 (DO0, DO0_int);
 buf OUTBUF_U36 (DO1, DO1_int);
 buf OUTBUF_U37 (DO2, DO2_int);
 buf OUTBUF_U38 (DO3, DO3_int);
 buf OUTBUF_U39 (DO4, DO4_int);
 buf OUTBUF_U40 (DO5, DO5_int);
 buf OUTBUF_U41 (DO6, DO6_int);
 buf OUTBUF_U42 (DO7, DO7_int);
 buf OUTBUF_U43 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    

  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      RPE_stg1 = ~ RPE_stg1;
      //WPE_int  = ~ WPE_int;
    end


/************************ the memory read section *********************************/

 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    `RAM_do_out <= RAM_do_out_stg1;
    RPE_int = RPE_stg1;

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          RAM_do_out_stg1 = 9'hx;
          RPE_stg1 = 1'bx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
          read_memory (RAM_do_out_stg1, `RAM_raddr);
          f_dout_is_x = do_is_x(RAM_do_out_stg1);

          if (f_dout_is_x == `RAM_TRUE) 
            RPE_stg1 = 1'bx;
          else
            begin
              par_f = ram_par9(RAM_do_out_stg1);    // get parity of the intermediate output
              //if ( PARODD_int === 1'bx || `RAM_par_di_in === 8'bxxxxxxxx )
              if ( PARODD_int === 1'bx || ram_par8(`RAM_par_di_in) === 1'bx )
                RPE_stg1 = 1'bx;
              else begin
                if (par_f !== PARODD_int)
                    RPE_stg1 = `RAM_TRUE;
                else  
                  RPE_stg1 = `RAM_FALSE;
              end
            end
         end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
        RAM_do_out_stg1 = 9'hx;
        RPE_stg1 = 1'bx;
        end
      end
  end

 // the following is the read parity checking, SYNC reading and aSYNC reading is different



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 always @ ( WB_int )
 begin
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end

 always @ ( `RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     par_f2 = par_f ^ DI8_int;
     WPE_int = par_f2 ^ PARODD_int;
     DI8_int_reg  = DI8_int;
   end

 // async memory write 

 always @( WB_int or `RAM_di_in )
   begin: ASYNC_WRITE
     # 0;
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );
     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay
	      (DI0 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI1 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI2 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI3 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI4 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI5 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI6 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI7 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	      (DI8 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9ASRP(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, RCLKS, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;
 output  DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg [8:0] RAM_do_out_stg1;
 reg RPE_stg1;
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 time WB_re;
 time WB_fe;
 integer Write_OK;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (RCLKS_int, RCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (DOS, DIS_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);

/********************** initialization section ********************************/

  initial
    begin
      Write_OK = 0;
    end
    

 always @ ( WB_int )
 begin
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
   if ( WB_re < WB_fe )
     Write_OK = 1;
 end

 
/************************ the memory read section *********************************/

 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    `RAM_do_out <= RAM_do_out_stg1;
    RPE_int = RPE_stg1;

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          RAM_do_out_stg1 = 9'hx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
          read_memory (RAM_do_out_stg1, `RAM_raddr);
         end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
        RAM_do_out_stg1 = 9'hx;
        end
      end
  end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: ASYNC, NO WCLK

 // input data Parity generating/chekcing section

 always @ ( `RAM_par_di_in or DI8_int or PARODD_int )
   begin
     par_f = ram_par8(`RAM_par_di_in);
     WPE_int = par_f ^ PARODD_int;
     DI8_int_reg  = WPE_int;
   end

 // async memory write 

 always @( WB_int or `RAM_di_in or `RAM_waddr )
   begin: ASYNC_WRITE
     # 0;
     if ( WB_int == 1'b0 && Write_OK == 1 ) begin
       write_memory (`RAM_waddr, `RAM_di_in );

     end

   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for WADDR to WB
	     $setup(posedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR0, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR0, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR1, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR1, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR2, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR2, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR3, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR3, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR4, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR4, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR5, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR5, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR6, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR6, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(posedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
             $hold(negedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0,NOTIFY_REG);
	     $setup(negedge WADDR7, negedge WRB &&& (WBLKB_int == 1'b0), 0.0,NOTIFY_REG);
	     $hold(negedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	    $setup(negedge WADDR7, negedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	    $hold(negedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // holdup time for WADDDR to WB 
	             $setup(posedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR0, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR0, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR1, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR1, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR2, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR2, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR3, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR3, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR4, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR4, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR5, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR5, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR6, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR6, 0.0,NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(posedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge WADDR7, 0.0, NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WRB &&& (WBLKB_int == 1'b0),0.0,NOTIFY_REG);
	             $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);
	             $setup(negedge WADDR7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,NOTIFY_REG);
	             $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge WADDR7, 0.0,NOTIFY_REG);

	      // setup and hold time for DATAIN DI[7:0] to WB 
	     $setup(posedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI0, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI0, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI1, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI1, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI2, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI2, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI3, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI3, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI4, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI4, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI5, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI5, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI6, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI6, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI7, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI7, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);
	     $setup(posedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(posedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0, NOTIFY_REG);
	     $setup(negedge DI8, posedge WRB &&& (WBLKB_int == 1'b0), 0.0, NOTIFY_REG);
            $setup(negedge DI8, posedge WBLKB &&& (WRB_int == 1'b0), 0.0,  NOTIFY_REG);

              // holdup time for DATAin to WB 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI0, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI0, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI1, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI1, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI2, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI2, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI3, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI3, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI4, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI4, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI5, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI5, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI6, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI6, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI7, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI7, 0.0, NOTIFY_REG); 
             $hold(posedge WRB &&& (WBLKB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG);
             $hold(posedge WBLKB &&& (WRB_int == 1'b0), posedge DI8, 0.0, NOTIFY_REG); 
	      $hold(posedge WRB &&& (WBLKB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG);
	      $hold(posedge WBLKB &&& (WRB_int == 1'b0), negedge DI8, 0.0, NOTIFY_REG); 

	      // pin to pin delay

             // write enable signal pulse width check
             $width(posedge WRB, 0.0, 0, NOTIFY_REG);
             $width(negedge WRB, 0.0, 0, NOTIFY_REG);
             $width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
             $width(negedge WBLKB, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9SA(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, WCLKS, WPE, RPE, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, WCLKS, RBLKB, WBLKB, PARODD;
 output  WPE, RPE, DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg WB_dlyd;
 reg ADDRS_MATCH;
 reg [7:0] WADDR;

 time RDB_re;
 time RDB_fe;
 time WB_re;
 time WB_fe;
 time RBLKB_re;
 time RBLKB_fe;
 time WCLKS_fe;
 time RADDR_change;
 time ADDRS_MATCH_re;
 time ADDRS_MATCH_fe;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (WCLKS_int, WCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (WPE, WPE_int);
 buf OUTBUF_U33 (RPE, RPE_int);
 buf OUTBUF_U34 (DOS, DIS_int);
 buf OUTBUF_U35 (DO0, DO0_int);
 buf OUTBUF_U36 (DO1, DO1_int);
 buf OUTBUF_U37 (DO2, DO2_int);
 buf OUTBUF_U38 (DO3, DO3_int);
 buf OUTBUF_U39 (DO4, DO4_int);
 buf OUTBUF_U40 (DO5, DO5_int);
 buf OUTBUF_U41 (DO6, DO6_int);
 buf OUTBUF_U42 (DO7, DO7_int);
 buf OUTBUF_U43 (DO8, DO8_int);

/************************ edge detect section *********************************/

 always @ ( RDB_int )
 begin
   if ( RDB_int == 1'b1 )
     RDB_re = $time;
   else if ( RDB_int == 1'b0 )
     RDB_fe = $time;
 end

 always @ ( RBLKB_int )
 begin
   if ( RBLKB_int == 1'b1 )
     RBLKB_re = $time;
   else if ( RBLKB_int == 1'b0 )
     RBLKB_fe = $time;
 end

 always @ ( posedge WCLKS_int )
 begin
   WADDR = `RAM_waddr;
 end

 always @ ( negedge WCLKS_int )
 begin
   if ( WCLKS_int == 1'b0 )
     WCLKS_fe = $time;
 end

 always @ ( WB_int )
 begin
   WB_dlyd <= #1 WB_int;
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
 end

 always @ ( `RAM_raddr )
 begin
   RADDR_change = $time;
 end

 //always @ ( `RAM_raddr or `RAM_waddr )
 always @ ( `RAM_raddr or WADDR )
 begin
   //if ( `RAM_raddr === `RAM_waddr ) begin
   if ( `RAM_raddr === WADDR ) begin
     ADDRS_MATCH_re = $time;
     ADDRS_MATCH = 1'b1;
   end else begin
     ADDRS_MATCH_fe = $time;
     ADDRS_MATCH = 1'b0;
   end
 end

/************************ the memory read section *********************************/

 // READ: ASYNC, not RCLK, READING TRIGGERED BY RADDR or REN

 // there will be two blocks to start the async read 
 // the first block is the read enable controlled aync reading as following

 always @ ( RDB_int or RBLKB_int or `RAM_raddr or negedge WCLKS_int )
 begin : ASYNC_READ
   # 0;
   if ( `RAM_raddr >= 0 ) begin
     //if ( `RAM_waddr === `RAM_raddr ) begin
     if ( WADDR === `RAM_raddr ) begin
       if (( RB_int == 1'b0 ) &&
           (( RDB_fe == $time ) || ( RBLKB_fe == $time ))  &&
           ( WCLKS_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WCLKS_int == 1'b0 ) &&
                ( WCLKS_fe == $time )  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b1 ) &&
                (( RDB_re == $time ) || ( RBLKB_re == $time )) &&
                ( WB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RADDR_change == $time ) && ( RB_int == 1'b0 ) &&
                ( ! (( WB_int == 1'b0 ) && ( WCLKS_int == 1'b1 ))))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end else begin // addresses not equal
       if (( RB_int == 1'b0 ) &&
           ( ADDRS_MATCH_fe == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) &&
                (( RDB_fe == $time ) || ( RBLKB_fe == $time )))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && ( RADDR_change == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end
   end
   if ((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
     begin
       f_address_is_x_g = address_is_x(`RAM_raddr);
       if (f_address_is_x_g == `RAM_TRUE)
         begin
           `RAM_do_out = 9'hx;
           //$display("Warning : Data on output bus unknown because of unknown read address");
         end
       //else
         //read_memory (`RAM_do_out, `RAM_raddr);
     end
   else
     begin
       if((RDB_int === 1'bx) || (RBLKB === 1'bx)) begin
        `RAM_do_out = 9'hx;
        //$display("Warning : Data on output bus unknown because of unknown RDB or RBLKB bit");
       end
     end
 end

 // the following is the read parity checking, SYNC reading and aSYNC reading is different

 always @ ( `RAM_do_out or negedge RB_int or PARODD_int )
   begin
     par_f = ram_par9(`RAM_do_out);    // previously  `RAM_par_do_out);
     RPE_int = par_f ^ PARODD_int;
   end



  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
    end


/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: SYNC with WCLK
 //always@(posedge WCLKS_int)
 always @ ( WCLKS_int )
   begin:  SYNC_WRITE

     // check parity
     par_f = ram_par8(`RAM_par_di_in);
     par_f2 = par_f ^ DI8_int;

     //if (( PARODD_int === 1'bx ) || ( `RAM_par_di_in === 8'bxxxxxxxx ) || 
     //    ( WCLKS_int === 1'bx ))

     if (( PARODD_int === 1'bx ) || ( WCLKS_int === 1'bx ))
       WPE_int = 1'bx;
     else if ( WCLKS_int == 1'b1 ) begin
       WPE_int = par_f2 ^ PARODD_int;
     end
     DI8_int_reg  = DI8;

     if (( WCLKS_int == 1'b1 ) && ( WRB_int == 1'b0 ) && ( WBLKB_int == 1'b0 ))
       begin
          write_memory (`RAM_waddr, `RAM_di_in );

         // when async read and sync write at same @, write should trigger read output bus changing...
         //if ((RB_int === 1'b0) && (`RAM_waddr === `RAM_raddr) && (`RAM_waddr >= 0)) begin
           //read_memory (`RAM_do_out, `RAM_raddr);
         //end
       end
     else begin
       if((WRB_int == 1'bx) || (WBLKB_int == 1'bx)) begin
         x_data_word(`RAM_waddr);
       end
     end
   end


   // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      WPE_int  = ~ WPE_int;
    end

/************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS, posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
	     $setup(posedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WRB, 0.0, NOTIFY_REG);
	     $setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
             $setup(negedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WRB, 0.0, NOTIFY_REG);
             $setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

	    //setup/hold time for WADDR (write address) to WCLK
	     $setup(posedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR7, 0.0, NOTIFY_REG);

	     // path delay from WCLK to WPE 
	     (WCLKS => WPE) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // WCLK width
	      $width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
              $width(negedge WCLKS, 0.0, 0, NOTIFY_REG);

	    // async read. address controlled
	    (RADDR0 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => RPE)  = (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // async read rdb controlled RB=RDB+RBLKB 
	     (RDB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // read enable signal pulse width
            $width(posedge RDB, 0.0, 0, NOTIFY_REG);
            $width(negedge RDB, 0.0, 0, NOTIFY_REG);
            $width(posedge RBLKB, 0.0, 0, NOTIFY_REG);
            $width(negedge RBLKB, 0.0, 0, NOTIFY_REG);
            // read address bit pulse width check
            $width(posedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR7, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR7, 0.0, 0, NOTIFY_REG);


 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9SAP(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, WCLKS, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, WCLKS, RBLKB, WBLKB, PARODD;
 output  DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;

 reg ADDRS_MATCH;
 reg [7:0] WADDR;

 time RDB_re;
 time RDB_fe;
 time WB_re;
 time WB_fe;
 time RBLKB_re;
 time RBLKB_fe;
 time WCLKS_fe;
 time RADDR_change;
 time ADDRS_MATCH_re;
 time ADDRS_MATCH_fe;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (WCLKS_int, WCLKS);
 buf BUF_U30 (RBLKB_int, RBLKB);
 buf BUF_U31 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U32 (DOS, DIS_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);

/************************ edge detect section *********************************/

 always @ ( RDB_int )
 begin
   if ( RDB_int == 1'b1 )
     RDB_re = $time;
   else if ( RDB_int == 1'b0 )
     RDB_fe = $time;
 end

 always @ ( RBLKB_int )
 begin
   if ( RBLKB_int == 1'b1 )
     RBLKB_re = $time;
   else if ( RBLKB_int == 1'b0 )
     RBLKB_fe = $time;
 end

 always @ ( posedge WCLKS_int )
 begin
   WADDR = `RAM_waddr;
 end

 always @ ( negedge WCLKS_int )
 begin
   if ( WCLKS_int == 1'b0 )
     WCLKS_fe = $time;
 end

 always @ ( WB_int )
 begin
   if ( WB_int == 1'b1 )
     WB_re = $time;
   else if ( WB_int == 1'b0 )
     WB_fe = $time;
 end

 always @ ( `RAM_raddr )
 begin
   RADDR_change = $time;
 end

 //always @ ( `RAM_raddr or `RAM_waddr )
 always @ ( `RAM_raddr or WADDR )
 begin
   //if ( `RAM_raddr === `RAM_waddr ) begin
   if ( `RAM_raddr === WADDR ) begin
     ADDRS_MATCH_re = $time;
     ADDRS_MATCH = 1'b1;
   end else begin
     ADDRS_MATCH_fe = $time;
     ADDRS_MATCH = 1'b0;
   end
 end

/************************ the memory read section *********************************/

 // READ: ASYNC, not RCLK, READING TRIGGERED BY RADDR or REN

 // there will be two blocks to start the async read 
 // the first block is the read enable controlled aync reading as following

 always @ ( RDB_int or RBLKB_int or `RAM_raddr or negedge WCLKS_int )
 begin : ASYNC_READ
   # 0;
   if ( `RAM_raddr >= 0 ) begin
     //if ( `RAM_waddr === `RAM_raddr ) begin
     if ( WADDR === `RAM_raddr ) begin
       if (( RB_int == 1'b0 ) &&
           (( RDB_fe == $time ) || ( RBLKB_fe == $time ))  &&
           ( WCLKS_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( WCLKS_int == 1'b0 ) &&
                ( WCLKS_fe == $time )  &&
                ( RB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b1 ) &&
                (( RDB_re == $time ) || ( RBLKB_re == $time )) &&
                ( WB_int == 1'b0 ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RADDR_change == $time ) && ( RB_int == 1'b0 ) &&
                ( ! (( WB_int == 1'b0 ) && ( WCLKS_int == 1'b1 ))))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end else begin // addresses not equal
       if (( RB_int == 1'b0 ) && 
           ( ADDRS_MATCH_fe == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) &&
                (( RDB_fe == $time ) || ( RBLKB_fe == $time )))
         read_memory ( `RAM_do_out, `RAM_raddr );
       else if (( RB_int == 1'b0 ) && ( RADDR_change == $time ))
         read_memory ( `RAM_do_out, `RAM_raddr );
     end
   end
   if ((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
     begin
       f_address_is_x_g = address_is_x(`RAM_raddr);
       if (f_address_is_x_g == `RAM_TRUE)
         begin
           `RAM_do_out = 9'hx;
           //$display("Warning : Data on output bus unknown because of unknown read address");
         end
       //else
         //read_memory (`RAM_do_out, `RAM_raddr);
     end
   else
     begin
       if((RDB_int === 1'bx) || (RBLKB === 1'bx)) begin
        `RAM_do_out = 9'hx;
        //$display("Warning : Data on output bus unknown because of unknown RDB or RBLKB bit");
       end
     end
 end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: SYNC with WCLK
 always @ ( WCLKS_int )
   begin:  SYNC_WRITE

     // first generate or check the parity it
     par_f = ram_par8(`RAM_par_di_in);
     WPE_int = par_f ^ PARODD_int;
     DI8_int_reg  = WPE_int;

     if (( WCLKS_int == 1'b1 ) && ( WRB_int == 1'b0 ) && ( WBLKB_int == 1'b0 ))
       begin
         write_memory (`RAM_waddr, `RAM_di_in );

         // when async read and sync write at same @, write should trigger read output bus changing...
         //if ((RB_int === 1'b0) && (`RAM_waddr === `RAM_raddr) && (`RAM_waddr >= 0)) begin
         //  read_memory (`RAM_do_out, `RAM_raddr);
         //end
       end
     else begin
       if((WRB == 1'bx) || (WBLKB_int == 1'bx)) begin
         x_data_word(`RAM_waddr);
       end
     end
   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS, posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
	     $setup(posedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WRB, 0.0, NOTIFY_REG);
	     $setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
             $setup(negedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WRB, 0.0, NOTIFY_REG);
             $setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

	    //setup/hold time for WADDR (write address) to WCLK
	     $setup(posedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR7, 0.0, NOTIFY_REG);

	     // WCLK width
	      $width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
              $width(negedge WCLKS, 0.0, 0, NOTIFY_REG);

	    // async read. address controlled
	    (RADDR0 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR0 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR1 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR2 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR3 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR4 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR5 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR6 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	    (RADDR7 => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // async read rdb controlled RB=RDB+RBLKB 
	     (RDB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RDB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RBLKB => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // read enable signal pulse width
            $width(posedge RDB, 0.0, 0, NOTIFY_REG);
            $width(negedge RDB, 0.0, 0, NOTIFY_REG);
            $width(posedge RBLKB, 0.0, 0, NOTIFY_REG);
            $width(negedge RBLKB, 0.0, 0, NOTIFY_REG);
            // read address bit pulse width check
            $width(posedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR0, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR1, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR2, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR3, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR4, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR5, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR6, 0.0, 0, NOTIFY_REG);
            $width(posedge RADDR7, 0.0, 0, NOTIFY_REG);
            $width(negedge RADDR7, 0.0, 0, NOTIFY_REG);


 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9SST(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, WCLKS, RCLKS, WPE, RPE, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, WCLKS, RCLKS, RBLKB, WBLKB, PARODD;
 output  WPE, RPE, DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (WCLKS_int, WCLKS);
 buf BUF_U30 (RCLKS_int, RCLKS);
 buf BUF_U31 (RBLKB_int, RBLKB);
 buf BUF_U32 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U33 (WPE, WPE_int);
 buf OUTBUF_U34 (RPE, RPE_int);
 buf OUTBUF_U35 (DOS, DIS_int);
 buf OUTBUF_U36 (DO0, DO0_int);
 buf OUTBUF_U37 (DO1, DO1_int);
 buf OUTBUF_U38 (DO2, DO2_int);
 buf OUTBUF_U39 (DO3, DO3_int);
 buf OUTBUF_U40 (DO4, DO4_int);
 buf OUTBUF_U41 (DO5, DO5_int);
 buf OUTBUF_U42 (DO6, DO6_int);
 buf OUTBUF_U43 (DO7, DO7_int);
 buf OUTBUF_U44 (DO8, DO8_int);

/********************  MEMORY WRITE FUNCTION **********************/


  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      WPE_int  = ~ WPE_int;
    end


 // WRITE: SYNC with WCLK
 always @ ( WCLKS_int )
   begin:  SYNC_WRITE

     // check parity
     par_f = ram_par8(`RAM_par_di_in);
     par_f2 = par_f ^ DI8_int;

     //if (( PARODD_int === 1'bx ) || ( `RAM_par_di_in === 8'bxxxxxxxx ) ||
     //    ( WCLKS_int === 1'bx ))

     if (( PARODD_int === 1'bx ) || ( WCLKS_int === 1'bx ))
       WPE_int = 1'bx;
     else if ( WCLKS_int == 1'b1 ) begin
       WPE_int = par_f2 ^ PARODD_int;
     end
     DI8_int_reg  = DI8;

     if (( WCLKS_int == 1'b1 ) && ( WRB_int == 1'b0 ) && ( WBLKB_int == 1'b0 ))
       begin
         write_memory (`RAM_waddr, `RAM_di_in );

       end
     else begin
       if((WRB == 1'bx) || (WBLKB_int == 1'bx)) begin
         x_data_word(`RAM_waddr);
       end
     end
   end


/************************ the memory read section *********************************/

 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          `RAM_do_out = 9'hx;
          RPE_int = 1'bx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
           read_memory (`RAM_do_out, `RAM_raddr);
           f_dout_is_x = do_is_x(`RAM_do_out);
           if (f_dout_is_x == `RAM_TRUE) 
              RPE_int = 1'bx;
           else begin
              par_f = ram_par9 ( `RAM_do_out );    // get parity of the intermediate output
              //if ( PARODD_int === 1'bx || `RAM_par_di_in === 8'bxxxxxxxx )
              if ( PARODD_int === 1'bx || ram_par8(`RAM_par_di_in) === 1'bx )
                RPE_int = 1'bx;
              else begin
                if (par_f !== PARODD_int)
                  RPE_int = `RAM_TRUE;
                else  
                  RPE_int = `RAM_FALSE;
              end
           end
        end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
        `RAM_do_out = 9'hx;
        RPE_int = 1'bx;
        end
      end
  end

 // the following is the read parity checking, SYNC reading and aSYNC reading is different



 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS, posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
	     $setup(posedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WRB, 0.0, NOTIFY_REG);
	     $setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
             $setup(negedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WRB, 0.0, NOTIFY_REG);
             $setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

	    //setup/hold time for WADDR (write address) to WCLK
	     $setup(posedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR7, 0.0, NOTIFY_REG);

	     // path delay from WCLK to WPE 
	     (WCLKS => WPE) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // WCLK width
	      $width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
              $width(negedge WCLKS, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9SSTP(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, WCLKS, RCLKS, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, WCLKS, RCLKS, RBLKB, WBLKB, PARODD;
 output  DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (WCLKS_int, WCLKS);
 buf BUF_U30 (RCLKS_int, RCLKS);
 buf BUF_U31 (RBLKB_int, RBLKB);
 buf BUF_U32 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U33 (DOS, DIS_int);
 buf OUTBUF_U34 (DO0, DO0_int);
 buf OUTBUF_U35 (DO1, DO1_int);
 buf OUTBUF_U36 (DO2, DO2_int);
 buf OUTBUF_U37 (DO3, DO3_int);
 buf OUTBUF_U38 (DO4, DO4_int);
 buf OUTBUF_U39 (DO5, DO5_int);
 buf OUTBUF_U40 (DO6, DO6_int);
 buf OUTBUF_U41 (DO7, DO7_int);
 buf OUTBUF_U42 (DO8, DO8_int);

/************************ the memory read section *********************************/

 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          `RAM_do_out = 9'hx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
               read_memory (`RAM_do_out, `RAM_raddr);
         end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
        `RAM_do_out = 9'hx;
        end
      end
  end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: SYNC with WCLK
 always@(posedge WCLKS_int)
   begin:  SYNC_WRITE

   // first generate or check the parity it
   par_f = ram_par8(`RAM_par_di_in);
   WPE_int = par_f ^ PARODD_int;
   DI8_int_reg  = WPE_int;

     if((WRB == 1'b0) && (WBLKB_int == 1'b0))
       begin
         write_memory (`RAM_waddr, `RAM_di_in );

       end
     else begin
       if((WRB == 1'bx) || (WBLKB_int == 1'bx)) begin
         x_data_word(`RAM_waddr);
       end
     end
   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS, posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
	     $setup(posedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WRB, 0.0, NOTIFY_REG);
	     $setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
             $setup(negedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WRB, 0.0, NOTIFY_REG);
             $setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

	    //setup/hold time for WADDR (write address) to WCLK
	     $setup(posedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR7, 0.0, NOTIFY_REG);

	     // WCLK width
	      $width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
              $width(negedge WCLKS, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9SSR(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, WCLKS, RCLKS, WPE, RPE, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, WCLKS, RCLKS, RBLKB, WBLKB, PARODD;
 output  WPE, RPE, DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg [8:0] RAM_do_out_stg1;
 reg RPE_stg1;
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (WCLKS_int, WCLKS);
 buf BUF_U30 (RCLKS_int, RCLKS);
 buf BUF_U31 (RBLKB_int, RBLKB);
 buf BUF_U32 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U33 (WPE, WPE_int);
 buf OUTBUF_U34 (RPE, RPE_int);
 buf OUTBUF_U35 (DOS, DIS_int);
 buf OUTBUF_U36 (DO0, DO0_int);
 buf OUTBUF_U37 (DO1, DO1_int);
 buf OUTBUF_U38 (DO2, DO2_int);
 buf OUTBUF_U39 (DO3, DO3_int);
 buf OUTBUF_U40 (DO4, DO4_int);
 buf OUTBUF_U41 (DO5, DO5_int);
 buf OUTBUF_U42 (DO6, DO6_int);
 buf OUTBUF_U43 (DO7, DO7_int);
 buf OUTBUF_U44 (DO8, DO8_int);

/********************  MEMORY WRITE FUNCTION **********************/

  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      RPE_stg1 = ~ RPE_stg1;
      WPE_int  = ~ WPE_int;
    end


 // WRITE: SYNC with WCLK
 always @ ( WCLKS_int )
   begin:  SYNC_WRITE

     // check parity
     par_f = ram_par8(`RAM_par_di_in);
     par_f2 = par_f ^ DI8_int;

     //if (( PARODD_int === 1'bx ) || ( `RAM_par_di_in === 8'bxxxxxxxx ) ||
     //    ( WCLKS_int === 1'bx ))

     if (( PARODD_int === 1'bx ) ||  ( WCLKS_int === 1'bx ))
       WPE_int = 1'bx;
     else if ( WCLKS_int == 1'b1 ) begin
       WPE_int = par_f2 ^ PARODD_int;
     end
     DI8_int_reg  = DI8;

     if (( WCLKS_int == 1'b1 ) && ( WRB_int == 1'b0 ) && ( WBLKB_int == 1'b0 ))
       begin
         write_memory (`RAM_waddr, `RAM_di_in );

       end
     else begin
       if((WRB == 1'bx) || (WBLKB_int == 1'bx)) begin
         x_data_word(`RAM_waddr);
       end
     end
   end


/************************ the memory read section *********************************/


 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    `RAM_do_out <= RAM_do_out_stg1;
    RPE_int = RPE_stg1;

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          RAM_do_out_stg1 = 9'hx;
          RPE_stg1 = 1'bx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
          read_memory (RAM_do_out_stg1, `RAM_raddr);
          f_dout_is_x = do_is_x(RAM_do_out_stg1);

          if (f_dout_is_x == `RAM_TRUE) 
            RPE_stg1 = 1'bx;
          else
            begin
              par_f = ram_par9(RAM_do_out_stg1);    // get parity of the intermediate output
              //if ( PARODD_int === 1'bx || `RAM_par_di_in === 8'bxxxxxxxx )
              if ( PARODD_int === 1'bx || ram_par8(`RAM_par_di_in) === 1'bx )
                RPE_stg1 = 1'bx;
              else begin
                if (par_f !== PARODD_int)
                  RPE_stg1 = `RAM_TRUE;
                else  
                  RPE_stg1 = `RAM_FALSE;
              end
            end
         end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
          RAM_do_out_stg1 = 9'hx;
          RPE_stg1 = 1'bx;
        end
      end
  end

 // the following is the read parity checking, SYNC reading and aSYNC reading is different



 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS, posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
	     $setup(posedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WRB, 0.0, NOTIFY_REG);
	     $setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
             $setup(negedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WRB, 0.0, NOTIFY_REG);
             $setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

	    //setup/hold time for WADDR (write address) to WCLK
	     $setup(posedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR7, 0.0, NOTIFY_REG);

	     // path delay from WCLK to WPE 
	     (WCLKS => WPE) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

	     // WCLK width
	      $width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
              $width(negedge WCLKS, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module RAM256x9SSRP(
		WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7, 
		RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, DIS, DOS, WCLKS, RCLKS, 
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
		);

 input WADDR0, WADDR1, WADDR2, WADDR3, WADDR4, WADDR5, WADDR6, WADDR7;
 input RADDR0, RADDR1, RADDR2, RADDR3, RADDR4, RADDR5, RADDR6, RADDR7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RDB, WRB, DIS, WCLKS, RCLKS, RBLKB, WBLKB, PARODD;
 output  DOS;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;


 wire WADDR0_int, WADDR1_int, WADDR2_int, WADDR3_int, WADDR4_int, WADDR5_int, WADDR6_int, WADDR7_int;
 wire RADDR0_int, RADDR1_int, RADDR2_int, RADDR3_int, RADDR4_int, RADDR5_int, RADDR6_int, RADDR7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RB_int, WB_int;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [0:255];
 reg [8:0] RAM_do_out_stg1;
 reg RPE_stg1;
 reg DI8_int_reg;
 reg DO0_int, DO1_int, DO2_int, DO3_int, DO4_int, DO5_int, DO6_int, DO7_int, DO8_int;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;

/******************* MEMORY PRE-LOAD *****************/

   parameter MEMORYFILE = "";

   initial
     if (MEMORYFILE != "")
            $readmemb(MEMORYFILE, memory_array);



/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define RAM_TRUE  1'b1
 `define RAM_FALSE 1'b0
 `define RAM_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define RAM_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define RAM_waddr {WADDR7_int, WADDR6_int, WADDR5_int, WADDR4_int, WADDR3_int, WADDR2_int, WADDR1_int, WADDR0_int}
 `define RAM_raddr {RADDR7_int, RADDR6_int, RADDR5_int, RADDR4_int, RADDR3_int, RADDR2_int, RADDR1_int, RADDR0_int}

/********************* Instantiate Input Input Buffers *****************************/

 // assign the signals which control setup/hold check condition

 // internal write/read control signals
 or OR_U1 (RB_int, RDB_int, RBLKB_int);
 or OR_U2 (WB_int, WRB_int, WBLKB_int);

 // insert buffers for all input signals 
 buf BUF_U0 (WADDR0_int, WADDR0);
 buf BUF_U1 (WADDR1_int, WADDR1);
 buf BUF_U2 (WADDR2_int, WADDR2);
 buf BUF_U3 (WADDR3_int, WADDR3);
 buf BUF_U4 (WADDR4_int, WADDR4);
 buf BUF_U5 (WADDR5_int, WADDR5);
 buf BUF_U6 (WADDR6_int, WADDR6);
 buf BUF_U7 (WADDR7_int, WADDR7);
 buf BUF_U8 (RADDR0_int, RADDR0);
 buf BUF_U9 (RADDR1_int, RADDR1);
 buf BUF_U10 (RADDR2_int, RADDR2);
 buf BUF_U11 (RADDR3_int, RADDR3);
 buf BUF_U12 (RADDR4_int, RADDR4);
 buf BUF_U13 (RADDR5_int, RADDR5);
 buf BUF_U14 (RADDR6_int, RADDR6);
 buf BUF_U15 (RADDR7_int, RADDR7);
 buf BUF_U16 (DI0_int, DI0);
 buf BUF_U17 (DI1_int, DI1);
 buf BUF_U18 (DI2_int, DI2);
 buf BUF_U19 (DI3_int, DI3);
 buf BUF_U20 (DI4_int, DI4);
 buf BUF_U21 (DI5_int, DI5);
 buf BUF_U22 (DI6_int, DI6);
 buf BUF_U23 (DI7_int, DI7);
 buf BUF_U24 (DI8_int, DI8);
 buf BUF_U25 (RDB_int, RDB);
 buf BUF_U26 (WRB_int, WRB);
 buf BUF_U27 (PARODD_int, PARODD);
 buf BUF_U28 (DIS_int, DIS);
 buf BUF_U29 (WCLKS_int, WCLKS);
 buf BUF_U30 (RCLKS_int, RCLKS);
 buf BUF_U31 (RBLKB_int, RBLKB);
 buf BUF_U32 (WBLKB_int, WBLKB);

 // assign internal signals to outputs
 buf OUTBUF_U33 (DOS, DIS_int);
 buf OUTBUF_U34 (DO0, DO0_int);
 buf OUTBUF_U35 (DO1, DO1_int);
 buf OUTBUF_U36 (DO2, DO2_int);
 buf OUTBUF_U37 (DO3, DO3_int);
 buf OUTBUF_U38 (DO4, DO4_int);
 buf OUTBUF_U39 (DO5, DO5_int);
 buf OUTBUF_U40 (DO6, DO6_int);
 buf OUTBUF_U41 (DO7, DO7_int);
 buf OUTBUF_U42 (DO8, DO8_int);

/************************ the memory read section *********************************/

 // READ: SYNC with RCLK ;

 always @(posedge RCLKS_int)
  begin

    `RAM_do_out <= RAM_do_out_stg1;
    RPE_int = RPE_stg1;

    if((RDB_int === 1'b0) && (RBLKB_int === 1'b0))
      begin: SYNC_READ
      f_address_is_x_g = address_is_x(`RAM_raddr);
      if (f_address_is_x_g == `RAM_TRUE)
        begin
          RAM_do_out_stg1 = 9'hx;
          //   $display("Warning : Data on output bus unknown because of unknown read address");
        end
      else
        begin
          read_memory (RAM_do_out_stg1, `RAM_raddr);
         end
      end
    else
      begin
       if((RDB_int === 1'bx) || (RBLKB_int === 1'bx))
        begin 
        RAM_do_out_stg1 = 9'hx;
        end
      end
  end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: SYNC with WCLK
 always@(posedge WCLKS_int)
   begin:  SYNC_WRITE

   // first generate or check the parity it
   par_f = ram_par8(`RAM_par_di_in);
   WPE_int = par_f ^ PARODD_int;
   DI8_int_reg  = WPE_int;

     if((WRB == 1'b0) && (WBLKB_int == 1'b0))
       begin
         write_memory (`RAM_waddr, `RAM_di_in );

       end
     else begin
       if((WRB == 1'bx) || (WBLKB_int == 1'bx)) begin
         x_data_word(`RAM_waddr);
       end
     end
   end


 /************************** VERILOG  FUNCTION SECTION *************************/

  function  ram_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par8 = ^temp_reg1;

  endfunction


  function  ram_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   ram_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_memory;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  reg [8:0]data_out;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `RAM_TRUE)
        begin
         temp_reg = 9'hx;
         //$display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
     data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_memory;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `RAM_TRUE)
     $display("Warning : Invalid write, write address unknown. ");
   else if (f_address_out_of_range == `RAM_TRUE)
     $display("Warning : Invalid write, write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `RAM_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `RAM_TRUE;
       $display("Warning : Address (%b) unknown at time %10g", address, $realtime);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `RAM_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `RAM_TRUE;
       //$display("Warning : Bits on the data out bus are unknown at time %10g.", $realtime);
      // $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `RAM_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `RAM_TRUE;
     //$display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify

	     (DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);    //DIS to DOS path delay

	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS, 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS, posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
	     $setup(posedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WRB, 0.0, NOTIFY_REG);
	     $setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
             $setup(negedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WRB, 0.0, NOTIFY_REG);
             $setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
             $hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

	    //setup/hold time for WADDR (write address) to WCLK
	     $setup(posedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR0, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR1, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR2, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR3, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR4, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR5, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR6, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, posedge WADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge WADDR7, posedge WCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge WCLKS, negedge WADDR7, 0.0, NOTIFY_REG);

	     // WCLK width
	      $width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
              $width(negedge WCLKS, 0.0, 0, NOTIFY_REG);
	     // setup and hold time for RBD and RBLKB to RCLK
	     $setup(posedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RDB, 0.0, NOTIFY_REG);
	     $setup(posedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RBLKB, 0.0, NOTIFY_REG);
	     $setup(negedge RDB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RDB, 0.0, NOTIFY_REG);
	     $setup(negedge RBLKB, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RBLKB, 0.0, NOTIFY_REG);

	     // setup/hold time for RADDR to CLK
	     $setup(posedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR0, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR0, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR1, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR1, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR2, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR2, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR3, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR3, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR4, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR4, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR5, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR5, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR6, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR6, 0.0, NOTIFY_REG);
	     $setup(posedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, posedge RADDR7, 0.0, NOTIFY_REG);
	     $setup(negedge RADDR7, posedge RCLKS, 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS, negedge RADDR7, 0.0, NOTIFY_REG);

	    // path delay parameters
	     (RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
	     (RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // clock width 
	    $width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
            $width(negedge RCLKS, 0.0, 0, NOTIFY_REG);



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


/*--------------------------------------------------------------------
 CELL NAME : FIFO256x9AA
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9AA(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS,  WPE, RPE, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, RBLKB, WBLKB, PARODD;

 output  WPE, RPE, DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 //  some internal timing checking condition control signals
 
 wire WENABLE_RENABLE_hold_check_condition;
 wire WBLK_RENABLE_hold_check_condition;
 wire WENABLE_RBLK_hold_check_condition;
 wire WBLK_RBLK_hold_check_condition;
 wire RENABLE_WENABLE_hold_check_condition;
 wire RBLK_WENABLE_hold_check_condition;
 wire RENABLE_WBLK_hold_check_condition;
 wire RBLK_WBLK_hold_check_condition;
 wire DI_WENABLE_check_condition;
 wire DI_WBLK_check_condition;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;

 integer WB_initialized; // 1 = WB_int falling edge occured.  Must occur before first write after RESET.

 // Special variables to control flags
 
 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer level;
 integer depth_int;
 integer max_level;

/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 //  assign internal timing checking condition control signals
 assign WENABLE_RENABLE_hold_check_condition = (~RBLKB_int && FULL && ~WBLKB_int && RESET_int);
 assign WBLK_RENABLE_hold_check_condition = (~RBLKB_int && FULL && ~WRB_int && RESET_int);
 assign WENABLE_RBLK_hold_check_condition = (~RDB_int && FULL && ~WBLKB_int && RESET_int);
 assign WBLK_RBLK_hold_check_condition = (~RDB_int && FULL && ~WRB_int && RESET_int);
 assign RENABLE_WENABLE_hold_check_condition = (~WBLKB_int && EMPTY && ~RBLKB_int && RESET_int);
 assign RBLK_WENABLE_hold_check_condition = (~WBLKB_int && EMPTY && ~RDB_int && RESET_int);
 assign RENABLE_WBLK_hold_check_condition = (~WRB_int && EMPTY && ~RBLKB_int && RESET_int);
 assign RBLK_WBLK_hold_check_condition = (~WRB_int && EMPTY && ~RDB_int && RESET_int);
 assign DI_WENABLE_check_condition = (~WBLKB_int && ~FULL && RESET_int);
 assign DI_WBLK_check_condition = (~WRB_int && ~FULL && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (RBLKB_int, RBLKB);
 buf BUF_U25 (WBLKB_int, WBLKB);
 buf BUF_U26 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U27 (DOS, DIS_int);
 buf OUTBUF_U28 (FULL, FULL_int);
 buf OUTBUF_U29 (EMPTY, EMPTY_int);
 buf OUTBUF_U30 (EQTH, EQTH_int);
 buf OUTBUF_U31 (GEQTH, GEQTH_int);
 buf OUTBUF_U32 (DO0, DO0_int);
 buf OUTBUF_U33 (DO1, DO1_int);
 buf OUTBUF_U34 (DO2, DO2_int);
 buf OUTBUF_U35 (DO3, DO3_int);
 buf OUTBUF_U36 (DO4, DO4_int);
 buf OUTBUF_U37 (DO5, DO5_int);
 buf OUTBUF_U38 (DO6, DO6_int);
 buf OUTBUF_U39 (DO7, DO7_int);
 buf OUTBUF_U40 (DO8, DO8_int);
 buf OUTBUF_U41 (WPE, WPE_int);
 buf OUTBUF_U42 (RPE, RPE_int);


 /******************************* initilization ***************************************/

  initial 
    begin
      WBLKB_previous  = 1'bx;
      WRB_previous    = 1'bx;
      RBLKB_previous  = 1'bx;
      RDB_previous    = 1'bx;
      fifo_r_cnt      = 0;
      fifo_w_cnt      = 0;
      WB_initialized  = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
    end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh ) 
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: ASYNC, not RCLK, READING TRIGGERED BY READ ENABLE SIGNAL

 always @(negedge RB_int )
  begin
   if (( EMPTY_int === `FIFO_FALSE )  && ( RESET_int === `FIFO_TRUE))  // i.e. not reset mode
      begin
        read_fifo (`FIFO_do_out, fifo_r_cnt[7:0]);
        fifo_incr_counter(fifo_r_cnt,fifo_r_cnt);
        fifo_rpar;
      end
  end

 // set flags at the rising edge of RB_int, 
 //
 always @(posedge RB_int)
   begin
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
       begin
        fifo_flags;
       end
   end

   // if READ enable signal becomes unknown 'X', the read address will become X too.
   // so FIFO reading operation will corrupt.  user must reset the FIFO
   //
 always @(RB_int == 1'bx )
 begin
  if($time > 0) begin
      if((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (RBLKB_previous != 1'bx) && (RDB_previous != 1'bx))  begin
       $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
      end
     end
   end 


  //
  // RESET operation
  // 
 
  always @ ( negedge RESET_int )
    begin
      fifo_depth;
      fifo_r_cnt      = 0;
      fifo_w_cnt      = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
      fifo_flags;
      WBLKB_previous  = 1'bx;
      WRB_previous    = 1'bx;
      RBLKB_previous  = 1'bx;
      RDB_previous    = 1'bx;
      WB_initialized  = 0;
    end


  // Mimic strange flag behavior of silicon when WB held low
  // as RESET deasserted.

  always @ ( posedge RESET_int )
    begin
      if ( WB_int == 1'b0 ) begin
        hold_empty_low  = 1;
        hold_eqth_high  = 1;
        hold_geqth_high = 1;
        fifo_flags;
      end
    end


  always @ ( posedge WB_int )
    begin
      if ( RESET_int == 1'b1 ) begin
        hold_empty_low  = 0;
        hold_eqth_high  = 0;
        hold_geqth_high = 0;
        fifo_flags;
      end
    end


  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int = ~ RPE_int;
      WPE_int = ~ WPE_int;
    end



/********************  MEMORY WRITE FUNCTION **********************/

 // WRITE: UNSYNC, NO WCLK

  always @ ( negedge WB_int )
    begin
      if ( RESET_int === `FIFO_TRUE )
        WB_initialized = 1;
    end

 always @ ( posedge WB_int )
    begin
        if (( FULL_int === `FIFO_FALSE ) && ( RESET_int === `FIFO_TRUE ) &&
            ( WB_initialized == 1 ))  // i.e. not reset mode
                  begin
                    fifo_wpar;
                    write_fifo (fifo_w_cnt[7:0], `FIFO_di_in );
                    fifo_incr_counter(fifo_w_cnt,fifo_w_cnt);
                           fifo_flags;     // only do flags on rising edge of WCLK for async fifo
                  end
   end

 always @(WB_int == 1'bx)
   begin
     if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WBLKB_previous != 1'bx) && (WRB_previous != 1'bx))
     begin
       $display("Warning : WBLKB or WRB unknown at time %0.1f",$realtime);
       $display("        : can not write FIFO,");
     end
   end

  always @ ( `FIFO_di_in or DI8_int or PARODD_int )
          begin
              fifo_wpar;
          end


 /************************** VERILOG  FUNCTION SECTION *************************/

 task fifo_depth;
    begin
           depth = `FIFO_depth + 1;
           depth_size = depth;
           depth = 1 << depth;
    end
 endtask

 function fifo_count_compare;
    input [4:0] local_depth_size;
    integer   i;
    begin
     fifo_count_compare = `FIFO_FALSE;
     begin : CHECK_COUNTER_EQUALITY
                    for (i = 0; i < local_depth_size; i = i+1)
                    begin
                            if (fifo_r_cnt[i] !== fifo_w_cnt[i])
                                  begin
                                    fifo_count_compare = `FIFO_FALSE;
                                    disable CHECK_COUNTER_EQUALITY;
                                  end
                            else
                                  fifo_count_compare = `FIFO_TRUE;
                    end
    end
   end
  endfunction


  task fifo_flags;
 
    reg [8:0] temp_write_cnt;
    
    begin
    
      // compare fifo_w_cnt with fifo_r_cnt
      
      if ( fifo_count_compare ( depth_size )) begin
        if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
          FULL_int = `FIFO_FALSE;
          if ( hold_empty_low == 1 )
            EMPTY_int = `FIFO_FALSE;
          else
            EMPTY_int = `FIFO_TRUE;
        end else begin
          EMPTY_int = `FIFO_FALSE;
          FULL_int  = `FIFO_TRUE;
        end
      end else begin
        EMPTY_int = `FIFO_FALSE;
        FULL_int  = `FIFO_FALSE;
      end
      cnt_diff = fifo_w_cnt - fifo_r_cnt; // w_cnt is always bigger

      if ( cnt_diff [ 8 ] == 1 ) begin
        cnt_diff = cnt_diff + ( 2 * depth );
      end

      // Calculate the maximum level allowable for the selected depth
      
      thresh_reg = `FIFO_thresh;
      level      = thresh_reg;
      depth_int  = depth_size;
      max_level  = 2 ** depth_int;

      // compare cnt_diff with FIFO_thresh
      
      if ( hold_eqth_high == 1 )
        EQTH_int = `FIFO_TRUE;
      else begin
        if ( cnt_diff [ 8 : 0 ] == thresh_reg )
          EQTH_int = `FIFO_TRUE;
        else
          EQTH_int = `FIFO_FALSE;
      end
      if ( hold_geqth_high == 1 )
        GEQTH_int = `FIFO_TRUE;
      else begin
        if ( level > max_level )
          GEQTH_int = FULL_int; // GEQTH mimics FULL
        else begin
          if ( cnt_diff [ 8 : 0 ] >= thresh_reg )
            GEQTH_int = `FIFO_TRUE;
          else
            GEQTH_int = `FIFO_FALSE;
        end
      end

    end
    
  endtask // fifo_flags

 task fifo_incr_counter;
          output [8:0] out_reg;
          input [8:0]  in_reg;

          reg [8:0]        in_reg,out_reg;

        begin
           fifo_depth;
           if (in_reg == ((2 * depth) - 1))
               out_reg = 0;
           else
               out_reg = in_reg + 1;
        end
       endtask

 // make rpe output
  task fifo_rpar;
     begin
        par_f = fifo_par9(`FIFO_do_out);    // previously  `FIFO_par_do_out);
        RPE_int = par_f ^ PARODD_int;
     end

   endtask // fifo_rpar

 // Tasks to check/gen parity depending on PARGEN / PARODD
 // make wpe output
  task fifo_wpar;
     begin
        par_f = fifo_par8 ( `FIFO_par_di_in );
        par_f2 = par_f ^ DI8_int;
        WPE_int = par_f2 ^ PARODD_int;
        DI8_int_reg  = DI8_int;
     end
  endtask

  function  fifo_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of ones ^ gives a 1
   // even number of ones ^ gives a 0
   fifo_par8 = ^temp_reg1;

  endfunction


  function  fifo_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of ones ^ gives a 1
   // even number of ones ^ gives a 0
   fifo_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_fifo;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `FIFO_TRUE)
        begin
         temp_reg = 9'hx;
         $display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
   data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_fifo;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `FIFO_TRUE)
     x_memory ;
   else if (f_address_out_of_range == `FIFO_TRUE)
     $display("Warning : Invalid writing because write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `FIFO_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `FIFO_TRUE;
       $display("Warning : Bits on the Address Bus are unknown at time %10g", $realtime);
       $display("        : address is %b ", address);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `FIFO_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `FIFO_TRUE;
       $display("Warning : Bit [%d] on the data out bus is unknown at time %10g.", i, $realtime);
       $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `FIFO_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `FIFO_TRUE;
     $display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify



	      // setup and hold time for DATAIN DI[7:0] to WB 
		$setup(posedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);

              // holdup time for DATAin to WB 
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);

	      // pin to pin delay
		(DI0 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI1 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI2 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI3 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI4 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI5 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI6 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI7 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI8 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // minimum  width requirement for WRITE ENABLE signals
		$width(posedge WRB, 0.0, 0, NOTIFY_REG);
		$width(negedge WRB, 0.0, 0, NOTIFY_REG);
		$width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
		$width(negedge WBLKB, 0.0, 0, NOTIFY_REG);

                $width(posedge RESET, 0.0, 0, NOTIFY_REG);
                $width(negedge RESET, 0.0, 0, NOTIFY_REG);

            // setup/hold timing for write enable signal to RESET
		$hold(posedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, posedge RESET, 0, NOTIFY_REG);
		$hold(negedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, negedge RESET, 0, NOTIFY_REG);
		$hold(posedge RESET, posedge WRB, 0, NOTIFY_REG);
		$hold(posedge RESET, negedge WRB, 0, NOTIFY_REG);
		$setup(posedge WRB, posedge RESET, 0, NOTIFY_REG);
		$setup(negedge WRB, posedge RESET, 0, NOTIFY_REG);

		(RDB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);

           // path delay from reaf ENABLE signals to DATA OUTPUT
		(RDB => DO0 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO3 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO4 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO5 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO6 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO7 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO8 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO0 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO3 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO4 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO5 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO6 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO7 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO8 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		$width(posedge RBLKB, 0.0, 0, NOTIFY_REG);
		$width(negedge RBLKB, 0.0, 0, NOTIFY_REG);
		$width(posedge RDB, 0.0, 0, NOTIFY_REG);
		$width(negedge RDB, 0.0, 0, NOTIFY_REG);

             // path delay from DIS to DOS 
		(DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);  

             // path delay from signal to all outputs
		(RESET => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);  



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : FIFO256x9AAP
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9AAP(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, RBLKB, WBLKB, PARODD;

 output  DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 //  some internal timing checking condition control signals
 wire WENABLE_RENABLE_hold_check_condition;
 wire WBLK_RENABLE_hold_check_condition;
 wire WENABLE_RBLK_hold_check_condition;
 wire WBLK_RBLK_hold_check_condition;
 wire RENABLE_WENABLE_hold_check_condition;
 wire RBLK_WENABLE_hold_check_condition;
 wire RENABLE_WBLK_hold_check_condition;
 wire RBLK_WBLK_hold_check_condition;
 wire DI_WENABLE_check_condition;
 wire DI_WBLK_check_condition;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;

 integer WB_initialized; // 1 = WB_int falling edge occured.  Must occur before first write after RESET.

 // Special variables to control flags
 
 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer level;
 integer depth_int;
 integer max_level;

/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_pargen_di_in  { DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int }
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 //  assign internal timing checking condition control signals
 assign WENABLE_RENABLE_hold_check_condition = (~RBLKB_int && FULL && ~WBLKB_int);
 assign WBLK_RENABLE_hold_check_condition = (~RBLKB_int && FULL && ~WRB_int);
 assign WENABLE_RBLK_hold_check_condition = (~RDB_int && FULL && ~WBLKB_int);
 assign WBLK_RBLK_hold_check_condition = (~RDB_int && FULL && ~WRB_int);
 assign RENABLE_WENABLE_hold_check_condition = (~WBLKB_int && EMPTY && ~RBLKB_int);
 assign RBLK_WENABLE_hold_check_condition = (~WBLKB_int && EMPTY && ~RDB_int);
 assign RENABLE_WBLK_hold_check_condition = (~WRB_int && EMPTY && ~RBLKB_int);
 assign RBLK_WBLK_hold_check_condition = (~WRB_int && EMPTY && ~RDB_int);
 assign DI_WENABLE_check_condition = (~WBLKB_int && ~FULL && RESET_int);
 assign DI_WBLK_check_condition = (~WRB_int && ~FULL && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (RBLKB_int, RBLKB);
 buf BUF_U25 (WBLKB_int, WBLKB);
 buf BUF_U26 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U27 (DOS, DIS_int);
 buf OUTBUF_U28 (FULL, FULL_int);
 buf OUTBUF_U29 (EMPTY, EMPTY_int);
 buf OUTBUF_U30 (EQTH, EQTH_int);
 buf OUTBUF_U31 (GEQTH, GEQTH_int);
 buf OUTBUF_U32 (DO0, DO0_int);
 buf OUTBUF_U33 (DO1, DO1_int);
 buf OUTBUF_U34 (DO2, DO2_int);
 buf OUTBUF_U35 (DO3, DO3_int);
 buf OUTBUF_U36 (DO4, DO4_int);
 buf OUTBUF_U37 (DO5, DO5_int);
 buf OUTBUF_U38 (DO6, DO6_int);
 buf OUTBUF_U39 (DO7, DO7_int);
 buf OUTBUF_U40 (DO8, DO8_int);


 /******************************* initilization ***************************************/

  initial 
    begin
      WBLKB_previous  = 1'bx;
      WRB_previous    = 1'bx;
      RBLKB_previous  = 1'bx;
      RDB_previous    = 1'bx;
      fifo_r_cnt      = 0;
      fifo_w_cnt      = 0;
      WB_initialized  = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
    end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh )
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: UNSYNC, not RCLK, RAEDING BE TRIGGERED BY READ ENABLE SIGNAL

 always @(negedge RB_int )
  begin
   if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
      begin
        read_fifo (`FIFO_do_out, fifo_r_cnt[7:0]);
        fifo_incr_counter(fifo_r_cnt,fifo_r_cnt);
        fifo_rpar;
      end
  end

 // set flags at the rising edge of RB_int, 
 //
 always @(posedge RB_int)
   begin
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
       begin
        fifo_flags;
       end
   end

   // if READ enable signal becomes unknown 'X', the read address will become X too.
   // so FIFO reading operation will corrupt.  user must reset the FIFO
   //
 always @(RB_int == 1'bx )
 begin
  if($time > 0) begin
      if((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (RBLKB_previous != 1'bx) && (RDB_previous != 1'bx))  begin
       $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
      end
     end
   end 


  //
  // RESET operation
  // 
 
  always @ ( negedge RESET_int )
    begin
      fifo_depth;
      fifo_r_cnt      = 0;
      fifo_w_cnt      = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
      fifo_flags;
      WBLKB_previous  = 1'bx;
      WRB_previous    = 1'bx;
      RBLKB_previous  = 1'bx;
      RDB_previous    = 1'bx;
      WB_initialized  = 0;
    end


  // Mimic strange flag behavior of silicon when WB held low
  // as RESET deasserted.

  always @ ( posedge RESET_int )
    begin
      if ( WB_int == 1'b0 ) begin
        hold_empty_low  = 1;
        hold_eqth_high  = 1;
        hold_geqth_high = 1;
        fifo_flags;
      end
    end


  always @ ( posedge WB_int )
    begin
      if ( RESET_int == 1'b1 ) begin
        hold_empty_low  = 0;
        hold_eqth_high  = 0;
        hold_geqth_high = 0;
        fifo_flags;
      end
    end


  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int = ~ RPE_int;
      WPE_int = ~ WPE_int;
    end

/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: UNSYNC, NO WCLK

  always @ ( negedge WB_int )
    begin
      if ( RESET_int === `FIFO_TRUE )
        WB_initialized = 1;
    end

 always @(posedge WB_int)
    begin
        if (( FULL_int === `FIFO_FALSE ) && ( RESET_int === `FIFO_TRUE ) &&
            ( WB_initialized == 1 ))  // i.e. not reset mode
                  begin
                    fifo_wpar;
                    fifo_pargen;
                    write_fifo ( fifo_w_cnt[7:0], `FIFO_pargen_di_in );
                    fifo_incr_counter(fifo_w_cnt,fifo_w_cnt);
                           fifo_flags;     // only do flags on rising edge of WCLK for async fifo
                  end
   end

 always @(WB_int == 1'bx)
   begin
     if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WBLKB_previous != 1'bx) && (WRB_previous != 1'bx))
     begin
       $display("Warning : WBLKB or WRB unknown at time %0.1f",$realtime);
       $display("        : can not write FIFO,");
     end
   end

  always @ ( `FIFO_di_in or DI8_int or PARODD_int )
    begin
      fifo_wpar;
    end


 /************************** VERILOG  FUNCTION SECTION *************************/

 task fifo_depth;
    begin
           depth = `FIFO_depth + 1;
           depth_size = depth;
           depth = 1 << depth;
    end
 endtask

 function fifo_count_compare;
    input [4:0] local_depth_size;
    integer   i;
    begin
     fifo_count_compare = `FIFO_FALSE;
     begin : CHECK_COUNTER_EQUALITY
                    for (i = 0; i < local_depth_size; i = i+1)
                    begin
                            if (fifo_r_cnt[i] !== fifo_w_cnt[i])
                                  begin
                                    fifo_count_compare = `FIFO_FALSE;
                                    disable CHECK_COUNTER_EQUALITY;
                                  end
                            else
                                  fifo_count_compare = `FIFO_TRUE;
                    end
    end
   end
  endfunction

  task fifo_flags;
 
    reg [8:0] temp_write_cnt;
    
    begin
    
      // compare fifo_w_cnt with fifo_r_cnt
      
      if ( fifo_count_compare ( depth_size )) begin
        if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
          FULL_int = `FIFO_FALSE;
          if ( hold_empty_low == 1 )
            EMPTY_int = `FIFO_FALSE;
          else
            EMPTY_int = `FIFO_TRUE;
        end else begin
          EMPTY_int = `FIFO_FALSE;
          FULL_int  = `FIFO_TRUE;
        end
      end else begin
        EMPTY_int = `FIFO_FALSE;
        FULL_int  = `FIFO_FALSE;
      end
      cnt_diff = fifo_w_cnt - fifo_r_cnt; // w_cnt is always bigger

      if ( cnt_diff [ 8 ] == 1 ) begin
        cnt_diff = cnt_diff + ( 2 * depth );
      end

      // Calculate the maximum level allowable for the selected depth
      
      thresh_reg = `FIFO_thresh;
      level      = thresh_reg;
      depth_int  = depth_size;
      max_level  = 2 ** depth_int;

      // compare cnt_diff with FIFO_thresh
      
      if ( hold_eqth_high == 1 )
        EQTH_int = `FIFO_TRUE;
      else begin
        if ( cnt_diff [ 8 : 0 ] == thresh_reg )
          EQTH_int = `FIFO_TRUE;
        else
          EQTH_int = `FIFO_FALSE;
      end
      if ( hold_geqth_high == 1 )
        GEQTH_int = `FIFO_TRUE;
      else begin
        if ( level > max_level )
          GEQTH_int = FULL_int; // GEQTH mimics FULL
        else begin
          if ( cnt_diff [ 8 : 0 ] >= thresh_reg )
            GEQTH_int = `FIFO_TRUE;
          else
            GEQTH_int = `FIFO_FALSE;
        end
      end

    end
    
  endtask // fifo_flags

 task fifo_incr_counter;
          output [8:0] out_reg;
          input [8:0]  in_reg;

          reg [8:0]        in_reg,out_reg;

        begin
           fifo_depth;
           if (in_reg == ((2 * depth) - 1))
               out_reg = 0;
           else
               out_reg = in_reg + 1;
        end
       endtask

 // make rpe output
  task fifo_rpar;
     begin
        par_f = fifo_par9(`FIFO_do_out);    // previously  `FIFO_par_do_out);
        RPE_int = par_f ^ PARODD_int;
     end

   endtask // fifo_rpar

 // Tasks to check/gen parity depending on PARGEN / PARODD
 // make wpe output
  task fifo_wpar;
    begin
      par_f = fifo_par8 ( `FIFO_par_di_in );
      WPE_int = par_f ^ PARODD_int;
      DI8_int_reg  = DI8_int;
     end
   endtask

  // Generate parity bit from DI(7:0) and replace DI8 with it.
  
  task fifo_pargen;
    begin
      if ( PARODD_int == 1'b0 ) 
        DI8_int_reg = fifo_par8 ( `FIFO_par_di_in );
      else
        DI8_int_reg = ~ fifo_par8 ( `FIFO_par_di_in );
    end
  endtask


  function  fifo_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par8 = ^temp_reg1;

  endfunction


  function  fifo_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_fifo;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `FIFO_TRUE)
        begin
         temp_reg = 9'hx;
         $display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
   data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_fifo;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `FIFO_TRUE)
     x_memory ;
   else if (f_address_out_of_range == `FIFO_TRUE)
     $display("Warning : Invalid writing because write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for ( j = 0; j < 9; j = j + 1 )
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `FIFO_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `FIFO_TRUE;
       $display("Warning : Bits on the Address Bus are unknown at time %10g", $realtime);
       $display("        : address is %b ", address);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `FIFO_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `FIFO_TRUE;
       $display("Warning : Bit [%d] on the data out bus is unknown at time %10g.", i, $realtime);
       $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `FIFO_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `FIFO_TRUE;
     $display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify



	      // setup and hold time for DATAIN DI[7:0] to WB 
		$setup(posedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);

              // holdup time for DATAin to WB 
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);

	      // pin to pin delay
		if(WBLKB_int === 1'b0)
		(WRB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // minimum  width requirement for WRITE ENABLE signals
		$width(posedge WRB, 0.0, 0, NOTIFY_REG);
		$width(negedge WRB, 0.0, 0, NOTIFY_REG);
		$width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
		$width(negedge WBLKB, 0.0, 0, NOTIFY_REG);

                $width(posedge RESET, 0.0, 0, NOTIFY_REG);
                $width(negedge RESET, 0.0, 0, NOTIFY_REG);


            // setup/hold timing for write enable signal to RESET
		$hold(posedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, posedge RESET, 0, NOTIFY_REG);
		$hold(negedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, negedge RESET, 0, NOTIFY_REG);
		$hold(posedge RESET, posedge WRB, 0, NOTIFY_REG);
		$hold(posedge RESET, negedge WRB, 0, NOTIFY_REG);
		$setup(posedge WRB, posedge RESET, 0, NOTIFY_REG);
		$setup(negedge WRB, posedge RESET, 0, NOTIFY_REG);

		(RDB => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);

           // path delay from reaf ENABLE signals to DATA OUTPUT
		(RDB => DO0 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO3 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO4 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO5 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO6 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO7 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO8 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO0 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO3 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO4 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO5 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO6 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO7 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO8 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		$width(posedge RBLKB, 0.0, 0, NOTIFY_REG);
		$width(negedge RBLKB, 0.0, 0, NOTIFY_REG);
		$width(posedge RDB, 0.0, 0, NOTIFY_REG);
		$width(negedge RDB, 0.0, 0, NOTIFY_REG);

             // path delay from DIS to DOS 
		(DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);  

             // path delay from signal to all outputs
		(RESET => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);  



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9AST(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS, RCLKS,  WPE, RPE, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;

 output  WPE, RPE, DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 wire DI_WENABLE_check_condition;
 wire DI_WBLK_check_condition;
 wire RBLK_RCLK_setup_check_condition;
 wire RENABLE_RCLK_setup_check_condition;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg RCLKS_previous;
 reg READ_AT_PREV_EDGE;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;

 integer WB_initialized; // 1 = WB_int falling edge occured.  Must occur before first write after RESET.

 // Special variables to control flags
 
 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer level;
 integer depth_int;
 integer max_level;

/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 assign DI_WENABLE_check_condition = (~WBLKB_int && ~FULL && RESET_int);
 assign DI_WBLK_check_condition = (~WRB_int && ~FULL && RESET_int);
 assign RBLK_RCLK_setup_check_condition = (RDB_int && ~EMPTY && RESET_int);
 assign RENABLE_RCLK_setup_check_condition = (RBLKB_int && ~EMPTY && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (RCLKS_int, RCLKS);
 buf BUF_U25 (RBLKB_int, RBLKB);
 buf BUF_U26 (WBLKB_int, WBLKB);
 buf BUF_U27 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U28 (DOS, DIS_int);
 buf OUTBUF_U29 (FULL, FULL_int);
 buf OUTBUF_U30 (EMPTY, EMPTY_int);
 buf OUTBUF_U31 (EQTH, EQTH_int);
 buf OUTBUF_U32 (GEQTH, GEQTH_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);
 buf OUTBUF_U42 (WPE, WPE_int);
 buf OUTBUF_U43 (RPE, RPE_int);


 /******************************* initilization ***************************************/

   initial 
     begin
      RCLKS_previous = 1'bx;
      READ_AT_PREV_EDGE =1'b0;
      WBLKB_previous = 1'bx;
      WRB_previous = 1'bx;
      RBLKB_previous = 1'bx;
      RDB_previous = 1'bx;
      fifo_r_cnt = 0;
      fifo_w_cnt = 0;
      WB_initialized = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
     end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh )
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(RCLKS_int) 
      begin 
          RCLKS_previous = RCLKS_int;
     end

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: SYNC with RCLK ;


 always @(posedge RCLKS_int)
   begin
     READ_AT_PREV_EDGE = 1'b0;
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
        begin
         if(RB_int === 1'b0) begin
              read_fifo (`FIFO_do_out, fifo_r_cnt[7:0]);
          READ_AT_PREV_EDGE =1'b1;
          // increase the read address counter
          fifo_incr_counter(fifo_r_cnt,fifo_r_cnt);
          // check the parity 
          fifo_rpar;
         end else if(RB_int === 1'bx) begin 
          $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
         end
        end
   end 

 // check  the situation of RCLK unknown 'X' 
 // if RCLK unknown, READing is ENABLED, and EMPTY is false, READ address will corrput
 //  user should reset the FIFO before continuing reading
 //
 always @(RCLKS_int === 1'bx )
 begin
  if($time > 0) begin
    if ((RB_int == 1'b0) && (EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (RCLKS_previous != 1'bx)) begin
      $display("Warning : RCLK unknown at time %0.1f, can not read FIFO. ",$realtime);
    end
  end
 end

 // set the flags at the falling edge of the rclk
 //
 always @(negedge RCLKS_int)
   begin
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (READ_AT_PREV_EDGE == 1'b1))  // i.e. not reset mode
       begin
        fifo_flags;
        READ_AT_PREV_EDGE =1'b0;
       end
   end


  //
  // RESET operation
  // 
 
  always @ ( negedge RESET_int )
  begin
   fifo_depth;
   fifo_r_cnt = 0;
   fifo_w_cnt = 0;
   hold_empty_low  = 0;
   hold_eqth_high  = 0;
   hold_geqth_high = 0;
   fifo_flags;
   RCLKS_previous = 1'bx;
   READ_AT_PREV_EDGE =1'b0;
   WBLKB_previous = 1'bx;
   WRB_previous = 1'bx;
   RBLKB_previous = 1'bx;
   RDB_previous = 1'bx;
   WB_initialized = 0;
  end


  // Mimic strange flag behavior of silicon when WB held low
  // as RESET deasserted.

  always @ ( posedge RESET_int )
    begin
      if ( WB_int == 1'b0 ) begin
        hold_empty_low  = 1;
        hold_eqth_high  = 1;
        hold_geqth_high = 1;
        fifo_flags;
      end
    end


  always @ ( posedge WB_int )
    begin
      if ( RESET_int == 1'b1 ) begin
        hold_empty_low  = 0;
        hold_eqth_high  = 0;
        hold_geqth_high = 0;
        fifo_flags;
      end
    end


  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      WPE_int  = ~ WPE_int;
    end




/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: UNSYNC, NO WCLK

  always @ ( negedge WB_int )
    begin
      if ( RESET_int === `FIFO_TRUE )
        WB_initialized = 1;
    end

 always @(posedge WB_int)
    begin
        if (( FULL_int === `FIFO_FALSE ) && ( RESET_int === `FIFO_TRUE ) &&
            ( WB_initialized == 1 ))  // i.e. not reset mode
                  begin
                    fifo_wpar;
                    write_fifo (fifo_w_cnt[7:0], `FIFO_di_in );
                    fifo_incr_counter(fifo_w_cnt,fifo_w_cnt);
                           fifo_flags;     // only do flags on rising edge of WCLK for async fifo
                  end
   end

 always @(WB_int == 1'bx)
   begin
     if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WBLKB_previous != 1'bx) && (WRB_previous != 1'bx))
     begin
       $display("Warning : WBLKB or WRB unknown at time %0.1f",$realtime);
       $display("        : can not write FIFO,");
     end
   end

  always @ ( `FIFO_di_in or DI8_int or PARODD_int )
    begin
      fifo_wpar;
    end


 /************************** VERILOG  FUNCTION SECTION *************************/

 task fifo_depth;
    begin
           depth = `FIFO_depth + 1;
           depth_size = depth;
           depth = 1 << depth;
    end
 endtask

 function fifo_count_compare;
    input [4:0] local_depth_size;
    integer   i;
    begin
     fifo_count_compare = `FIFO_FALSE;
     begin : CHECK_COUNTER_EQUALITY
                    for (i = 0; i < local_depth_size; i = i+1)
                    begin
                            if (fifo_r_cnt[i] !== fifo_w_cnt[i])
                                  begin
                                    fifo_count_compare = `FIFO_FALSE;
                                    disable CHECK_COUNTER_EQUALITY;
                                  end
                            else
                                  fifo_count_compare = `FIFO_TRUE;
                    end
    end
   end
  endfunction

  task fifo_flags;
 
    reg [8:0] temp_write_cnt;
    
    begin
    
      // compare fifo_w_cnt with fifo_r_cnt
      
      if ( fifo_count_compare ( depth_size )) begin
        if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
          FULL_int = `FIFO_FALSE;
          if ( hold_empty_low == 1 )
            EMPTY_int = `FIFO_FALSE;
          else
            EMPTY_int = `FIFO_TRUE;
        end else begin
          EMPTY_int = `FIFO_FALSE;
          FULL_int  = `FIFO_TRUE;
        end
      end else begin
        EMPTY_int = `FIFO_FALSE;
        FULL_int  = `FIFO_FALSE;
      end
      cnt_diff = fifo_w_cnt - fifo_r_cnt; // w_cnt is always bigger

      if ( cnt_diff [ 8 ] == 1 ) begin
        cnt_diff = cnt_diff + ( 2 * depth );
      end

      // Calculate the maximum level allowable for the selected depth
      
      thresh_reg = `FIFO_thresh;
      level      = thresh_reg;
      depth_int  = depth_size;
      max_level  = 2 ** depth_int;

      // compare cnt_diff with FIFO_thresh
      
      if ( hold_eqth_high == 1 )
        EQTH_int = `FIFO_TRUE;
      else begin
        if ( cnt_diff [ 8 : 0 ] == thresh_reg )
          EQTH_int = `FIFO_TRUE;
        else
          EQTH_int = `FIFO_FALSE;
      end
      if ( hold_geqth_high == 1 )
        GEQTH_int = `FIFO_TRUE;
      else begin
        if ( level > max_level )
          GEQTH_int = FULL_int; // GEQTH mimics FULL
        else begin
          if ( cnt_diff [ 8 : 0 ] >= thresh_reg )
            GEQTH_int = `FIFO_TRUE;
          else
            GEQTH_int = `FIFO_FALSE;
        end
      end

    end
    
  endtask // fifo_flags

 task fifo_incr_counter;
          output [8:0] out_reg;
          input [8:0]  in_reg;

          reg [8:0]        in_reg,out_reg;

        begin
           fifo_depth;
           if (in_reg == ((2 * depth) - 1))
               out_reg = 0;
           else
               out_reg = in_reg + 1;
        end
       endtask

 // make rpe output
  task fifo_rpar;
     begin
        par_f = fifo_par9(`FIFO_do_out);    // previously  `FIFO_par_do_out);
        RPE_int = par_f ^ PARODD_int;
     end

   endtask // fifo_rpar

 // Tasks to check/gen parity depending on PARGEN / PARODD
 // make wpe output
  task fifo_wpar;
    begin
      par_f = fifo_par8 ( `FIFO_par_di_in );
      par_f2 = par_f ^ DI8_int;
      WPE_int = par_f2 ^ PARODD_int;
      DI8_int_reg  = DI8_int;
    end
  endtask

  function  fifo_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par8 = ^temp_reg1;

  endfunction


  function  fifo_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_fifo;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `FIFO_TRUE)
        begin
         temp_reg = 9'hx;
         $display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
   data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_fifo;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `FIFO_TRUE)
     x_memory ;
   else if (f_address_out_of_range == `FIFO_TRUE)
     $display("Warning : Invalid writing because write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `FIFO_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `FIFO_TRUE;
       $display("Warning : Bits on the Address Bus are unknown at time %10g", $realtime);
       $display("        : address is %b ", address);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `FIFO_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `FIFO_TRUE;
       $display("Warning : Bit [%d] on the data out bus is unknown at time %10g.", i, $realtime);
       $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `FIFO_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `FIFO_TRUE;
     $display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify



	      // setup and hold time for DATAIN DI[7:0] to WB 
		$setup(posedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);

              // holdup time for DATAin to WB 
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);

	      // pin to pin delay
		(DI0 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI1 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI2 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI3 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI4 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI5 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI6 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI7 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI8 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // minimum  width requirement for WRITE ENABLE signals
		$width(posedge WRB, 0.0, 0, NOTIFY_REG);
		$width(negedge WRB, 0.0, 0, NOTIFY_REG);
		$width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
		$width(negedge WBLKB, 0.0, 0, NOTIFY_REG);

                $width(posedge RESET, 0.0, 0, NOTIFY_REG);
                $width(negedge RESET, 0.0, 0, NOTIFY_REG);


            // setup/hold timing for write enable signal to RESET
		$hold(posedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, posedge RESET, 0, NOTIFY_REG);
		$hold(negedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, negedge RESET, 0, NOTIFY_REG);
		$hold(posedge RESET, posedge WRB, 0, NOTIFY_REG);
		$hold(posedge RESET, negedge WRB, 0, NOTIFY_REG);
		$setup(posedge WRB, posedge RESET, 0, NOTIFY_REG);
		$setup(negedge WRB, posedge RESET, 0, NOTIFY_REG);

           

	   // setup and hold time for RBD and RBLKB to RCLK
	        $setup(negedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
	        $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), negedge RDB, 0.0, NOTIFY_REG);
                $setup(negedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), negedge RBLKB, 0.0, NOTIFY_REG);
                $setup(posedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), posedge RDB, 0.0, NOTIFY_REG);
                $setup(posedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), posedge RBLKB, 0.0, NOTIFY_REG);

	  // path delay parameters
		(RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // minimum RCLK  width 
		$width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge RCLKS, 0.0, 0, NOTIFY_REG);

           // recovery/hold timing for RCLKS to RESET signals
                $recovery(posedge RESET, posedge RCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge RCLKS, 0.0, NOTIFY_REG);
                $hold(posedge RCLKS, posedge RESET,  0.0, NOTIFY_REG);
                $hold(negedge RCLKS, posedge RESET, 0.0, NOTIFY_REG);

             // path delay from DIS to DOS 
		(DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);  

             // path delay from signal to all outputs
		(RESET => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);  



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9ASTP(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS, RCLKS, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;

 output  DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 wire DI_WENABLE_check_condition;
 wire DI_WBLK_check_condition;
 wire RBLK_RCLK_setup_check_condition;
 wire RENABLE_RCLK_setup_check_condition;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg RCLKS_previous;
 reg READ_AT_PREV_EDGE;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;

 integer WB_initialized; // 1 = WB_int falling edge occured.  Must occur before first write after RESET.

 // Special variables to control flags
 
 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer level;
 integer depth_int;
 integer max_level;

/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_pargen_di_in  { DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int }
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 assign DI_WENABLE_check_condition = (~WBLKB_int && ~FULL && RESET_int);
 assign DI_WBLK_check_condition = (~WRB_int && ~FULL && RESET_int);
 assign RBLK_RCLK_setup_check_condition = (RDB_int && ~EMPTY && RESET_int);
 assign RENABLE_RCLK_setup_check_condition = (RBLKB_int && ~EMPTY && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (RCLKS_int, RCLKS);
 buf BUF_U25 (RBLKB_int, RBLKB);
 buf BUF_U26 (WBLKB_int, WBLKB);
 buf BUF_U27 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U28 (DOS, DIS_int);
 buf OUTBUF_U29 (FULL, FULL_int);
 buf OUTBUF_U30 (EMPTY, EMPTY_int);
 buf OUTBUF_U31 (EQTH, EQTH_int);
 buf OUTBUF_U32 (GEQTH, GEQTH_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);


 /******************************* initilization ***************************************/

   initial 
     begin
      RCLKS_previous = 1'bx;
      READ_AT_PREV_EDGE =1'b0;
      WBLKB_previous = 1'bx;
      WRB_previous = 1'bx;
      RBLKB_previous = 1'bx;
      RDB_previous = 1'bx;
      fifo_r_cnt = 0;
      fifo_w_cnt = 0;
      WB_initialized = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
     end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh )
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(RCLKS_int) 
      begin 
          RCLKS_previous = RCLKS_int;
     end

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: SYNC with RCLK ;


 always @(posedge RCLKS_int)
   begin
     READ_AT_PREV_EDGE = 1'b0;
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
        begin
         if(RB_int === 1'b0) begin
              read_fifo (`FIFO_do_out, fifo_r_cnt[7:0]);
          READ_AT_PREV_EDGE =1'b1;
          // increase the read address counter
          fifo_incr_counter(fifo_r_cnt,fifo_r_cnt);
          // check the parity 
          fifo_rpar;
         end else if(RB_int === 1'bx) begin 
          $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
         end
        end
   end 

 // check  the situation of RCLK unknown 'X' 
 // if RCLK unknown, READing is ENABLED, and EMPTY is false, READ address will corrput
 //  user should reset the FIFO before continuing reading
 //
 always @(RCLKS_int === 1'bx )
 begin
  if($time > 0) begin
    if ((RB_int == 1'b0) && (EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (RCLKS_previous != 1'bx)) begin
      $display("Warning : RCLK unknown at time %0.1f, can not read FIFO. ",$realtime);
    end
  end
 end

 // set the flags at the falling edge of the rclk
 //
 always @(negedge RCLKS_int)
   begin
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (READ_AT_PREV_EDGE == 1'b1))  // i.e. not reset mode
       begin
        fifo_flags;
        READ_AT_PREV_EDGE =1'b0;
       end
   end


  //
  // RESET operation
  // 
 
  always @ ( negedge RESET_int )
  begin
   fifo_depth;
   fifo_r_cnt = 0;
   fifo_w_cnt = 0;
   hold_empty_low  = 0;
   hold_eqth_high  = 0;
   hold_geqth_high = 0;
   fifo_flags;
   RCLKS_previous = 1'bx;
   READ_AT_PREV_EDGE =1'b0;
   WBLKB_previous = 1'bx;
   WRB_previous = 1'bx;
   RBLKB_previous = 1'bx;
   RDB_previous = 1'bx;
   WB_initialized = 0;
  end


  // Mimic strange flag behavior of silicon when WB held low
  // as RESET deasserted.

  always @ ( posedge RESET_int )
    begin
      if ( WB_int == 1'b0 ) begin
        hold_empty_low  = 1;
        hold_eqth_high  = 1;
        hold_geqth_high = 1;
        fifo_flags;
      end
    end


  always @ ( posedge WB_int )
    begin
      if ( RESET_int == 1'b1 ) begin
        hold_empty_low  = 0;
        hold_eqth_high  = 0;
        hold_geqth_high = 0;
        fifo_flags;
      end
    end


  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      WPE_int  = ~ WPE_int;
    end


/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: UNSYNC, NO WCLK

  always @ ( negedge WB_int )
    begin
      if ( RESET_int === `FIFO_TRUE )
        WB_initialized = 1;
    end

 always @(posedge WB_int)
    begin
        if (( FULL_int === `FIFO_FALSE ) && ( RESET_int === `FIFO_TRUE ) &&
            ( WB_initialized == 1 ))  // i.e. not reset mode
                  begin
                    fifo_wpar;
                    fifo_pargen;
                    write_fifo ( fifo_w_cnt [ 7 : 0 ], `FIFO_pargen_di_in );
                    fifo_incr_counter(fifo_w_cnt,fifo_w_cnt);
                           fifo_flags;     // only do flags on rising edge of WCLK for async fifo
                  end
   end

 always @(WB_int == 1'bx)
   begin
     if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WBLKB_previous != 1'bx) && (WRB_previous != 1'bx))
     begin
       $display("Warning : WBLKB or WRB unknown at time %0.1f",$realtime);
       $display("        : can not write FIFO,");
     end
   end

  always @ ( `FIFO_di_in or DI8_int or PARODD_int )
    begin
      fifo_wpar;
    end


 /************************** VERILOG  FUNCTION SECTION *************************/

 task fifo_depth;
    begin
           depth = `FIFO_depth + 1;
           depth_size = depth;
           depth = 1 << depth;
    end
 endtask

 function fifo_count_compare;
    input [4:0] local_depth_size;
    integer   i;
    begin
     fifo_count_compare = `FIFO_FALSE;
     begin : CHECK_COUNTER_EQUALITY
                    for (i = 0; i < local_depth_size; i = i+1)
                    begin
                            if (fifo_r_cnt[i] !== fifo_w_cnt[i])
                                  begin
                                    fifo_count_compare = `FIFO_FALSE;
                                    disable CHECK_COUNTER_EQUALITY;
                                  end
                            else
                                  fifo_count_compare = `FIFO_TRUE;
                    end
    end
   end
  endfunction

  task fifo_flags;
 
    reg [8:0] temp_write_cnt;
    
    begin
    
      // compare fifo_w_cnt with fifo_r_cnt
      
      if ( fifo_count_compare ( depth_size )) begin
        if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
          FULL_int = `FIFO_FALSE;
          if ( hold_empty_low == 1 )
            EMPTY_int = `FIFO_FALSE;
          else
            EMPTY_int = `FIFO_TRUE;
        end else begin
          EMPTY_int = `FIFO_FALSE;
          FULL_int  = `FIFO_TRUE;
        end
      end else begin
        EMPTY_int = `FIFO_FALSE;
        FULL_int  = `FIFO_FALSE;
      end
      cnt_diff = fifo_w_cnt - fifo_r_cnt; // w_cnt is always bigger

      if ( cnt_diff [ 8 ] == 1 ) begin
        cnt_diff = cnt_diff + ( 2 * depth );
      end

      // Calculate the maximum level allowable for the selected depth
      
      thresh_reg = `FIFO_thresh;
      level      = thresh_reg;
      depth_int  = depth_size;
      max_level  = 2 ** depth_int;

      // compare cnt_diff with FIFO_thresh
      
      if ( hold_eqth_high == 1 )
        EQTH_int = `FIFO_TRUE;
      else begin
        if ( cnt_diff [ 8 : 0 ] == thresh_reg )
          EQTH_int = `FIFO_TRUE;
        else
          EQTH_int = `FIFO_FALSE;
      end
      if ( hold_geqth_high == 1 )
        GEQTH_int = `FIFO_TRUE;
      else begin
        if ( level > max_level )
          GEQTH_int = FULL_int; // GEQTH mimics FULL
        else begin
          if ( cnt_diff [ 8 : 0 ] >= thresh_reg )
            GEQTH_int = `FIFO_TRUE;
          else
            GEQTH_int = `FIFO_FALSE;
        end
      end

    end
    
  endtask // fifo_flags

 task fifo_incr_counter;
          output [8:0] out_reg;
          input [8:0]  in_reg;

          reg [8:0]        in_reg,out_reg;

        begin
           fifo_depth;
           if (in_reg == ((2 * depth) - 1))
               out_reg = 0;
           else
               out_reg = in_reg + 1;
        end
       endtask

 // make rpe output
  task fifo_rpar;
     begin
        par_f = fifo_par9(`FIFO_do_out);    // previously  `FIFO_par_do_out);
        RPE_int = par_f ^ PARODD_int;
     end

   endtask // fifo_rpar


 // Tasks to check/gen parity depending on PARGEN / PARODD
 // make wpe output
  task fifo_wpar;
     begin
        par_f = fifo_par8(`FIFO_par_di_in);
        WPE_int = par_f ^ PARODD_int;
        DI8_int_reg  = WPE_int;
     end
   endtask


  // Generate parity bit from DI(7:0) and replace DI8 with it.
  
  task fifo_pargen;
    begin
      if ( PARODD_int == 1'b0 ) 
        DI8_int_reg = fifo_par8 ( `FIFO_par_di_in );
      else
        DI8_int_reg = ~ fifo_par8 ( `FIFO_par_di_in );
    end
  endtask


  function  fifo_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par8 = ^temp_reg1;

  endfunction


  function  fifo_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_fifo;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `FIFO_TRUE)
        begin
         temp_reg = 9'hx;
         $display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
   data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_fifo;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `FIFO_TRUE)
     x_memory ;
   else if (f_address_out_of_range == `FIFO_TRUE)
     $display("Warning : Invalid writing because write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `FIFO_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `FIFO_TRUE;
       $display("Warning : Bits on the Address Bus are unknown at time %10g", $realtime);
       $display("        : address is %b ", address);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `FIFO_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `FIFO_TRUE;
       $display("Warning : Bit [%d] on the data out bus is unknown at time %10g.", i, $realtime);
       $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `FIFO_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `FIFO_TRUE;
     $display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify



	      // setup and hold time for DATAIN DI[7:0] to WB 
		$setup(posedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);

              // holdup time for DATAin to WB 
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);

	      // pin to pin delay
		if(WBLKB_int === 1'b0)
		(WRB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // minimum  width requirement for WRITE ENABLE signals
		$width(posedge WRB, 0.0, 0, NOTIFY_REG);
		$width(negedge WRB, 0.0, 0, NOTIFY_REG);
		$width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
		$width(negedge WBLKB, 0.0, 0, NOTIFY_REG);

            // setup/hold timing for write enable signal to RESET
		$hold(posedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, posedge RESET, 0, NOTIFY_REG);
		$hold(negedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, negedge RESET, 0, NOTIFY_REG);
		$hold(posedge RESET, posedge WRB, 0, NOTIFY_REG);
		$hold(posedge RESET, negedge WRB, 0, NOTIFY_REG);
		$setup(posedge WRB, posedge RESET, 0, NOTIFY_REG);
		$setup(negedge WRB, posedge RESET, 0, NOTIFY_REG);

	   // setup and hold time for RBD and RBLKB to RCLK
	     $setup(negedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), negedge RDB, 0.0, NOTIFY_REG);
             $setup(negedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
             $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), negedge RBLKB, 0.0, NOTIFY_REG);
             $setup(posedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
             $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), posedge RDB, 0.0, NOTIFY_REG);
             $setup(posedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
             $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), posedge RBLKB, 0.0, NOTIFY_REG);

	  // path delay parameters
		(RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // minimum RCLK  width 
		$width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge RCLKS, 0.0, 0, NOTIFY_REG);
                $width(posedge RESET, 0.0, 0, NOTIFY_REG);
                $width(negedge RESET, 0.0, 0, NOTIFY_REG);


           // recovery/hold timing for RCLKS to RESET signals
                $recovery(posedge RESET, posedge RCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge RCLKS, 0.0, NOTIFY_REG);
                $hold(posedge RCLKS, posedge RESET,  0.0, NOTIFY_REG);
                $hold(negedge RCLKS, posedge RESET, 0.0, NOTIFY_REG);

             // path delay from DIS to DOS 
		(DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);  

             // path delay from signal to all outputs
		(RESET => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);  



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

/*--------------------------------------------------------------------
 CELL NAME : FIFO256x9ASR
---------------------------------------------------------------------*/

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9ASR(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS, RCLKS,  WPE, RPE, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;

 output  WPE, RPE, DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 wire DI_WENABLE_check_condition;
 wire DI_WBLK_check_condition;
 wire RBLK_RCLK_setup_check_condition;
 wire RENABLE_RCLK_setup_check_condition;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] FIFO_do_out_stg1;
 reg       RPE_stg1;
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg RCLKS_previous;
 reg READ_AT_PREV_EDGE;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;

 integer WB_initialized; // 1 = WB_int falling edge occured.  Must occur before first write after RESET.

 // Special variables to control flags
 
 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer level;
 integer depth_int;
 integer max_level;

/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 assign DI_WENABLE_check_condition = (~WBLKB_int && ~FULL && RESET_int);
 assign DI_WBLK_check_condition = (~WRB_int && ~FULL && RESET_int);
 assign RBLK_RCLK_setup_check_condition = (RDB_int && ~EMPTY && RESET_int);
 assign RENABLE_RCLK_setup_check_condition = (RBLKB_int && ~EMPTY && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (RCLKS_int, RCLKS);
 buf BUF_U25 (RBLKB_int, RBLKB);
 buf BUF_U26 (WBLKB_int, WBLKB);
 buf BUF_U27 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U28 (DOS, DIS_int);
 buf OUTBUF_U29 (FULL, FULL_int);
 buf OUTBUF_U30 (EMPTY, EMPTY_int);
 buf OUTBUF_U31 (EQTH, EQTH_int);
 buf OUTBUF_U32 (GEQTH, GEQTH_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);
 buf OUTBUF_U42 (WPE, WPE_int);
 buf OUTBUF_U43 (RPE, RPE_int);


 /******************************* initilization ***************************************/

   initial 
     begin
      RCLKS_previous = 1'bx;
      READ_AT_PREV_EDGE =1'b0;
      WBLKB_previous = 1'bx;
      WRB_previous = 1'bx;
      RBLKB_previous = 1'bx;
      RDB_previous = 1'bx;
      fifo_r_cnt = 0;
      fifo_w_cnt = 0;
      WB_initialized = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
     end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh )
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(RCLKS_int) 
      begin 
          RCLKS_previous = RCLKS_int;
     end

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: SYNC with RCLK ;


 always @ ( posedge RCLKS_int )
   begin
     READ_AT_PREV_EDGE = 1'b0;
     `FIFO_do_out = FIFO_do_out_stg1;
     RPE_int = RPE_stg1;
     if (( EMPTY_int === `FIFO_FALSE ) && ( RESET_int === `FIFO_TRUE ))  // i.e. not reset mode
       begin
         if ( RB_int === 1'b0 ) begin
           read_fifo ( FIFO_do_out_stg1, fifo_r_cnt [ 7 : 0 ] );
           READ_AT_PREV_EDGE = 1'b1;
           // increase the read address counter
           fifo_incr_counter ( fifo_r_cnt, fifo_r_cnt );
           // check the parity 
           fifo_rpar;
         end else if ( RB_int === 1'bx ) begin 
           $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
         end
       end
   end 

 // check  the situation of RCLK unknown 'X' 
 // if RCLK unknown, READing is ENABLED, and EMPTY is false, READ address will corrput
 //  user should reset the FIFO before continuing reading
 //
 always @(RCLKS_int === 1'bx )
 begin
  if($time > 0) begin
    if ((RB_int == 1'b0) && (EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (RCLKS_previous != 1'bx)) begin
      $display("Warning : RCLK unknown at time %0.1f, can not read FIFO. ",$realtime);
    end
  end
 end

 // set the flags at the falling edge of the rclk
 //
 always @(negedge RCLKS_int)
   begin
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (READ_AT_PREV_EDGE == 1'b1))  // i.e. not reset mode
       begin
        fifo_flags;
        READ_AT_PREV_EDGE =1'b0;
       end
   end


 //
 // RESET operation  (async or sync)
 // 
 always @(negedge RESET_int)
  begin
   fifo_depth;
   fifo_r_cnt = 0;
   fifo_w_cnt = 0;
   hold_empty_low  = 0;
   hold_eqth_high  = 0;
   hold_geqth_high = 0;
   fifo_flags;
   RCLKS_previous = 1'bx;
   READ_AT_PREV_EDGE =1'b0;
   WBLKB_previous = 1'bx;
   WRB_previous = 1'bx;
   RBLKB_previous = 1'bx;
   RDB_previous = 1'bx;
   WB_initialized = 0;
  end


  // Mimic strange flag behavior of silicon when WB held low
  // as RESET deasserted.

  always @ ( posedge RESET_int )
    begin
      if ( WB_int == 1'b0 ) begin
        hold_empty_low  = 1;
        hold_eqth_high  = 1;
        hold_geqth_high = 1;
        fifo_flags;
      end
    end


  always @ ( posedge WB_int )
    begin
      if ( RESET_int == 1'b1 ) begin
        hold_empty_low  = 0;
        hold_eqth_high  = 0;
        hold_geqth_high = 0;
        fifo_flags;
      end
    end


  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      RPE_stg1 = ~ RPE_stg1;
      WPE_int  = ~ WPE_int;
    end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: UNSYNC, NO WCLK

  always @ ( negedge WB_int )
    begin
      if ( RESET_int === `FIFO_TRUE )
        WB_initialized = 1;
    end

 always @(posedge WB_int)
    begin
        if (( FULL_int === `FIFO_FALSE ) && ( RESET_int === `FIFO_TRUE ) &&
            ( WB_initialized == 1 ))  // i.e. not reset mode
                  begin
                    fifo_wpar;
                    write_fifo (fifo_w_cnt[7:0], `FIFO_di_in );
                    fifo_incr_counter(fifo_w_cnt,fifo_w_cnt);
                           fifo_flags;     // only do flags on rising edge of WCLK for async fifo
                  end
   end

 always @(WB_int == 1'bx)
   begin
     if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WBLKB_previous != 1'bx) && (WRB_previous != 1'bx))
     begin
       $display("Warning : WBLKB or WRB unknown at time %0.1f",$realtime);
       $display("        : can not write FIFO,");
     end
   end

  always @ ( `FIFO_di_in or DI8_int or PARODD_int )
    begin
      fifo_wpar;
    end


 /************************** VERILOG  FUNCTION SECTION *************************/

 task fifo_depth;
    begin
           depth = `FIFO_depth + 1;
           depth_size = depth;
           depth = 1 << depth;
    end
 endtask

 function fifo_count_compare;
    input [4:0] local_depth_size;
    integer   i;
    begin
     fifo_count_compare = `FIFO_FALSE;
     begin : CHECK_COUNTER_EQUALITY
                    for (i = 0; i < local_depth_size; i = i+1)
                    begin
                            if (fifo_r_cnt[i] !== fifo_w_cnt[i])
                                  begin
                                    fifo_count_compare = `FIFO_FALSE;
                                    disable CHECK_COUNTER_EQUALITY;
                                  end
                            else
                                  fifo_count_compare = `FIFO_TRUE;
                    end
    end
   end
  endfunction

  task fifo_flags;
 
    reg [8:0] temp_write_cnt;
    
    begin
    
      // compare fifo_w_cnt with fifo_r_cnt
      
      if ( fifo_count_compare ( depth_size )) begin
        if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
          FULL_int = `FIFO_FALSE;
          if ( hold_empty_low == 1 )
            EMPTY_int = `FIFO_FALSE;
          else
            EMPTY_int = `FIFO_TRUE;
        end else begin
          EMPTY_int = `FIFO_FALSE;
          FULL_int  = `FIFO_TRUE;
        end
      end else begin
        EMPTY_int = `FIFO_FALSE;
        FULL_int  = `FIFO_FALSE;
      end
      cnt_diff = fifo_w_cnt - fifo_r_cnt; // w_cnt is always bigger

      if ( cnt_diff [ 8 ] == 1 ) begin
        cnt_diff = cnt_diff + ( 2 * depth );
      end

      // Calculate the maximum level allowable for the selected depth
      
      thresh_reg = `FIFO_thresh;
      level      = thresh_reg;
      depth_int  = depth_size;
      max_level  = 2 ** depth_int;

      // compare cnt_diff with FIFO_thresh
      
      if ( hold_eqth_high == 1 )
        EQTH_int = `FIFO_TRUE;
      else begin
        if ( cnt_diff [ 8 : 0 ] == thresh_reg )
          EQTH_int = `FIFO_TRUE;
        else
          EQTH_int = `FIFO_FALSE;
      end
      if ( hold_geqth_high == 1 )
        GEQTH_int = `FIFO_TRUE;
      else begin
        if ( level > max_level )
          GEQTH_int = FULL_int; // GEQTH mimics FULL
        else begin
          if ( cnt_diff [ 8 : 0 ] >= thresh_reg )
            GEQTH_int = `FIFO_TRUE;
          else
            GEQTH_int = `FIFO_FALSE;
        end
      end

    end
    
  endtask // fifo_flags

 task fifo_incr_counter;
          output [8:0] out_reg;
          input [8:0]  in_reg;

          reg [8:0]        in_reg,out_reg;

        begin
           fifo_depth;
           if (in_reg == ((2 * depth) - 1))
               out_reg = 0;
           else
               out_reg = in_reg + 1;
        end
       endtask

 // make rpe output
  task fifo_rpar;
     begin
        par_f = fifo_par9(FIFO_do_out_stg1);    // get parity of the intermediate output
        RPE_stg1 = par_f ^ PARODD_int;
     end

   endtask // fifo_rpar

 // Tasks to check/gen parity depending on PARGEN / PARODD
 // make wpe output
  task fifo_wpar;
    begin
      par_f = fifo_par8 ( `FIFO_par_di_in );
      par_f2 = par_f ^ DI8_int;
      WPE_int = par_f2 ^ PARODD_int;
      DI8_int_reg  = DI8_int;
    end
  endtask

  function  fifo_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par8 = ^temp_reg1;

  endfunction


  function  fifo_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_fifo;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `FIFO_TRUE)
        begin
         temp_reg = 9'hx;
         $display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
   data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_fifo;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `FIFO_TRUE)
     x_memory ;
   else if (f_address_out_of_range == `FIFO_TRUE)
     $display("Warning : Invalid writing because write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `FIFO_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `FIFO_TRUE;
       $display("Warning : Bits on the Address Bus are unknown at time %10g", $realtime);
       $display("        : address is %b ", address);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `FIFO_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `FIFO_TRUE;
       $display("Warning : Bit [%d] on the data out bus is unknown at time %10g.", i, $realtime);
       $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `FIFO_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `FIFO_TRUE;
     $display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify



	      // setup and hold time for DATAIN DI[7:0] to WB 
		$setup(posedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);

              // holdup time for DATAin to WB 
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);

	      // pin to pin delay
		(DI0 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI1 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI2 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI3 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI4 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI5 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI6 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI7 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(DI8 => WPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // minimum  width requirement for WRITE ENABLE signals
		$width(posedge WRB, 0.0, 0, NOTIFY_REG);
		$width(negedge WRB, 0.0, 0, NOTIFY_REG);
		$width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
		$width(negedge WBLKB, 0.0, 0, NOTIFY_REG);
                $width(posedge RESET, 0.0, 0, NOTIFY_REG);
                $width(negedge RESET, 0.0, 0, NOTIFY_REG);


            // setup/hold timing for write enable signal to RESET
		$hold(posedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, posedge RESET, 0, NOTIFY_REG);
		$hold(negedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, negedge RESET, 0, NOTIFY_REG);
		$hold(posedge RESET, posedge WRB, 0, NOTIFY_REG);
		$hold(posedge RESET, negedge WRB, 0, NOTIFY_REG);
		$setup(posedge WRB, posedge RESET, 0, NOTIFY_REG);
		$setup(negedge WRB, posedge RESET, 0, NOTIFY_REG);

	   // setup and hold time for RBD and RBLKB to RCLK
	     $setup(negedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), negedge RDB, 0.0, NOTIFY_REG);
             $setup(negedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
             $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), negedge RBLKB, 0.0, NOTIFY_REG);
             $setup(posedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
             $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), posedge RDB, 0.0, NOTIFY_REG);
             $setup(posedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
             $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), posedge RBLKB, 0.0, NOTIFY_REG);

	  // path delay parameters
		(RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // minimum RCLK  width 
		$width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge RCLKS, 0.0, 0, NOTIFY_REG);


           // recovery/hold timing for RCLKS to RESET signals
                $recovery(posedge RESET, posedge RCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge RCLKS, 0.0, NOTIFY_REG);
                $hold(posedge RCLKS, posedge RESET,  0.0, NOTIFY_REG);
                $hold(negedge RCLKS, posedge RESET, 0.0, NOTIFY_REG);
	    
             // path delay from DIS to DOS 
		(DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);  

             // path delay from signal to all outputs
		(RESET => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);  



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9ASRP(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS, RCLKS, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, RCLKS, RBLKB, WBLKB, PARODD;

 output  DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 wire DI_WENABLE_check_condition;
 wire DI_WBLK_check_condition;
 wire RBLK_RCLK_setup_check_condition;
 wire RENABLE_RCLK_setup_check_condition;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] FIFO_do_out_stg1;
 reg       RPE_stg1;
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg RCLKS_previous;
 reg READ_AT_PREV_EDGE;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;

 integer WB_initialized; // 1 = WB_int falling edge occured.  Must occur before first write after RESET.

 // Special variables to control flags
 
 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer level;
 integer depth_int;
 integer max_level;

/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_pargen_di_in  { DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int }
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 assign DI_WENABLE_check_condition = (~WBLKB_int && ~FULL && RESET_int);
 assign DI_WBLK_check_condition = (~WRB_int && ~FULL && RESET_int);
 assign RBLK_RCLK_setup_check_condition = (RDB_int && ~EMPTY && RESET_int);
 assign RENABLE_RCLK_setup_check_condition = (RBLKB_int && ~EMPTY && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (RCLKS_int, RCLKS);
 buf BUF_U25 (RBLKB_int, RBLKB);
 buf BUF_U26 (WBLKB_int, WBLKB);
 buf BUF_U27 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U28 (DOS, DIS_int);
 buf OUTBUF_U29 (FULL, FULL_int);
 buf OUTBUF_U30 (EMPTY, EMPTY_int);
 buf OUTBUF_U31 (EQTH, EQTH_int);
 buf OUTBUF_U32 (GEQTH, GEQTH_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);


 /******************************* initilization ***************************************/

   initial 
     begin
      RCLKS_previous = 1'bx;
      READ_AT_PREV_EDGE =1'b0;
      WBLKB_previous = 1'bx;
      WRB_previous = 1'bx;
      RBLKB_previous = 1'bx;
      RDB_previous = 1'bx;
      fifo_r_cnt = 0;
      fifo_w_cnt = 0;
      WB_initialized = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
     end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh )
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(RCLKS_int) 
      begin 
          RCLKS_previous = RCLKS_int;
     end

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: SYNC with RCLK ;


 always @(posedge RCLKS_int)
   begin
     READ_AT_PREV_EDGE = 1'b0;
     `FIFO_do_out = FIFO_do_out_stg1;
     RPE_int = RPE_stg1;
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
        begin
         if(RB_int === 1'b0) begin
              read_fifo (FIFO_do_out_stg1, fifo_r_cnt[7:0]);
          READ_AT_PREV_EDGE =1'b1;
          // increase the read address counter
          fifo_incr_counter(fifo_r_cnt,fifo_r_cnt);
          // check the parity 
          fifo_rpar;
         end else if(RB_int === 1'bx) begin 
          $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
         end
        end
   end 

 // check  the situation of RCLK unknown 'X' 
 // if RCLK unknown, READing is ENABLED, and EMPTY is false, READ address will corrput
 //  user should reset the FIFO before continuing reading
 //
 always @(RCLKS_int === 1'bx )
 begin
  if($time > 0) begin
    if ((RB_int == 1'b0) && (EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (RCLKS_previous != 1'bx)) begin
      $display("Warning : RCLK unknown at time %0.1f, can not read FIFO. ",$realtime);
    end
  end
 end

 // set the flags at the falling edge of the rclk
 //
 always @(negedge RCLKS_int)
   begin
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (READ_AT_PREV_EDGE == 1'b1))  // i.e. not reset mode
       begin
        fifo_flags;
        READ_AT_PREV_EDGE =1'b0;
       end
   end


  //
  // RESET operation
  // 

  always @ ( negedge RESET_int )
  begin
   fifo_depth;
   fifo_r_cnt = 0;
   fifo_w_cnt = 0;
   hold_empty_low  = 0;
   hold_eqth_high  = 0;
   hold_geqth_high = 0;
   fifo_flags;
   RCLKS_previous = 1'bx;
   READ_AT_PREV_EDGE =1'b0;
   WBLKB_previous = 1'bx;
   WRB_previous = 1'bx;
   RBLKB_previous = 1'bx;
   RDB_previous = 1'bx;
   WB_initialized = 0;
  end


  // Mimic strange flag behavior of silicon when WB held low
  // as RESET deasserted.

  always @ ( posedge RESET_int )
    begin
      if ( WB_int == 1'b0 ) begin
        hold_empty_low  = 1;
        hold_eqth_high  = 1;
        hold_geqth_high = 1;
        fifo_flags;
      end
    end


  always @ ( posedge WB_int )
    begin
      if ( RESET_int == 1'b1 ) begin
        hold_empty_low  = 0;
        hold_eqth_high  = 0;
        hold_geqth_high = 0;
        fifo_flags;
      end
    end


  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      RPE_stg1 = ~ RPE_stg1;
      WPE_int  = ~ WPE_int;
    end




/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: UNSYNC, NO WCLK

  always @ ( negedge WB_int )
    begin
      if ( RESET_int === `FIFO_TRUE )
        WB_initialized = 1;
    end

 always @(posedge WB_int)
    begin
        if (( FULL_int === `FIFO_FALSE ) && ( RESET_int === `FIFO_TRUE ) &&
            ( WB_initialized == 1 ))  // i.e. not reset mode
                  begin
                    fifo_wpar;
                    fifo_pargen;
                    write_fifo ( fifo_w_cnt [ 7 : 0 ], `FIFO_pargen_di_in );
                    fifo_incr_counter(fifo_w_cnt,fifo_w_cnt);
                           fifo_flags;     // only do flags on rising edge of WCLK for async fifo
                  end
   end

 always @(WB_int == 1'bx)
   begin
     if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WBLKB_previous != 1'bx) && (WRB_previous != 1'bx))
     begin
       $display("Warning : WBLKB or WRB unknown at time %0.1f",$realtime);
       $display("        : can not write FIFO,");
     end
   end

  always @ ( `FIFO_di_in or DI8_int or PARODD_int )
    begin
      fifo_wpar;
    end


 /************************** VERILOG  FUNCTION SECTION *************************/

 task fifo_depth;
    begin
           depth = `FIFO_depth + 1;
           depth_size = depth;
           depth = 1 << depth;
    end
 endtask

 function fifo_count_compare;
    input [4:0] local_depth_size;
    integer   i;
    begin
     fifo_count_compare = `FIFO_FALSE;
     begin : CHECK_COUNTER_EQUALITY
                    for (i = 0; i < local_depth_size; i = i+1)
                    begin
                            if (fifo_r_cnt[i] !== fifo_w_cnt[i])
                                  begin
                                    fifo_count_compare = `FIFO_FALSE;
                                    disable CHECK_COUNTER_EQUALITY;
                                  end
                            else
                                  fifo_count_compare = `FIFO_TRUE;
                    end
    end
   end
  endfunction

  task fifo_flags;
 
    reg [8:0] temp_write_cnt;
    
    begin
    
      // compare fifo_w_cnt with fifo_r_cnt
      
      if ( fifo_count_compare ( depth_size )) begin
        if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
          FULL_int = `FIFO_FALSE;
          if ( hold_empty_low == 1 )
            EMPTY_int = `FIFO_FALSE;
          else
            EMPTY_int = `FIFO_TRUE;
        end else begin
          EMPTY_int = `FIFO_FALSE;
          FULL_int  = `FIFO_TRUE;
        end
      end else begin
        EMPTY_int = `FIFO_FALSE;
        FULL_int  = `FIFO_FALSE;
      end
      cnt_diff = fifo_w_cnt - fifo_r_cnt; // w_cnt is always bigger

      if ( cnt_diff [ 8 ] == 1 ) begin
        cnt_diff = cnt_diff + ( 2 * depth );
      end

      // Calculate the maximum level allowable for the selected depth
      
      thresh_reg = `FIFO_thresh;
      level      = thresh_reg;
      depth_int  = depth_size;
      max_level  = 2 ** depth_int;

      // compare cnt_diff with FIFO_thresh
      
      if ( hold_eqth_high == 1 )
        EQTH_int = `FIFO_TRUE;
      else begin
        if ( cnt_diff [ 8 : 0 ] == thresh_reg )
          EQTH_int = `FIFO_TRUE;
        else
          EQTH_int = `FIFO_FALSE;
      end
      if ( hold_geqth_high == 1 )
        GEQTH_int = `FIFO_TRUE;
      else begin
        if ( level > max_level )
          GEQTH_int = FULL_int; // GEQTH mimics FULL
        else begin
          if ( cnt_diff [ 8 : 0 ] >= thresh_reg )
            GEQTH_int = `FIFO_TRUE;
          else
            GEQTH_int = `FIFO_FALSE;
        end
      end

    end
    
  endtask // fifo_flags

 task fifo_incr_counter;
          output [8:0] out_reg;
          input [8:0]  in_reg;

          reg [8:0]        in_reg,out_reg;

        begin
           fifo_depth;
           if (in_reg == ((2 * depth) - 1))
               out_reg = 0;
           else
               out_reg = in_reg + 1;
        end
       endtask

 // make rpe output
  task fifo_rpar;
     begin
        par_f = fifo_par9(FIFO_do_out_stg1);    // get parity of the intermediate output
        RPE_stg1 = par_f ^ PARODD_int;
     end

   endtask // fifo_rpar

 // Tasks to check/gen parity depending on PARGEN / PARODD
 // make wpe output
  task fifo_wpar;
     begin
        par_f = fifo_par8(`FIFO_par_di_in);
        WPE_int = par_f ^ PARODD_int;
     end
   endtask

  // Generate parity bit from DI(7:0) and replace DI8 with it.
  
  task fifo_pargen;
    begin
      if ( PARODD_int == 1'b0 ) 
        DI8_int_reg = fifo_par8 ( `FIFO_par_di_in );
      else
        DI8_int_reg = ~ fifo_par8 ( `FIFO_par_di_in );
    end
  endtask

  function  fifo_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par8 = ^temp_reg1;

  endfunction


  function  fifo_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_fifo;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `FIFO_TRUE)
        begin
         temp_reg = 9'hx;
         $display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
   data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_fifo;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `FIFO_TRUE)
     x_memory ;
   else if (f_address_out_of_range == `FIFO_TRUE)
     $display("Warning : Invalid writing because write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `FIFO_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `FIFO_TRUE;
       $display("Warning : Bits on the Address Bus are unknown at time %10g", $realtime);
       $display("        : address is %b ", address);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `FIFO_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `FIFO_TRUE;
       $display("Warning : Bit [%d] on the data out bus is unknown at time %10g.", i, $realtime);
       $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `FIFO_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `FIFO_TRUE;
     $display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify



	      // setup and hold time for DATAIN DI[7:0] to WB 
		$setup(posedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI0, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI1, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI2, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI3, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI4, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI5, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI6, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI7, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WRB &&& (DI_WENABLE_check_condition), 0.0, NOTIFY_REG);
                $setup(negedge DI8, posedge WBLKB &&& (DI_WBLK_check_condition), 0.0, NOTIFY_REG);

              // holdup time for DATAin to WB 
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WRB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WBLKB &&& (DI_WENABLE_check_condition), negedge DI8, 0.0, NOTIFY_REG);

	      // pin to pin delay
		if(WBLKB_int === 1'b0)
		(WRB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WBLKB_int === 1'b0)
		(WRB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => FULL ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EMPTY ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => EQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		if(WRB_int === 1'b0)
		(WBLKB => GEQTH ) = (0.1:0.1:0.1, 0.1:0.1:0.1);

            // minimum  width requirement for WRITE ENABLE signals
		$width(posedge WRB, 0.0, 0, NOTIFY_REG);
		$width(negedge WRB, 0.0, 0, NOTIFY_REG);
		$width(posedge WBLKB, 0.0, 0, NOTIFY_REG);
		$width(negedge WBLKB, 0.0, 0, NOTIFY_REG);

            // setup/hold timing for write enable signal to RESET
		$hold(posedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, posedge RESET, 0, NOTIFY_REG);
		$hold(negedge RESET, posedge WBLKB, 0, NOTIFY_REG);
		$setup(posedge WBLKB, negedge RESET, 0, NOTIFY_REG);
		$hold(posedge RESET, posedge WRB, 0, NOTIFY_REG);
		$hold(posedge RESET, negedge WRB, 0, NOTIFY_REG);
		$setup(posedge WRB, posedge RESET, 0, NOTIFY_REG);
		$setup(negedge WRB, posedge RESET, 0, NOTIFY_REG);

	   // setup and hold time for RBD and RBLKB to RCLK
	        $setup(negedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
	        $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), negedge RDB, 0.0, NOTIFY_REG);
                $setup(negedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), negedge RBLKB, 0.0, NOTIFY_REG);
                $setup(posedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), posedge RDB, 0.0, NOTIFY_REG);
                $setup(posedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), posedge RBLKB, 0.0, NOTIFY_REG);

	  // path delay parameters
		(RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // minimum RCLK  width 
		$width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge RCLKS, 0.0, 0, NOTIFY_REG);
                $width(posedge RESET, 0.0, 0, NOTIFY_REG);
                $width(negedge RESET, 0.0, 0, NOTIFY_REG);


           // recovery/hold timing for RCLKS to RESET signals
                $recovery(posedge RESET, posedge RCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge RCLKS, 0.0, NOTIFY_REG);
                $hold(posedge RCLKS, posedge RESET,  0.0, NOTIFY_REG);
                $hold(negedge RCLKS, posedge RESET, 0.0, NOTIFY_REG);

             // path delay from DIS to DOS 
		(DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);  

             // path delay from signal to all outputs
		(RESET => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);  



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults

`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9SA(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS, WCLKS,  WPE, RPE, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, WCLKS, RBLKB, WBLKB, PARODD;

 output  WPE, RPE, DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 wire DI_WCLK_check_condition;

 // Special variables to control flags
 
 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer hold_full_low;
 integer hold_empty_high;
 integer hold_eqth_low;
 integer hold_geqth_low;
 integer level;
 integer depth_int;
 integer max_level;
 time    WCLKS_re;
 time    WCLKS_fe;
 time    WCLKS_fe_prev;
 time    WB_re;
 time    RESET_re;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg WCLKS_previous;
 reg WRITE_AT_PREV_EDGE;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;


/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 assign DI_WCLK_check_condition = (~WB_int && ~FULL && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (WCLKS_int, WCLKS);
 buf BUF_U25 (RBLKB_int, RBLKB);
 buf BUF_U26 (WBLKB_int, WBLKB);
 buf BUF_U27 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U28 (DOS, DIS_int);
 buf OUTBUF_U29 (FULL, FULL_int);
 buf OUTBUF_U30 (EMPTY, EMPTY_int);
 buf OUTBUF_U31 (EQTH, EQTH_int);
 buf OUTBUF_U32 (GEQTH, GEQTH_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);
 buf OUTBUF_U42 (WPE, WPE_int);
 buf OUTBUF_U43 (RPE, RPE_int);


 /******************************* initilization ***************************************/

   initial 
     begin
      WCLKS_previous = 1'bx;
      WRITE_AT_PREV_EDGE =1'b0;
      WBLKB_previous = 1'bx;
      WRB_previous = 1'bx;
      RBLKB_previous = 1'bx;
      RDB_previous = 1'bx;
      fifo_r_cnt = 0;
      fifo_w_cnt = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
      hold_full_low   = 0;
      hold_empty_high = 0;
      hold_eqth_low   = 0;
      hold_geqth_low  = 0;
     end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh )
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(WCLKS_int) 
      begin 
          WCLKS_previous = WCLKS_int;
     end

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: ASYNC READ TRIGGERED BY RB

 always @ ( negedge RB_int )
   begin
     if (( EMPTY_int === `FIFO_FALSE )  && ( RESET_int === `FIFO_TRUE ))  // i.e. not reset mode
       begin
         read_fifo ( `FIFO_do_out, fifo_r_cnt [ 7 : 0 ] );
         fifo_incr_counter(fifo_r_cnt,fifo_r_cnt);
         fifo_rpar;
       end
   end

 // set flags at the rising edge of RB_int, 
 //
 always @ ( posedge RB_int )
   begin
     if (( EMPTY_int === `FIFO_FALSE )  && ( RESET_int === `FIFO_TRUE ))  // i.e. not reset mode
       begin
         fifo_flags;
       end
   end

   // if READ enable signal becomes unknown 'X', the read address will become X too.
   // so FIFO reading operation will corrupt.  user must reset the FIFO
   //
 always @(RB_int == 1'bx )
 begin
  if($time > 0) begin
      if((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (RBLKB_previous != 1'bx) && (RDB_previous != 1'bx))  begin
       $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
      end
     end
   end 


  //
  // RESET operation
  // 
 
  always @ ( negedge RESET_int )
    begin
      fifo_depth;
      fifo_r_cnt         = 0;
      fifo_w_cnt         = 0;
      hold_empty_low     = 0;
      hold_eqth_high     = 0;
      hold_geqth_high    = 0;
      hold_full_low      = 0;
      hold_empty_high    = 0;
      hold_eqth_low      = 0;
      hold_geqth_low     = 0;
      fifo_flags;
      WCLKS_previous     = 1'bx;
      WRITE_AT_PREV_EDGE =1'b0;
      WBLKB_previous     = 1'bx;
      WRB_previous       = 1'bx;
      RBLKB_previous     = 1'bx;
      RDB_previous       = 1'bx;
    end


  // Mimic unusual flag behavior of silicon when WCLKS held high
  // as RESET deasserted.

  always @ ( posedge WCLKS_int )
    begin
      WCLKS_re = $time;
    end


  always @ ( posedge WB_int )
    begin
      WB_re = $time;
    end


  always @ ( posedge RESET_int )
    begin
      RESET_re = $time;
      if ( WCLKS_int == 1'b1 ) begin
        if ( WCLKS_re == WB_re ) begin
          hold_full_low   = 1; // until next reset
          hold_empty_high = 1;
          hold_eqth_low   = 1;
          hold_geqth_low  = 1;
          fifo_flags;
        end else if ( WB_int == 1'b0 ) begin
          hold_empty_low  = 1; // until next WCLKS falling edge
          hold_eqth_high  = 1;
          hold_geqth_high = 1;
          fifo_flags;
        end else if ( WCLKS_re < WB_re ) begin
          hold_empty_low  = 1; // until next WCLKS falling edge
          hold_eqth_high  = 1;
          hold_geqth_high = 1;
          fifo_flags;
        end else if ( WB_re < WCLKS_re ) begin
          hold_empty_low  = 0; // expected behavior
          hold_eqth_high  = 0;
          hold_geqth_high = 0;
          hold_full_low   = 0;
          hold_empty_high = 0;
          hold_eqth_low   = 0;
          hold_geqth_low  = 0;
          fifo_flags;
        end
      end
    end


  always @ ( negedge WCLKS_int )
    begin
      WCLKS_fe_prev = WCLKS_fe;
      WCLKS_fe = $time;
      if ( RESET_int == 1'b1 ) begin
        hold_empty_low  = 0; // return to normal behavior
        hold_eqth_high  = 0;
        hold_geqth_high = 0;
        if ( WCLKS_fe_prev < RESET_re )
          fifo_flags;
      end
    end


  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      WPE_int  = ~ WPE_int;
    end




/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: SYNC with WCLK
 always @ ( posedge WCLKS_int )
   begin 
     fifo_wpar;  // WPE triggered by rising CLK edge in sync write mode
     WRITE_AT_PREV_EDGE = 1'b0;
     if (( FULL_int === `FIFO_FALSE ) && ( RESET_int === `FIFO_TRUE ))  // i.e. not reset mode
       begin
         if ( WB_int === 1'b0) begin 
           write_fifo (fifo_w_cnt[7:0], `FIFO_di_in );
           fifo_incr_counter(fifo_w_cnt,fifo_w_cnt);
           WRITE_AT_PREV_EDGE = 1'b1;
         end else if(WB_int === 1'bx) begin
           $display("Warning : WBLKB or WRB unknown at time %0.1f, can not write FIFO",$realtime);
         end
       end
   end

 // any time when WCLK unknown, and Write is enabled, the write address is corruptted
 // because the write address pointer could be increased by one or stay the same 
 //
 always @(WCLKS_int === 1'bx )
  begin
    if($time > 0) begin
      if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WB_int === 1'b0) && (WCLKS_previous != 1'bx)) begin 
         $display("Warning : WCLK unknown at time %0.1f",$realtime);
         $display("        : can not write FIFO, ");
      end
    end
 end

 always @(negedge WCLKS_int)
   begin
             if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WRITE_AT_PREV_EDGE === 1'b1))  // i.e. not reset mode
                  begin
                     fifo_flags;     // only do flags on rising edge of WCLK for async fifo
                     WRITE_AT_PREV_EDGE = 1'b0;
                  end
   end


 /************************** VERILOG  FUNCTION SECTION *************************/

 task fifo_depth;
    begin
           depth = `FIFO_depth + 1;
           depth_size = depth;
           depth = 1 << depth;
    end
 endtask

 function fifo_count_compare;
    input [4:0] local_depth_size;
    integer   i;
    begin
     fifo_count_compare = `FIFO_FALSE;
     begin : CHECK_COUNTER_EQUALITY
                    for (i = 0; i < local_depth_size; i = i+1)
                    begin
                            if (fifo_r_cnt[i] !== fifo_w_cnt[i])
                                  begin
                                    fifo_count_compare = `FIFO_FALSE;
                                    disable CHECK_COUNTER_EQUALITY;
                                  end
                            else
                                  fifo_count_compare = `FIFO_TRUE;
                    end
    end
   end
  endfunction

  task fifo_flags;
 
    reg [8:0] temp_write_cnt;
    
    begin
    
      // compare fifo_w_cnt with fifo_r_cnt
      
      if ( hold_empty_high == 1 )
        EMPTY_int = `FIFO_TRUE;
      else if ( hold_empty_low == 1 )
        EMPTY_int = `FIFO_FALSE;
      else begin

        if ( fifo_count_compare ( depth_size )) begin
          if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
            EMPTY_int = `FIFO_TRUE;
          end else begin
            EMPTY_int = `FIFO_FALSE;
          end
        end else begin
          EMPTY_int = `FIFO_FALSE;
        end
      end

      if ( hold_full_low == 1 )
        FULL_int = `FIFO_FALSE;
      else begin

        if ( fifo_count_compare ( depth_size )) begin
          if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
            FULL_int = `FIFO_FALSE;
          end else begin
            FULL_int  = `FIFO_TRUE;
          end
        end else begin
          FULL_int  = `FIFO_FALSE;
        end
      end


      cnt_diff = fifo_w_cnt - fifo_r_cnt; // w_cnt is always bigger

      if ( cnt_diff [ 8 ] == 1 ) begin
        cnt_diff = cnt_diff + ( 2 * depth );
      end

      // Calculate the maximum level allowable for the selected depth
      
      thresh_reg = `FIFO_thresh;
      level      = thresh_reg;
      depth_int  = depth_size;
      max_level  = 2 ** depth_int;

      // compare cnt_diff with FIFO_thresh
      
      if ( hold_eqth_high == 1 )
        EQTH_int = `FIFO_TRUE;
      else if ( hold_eqth_low == 1 )
        EQTH_int = `FIFO_FALSE;
      else begin
        if ( cnt_diff [ 8 : 0 ] == thresh_reg )
          EQTH_int = `FIFO_TRUE;
        else
          EQTH_int = `FIFO_FALSE;
      end
      if ( hold_geqth_high == 1 )
        GEQTH_int = `FIFO_TRUE;
      else if ( hold_geqth_low == 1 )
        GEQTH_int = `FIFO_FALSE;
      else begin
        if ( level > max_level )
          GEQTH_int = FULL_int; // GEQTH mimics FULL
        else begin
          if ( cnt_diff [ 8 : 0 ] >= thresh_reg )
            GEQTH_int = `FIFO_TRUE;
          else
            GEQTH_int = `FIFO_FALSE;
        end
      end

    end
    
  endtask // fifo_flags

 task fifo_incr_counter;
          output [8:0] out_reg;
          input [8:0]  in_reg;

          reg [8:0]        in_reg,out_reg;

        begin
           fifo_depth;
           if (in_reg == ((2 * depth) - 1))
               out_reg = 0;
           else
               out_reg = in_reg + 1;
        end
       endtask

 // make rpe output
  task fifo_rpar;
     begin
        par_f = fifo_par9(`FIFO_do_out);    // previously  `FIFO_par_do_out);
        RPE_int = par_f ^ PARODD_int;
     end

   endtask // fifo_rpar

 // Tasks to check/gen parity depending on PARGEN / PARODD
 // make wpe output
  task fifo_wpar;
    begin
      par_f = fifo_par8 ( `FIFO_par_di_in );
      par_f2 = par_f ^ DI8_int;
      WPE_int = par_f2 ^ PARODD_int;
      DI8_int_reg  = DI8_int;
    end
  endtask

  function  fifo_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par8 = ^temp_reg1;

  endfunction


  function  fifo_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_fifo;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `FIFO_TRUE)
        begin
         temp_reg = 9'hx;
         $display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
   data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_fifo;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `FIFO_TRUE)
     x_memory ;
   else if (f_address_out_of_range == `FIFO_TRUE)
     $display("Warning : Invalid writing because write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `FIFO_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `FIFO_TRUE;
       $display("Warning : Bits on the Address Bus are unknown at time %10g", $realtime);
       $display("        : address is %b ", address);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `FIFO_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `FIFO_TRUE;
       $display("Warning : Bit [%d] on the data out bus is unknown at time %10g.", i, $realtime);
       $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `FIFO_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `FIFO_TRUE;
     $display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify


	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
		$setup(posedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge WRB, 0.0, NOTIFY_REG);
		$setup(negedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge WRB, 0.0, NOTIFY_REG);
		$setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
		$setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

           // recovery/hold timing for WCLKS to RESET signals
                $recovery(posedge RESET, posedge WCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge WCLKS, 0.0, NOTIFY_REG);
                $hold(posedge WCLKS, posedge RESET, 0.0, NOTIFY_REG);
                $hold(negedge WCLKS, posedge RESET, 0.0, NOTIFY_REG);

	     // path delay from WCLK to WPE 
		(WCLKS => WPE) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to FULL 
		(WCLKS => FULL) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to EMPTY 
		(WCLKS => EMPTY) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to EQTH 
		(WCLKS => EQTH) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to GETH 
		(WCLKS => GEQTH) =  (0.1:0.1:0.1, 0.1:0.1:0.1);


	     // WCLK width
		$width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge WCLKS, 0.0, 0, NOTIFY_REG);
             // WCLK period 
		$period(posedge WCLKS, 0, NOTIFY_REG);
		(RDB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);

           // path delay from reaf ENABLE signals to DATA OUTPUT
		(RDB => DO0 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO3 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO4 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO5 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO6 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO7 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO8 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO0 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO3 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO4 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO5 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO6 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO7 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO8 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		$width(posedge RBLKB, 0.0, 0, NOTIFY_REG);
		$width(negedge RBLKB, 0.0, 0, NOTIFY_REG);
		$width(posedge RDB, 0.0, 0, NOTIFY_REG);
		$width(negedge RDB, 0.0, 0, NOTIFY_REG);

                $width(posedge RESET, 0.0, 0, NOTIFY_REG);
                $width(negedge RESET, 0.0, 0, NOTIFY_REG);


             // path delay from DIS to DOS 
		(DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);  

             // path delay from signal to all outputs
		(RESET => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);  



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9SAP(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS, WCLKS, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, WCLKS, RBLKB, WBLKB, PARODD;

 output  DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 wire DI_WCLK_check_condition;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg WCLKS_previous;
 reg WRITE_AT_PREV_EDGE;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;


 // Special variables to control flags

 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer hold_full_low;
 integer hold_empty_high;
 integer hold_eqth_low;
 integer hold_geqth_low;
 integer level;
 integer depth_int;
 integer max_level;
 time    WCLKS_re;
 time    WCLKS_fe;
 time    WCLKS_fe_prev;
 time    WB_re;
 time    RESET_re;

/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_pargen_di_in  { DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int }
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 assign DI_WCLK_check_condition = (~WB_int && ~FULL && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (WCLKS_int, WCLKS);
 buf BUF_U25 (RBLKB_int, RBLKB);
 buf BUF_U26 (WBLKB_int, WBLKB);
 buf BUF_U27 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U28 (DOS, DIS_int);
 buf OUTBUF_U29 (FULL, FULL_int);
 buf OUTBUF_U30 (EMPTY, EMPTY_int);
 buf OUTBUF_U31 (EQTH, EQTH_int);
 buf OUTBUF_U32 (GEQTH, GEQTH_int);
 buf OUTBUF_U33 (DO0, DO0_int);
 buf OUTBUF_U34 (DO1, DO1_int);
 buf OUTBUF_U35 (DO2, DO2_int);
 buf OUTBUF_U36 (DO3, DO3_int);
 buf OUTBUF_U37 (DO4, DO4_int);
 buf OUTBUF_U38 (DO5, DO5_int);
 buf OUTBUF_U39 (DO6, DO6_int);
 buf OUTBUF_U40 (DO7, DO7_int);
 buf OUTBUF_U41 (DO8, DO8_int);


 /******************************* initilization ***************************************/

   initial 
     begin
      WCLKS_previous = 1'bx;
      WRITE_AT_PREV_EDGE =1'b0;
      WBLKB_previous = 1'bx;
      WRB_previous = 1'bx;
      RBLKB_previous = 1'bx;
      RDB_previous = 1'bx;
      fifo_r_cnt = 0;
      fifo_w_cnt = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
      hold_full_low   = 0;
      hold_empty_high = 0;
      hold_eqth_low   = 0;
      hold_geqth_low  = 0;
     end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh )
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(WCLKS_int) 
      begin 
          WCLKS_previous = WCLKS_int;
     end

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: UNSYNC, not RCLK, RAEDING BE TRIGGERED BY READ ENABLE SIGNAL

 always @(negedge RB_int )
  begin
   if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
      begin
        read_fifo (`FIFO_do_out, fifo_r_cnt[7:0]);
        fifo_incr_counter(fifo_r_cnt,fifo_r_cnt);
        fifo_rpar;
      end
  end

 // set flags at the rising edge of RB_int, 
 //
 always @(posedge RB_int)
   begin
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
       begin
        fifo_flags;
       end
   end

   // if READ enable signal becomes unknown 'X', the read address will become X too.
   // so FIFO reading operation will corrupt.  user must reset the FIFO
   //
 always @(RB_int == 1'bx )
 begin
  if($time > 0) begin
      if((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (RBLKB_previous != 1'bx) && (RDB_previous != 1'bx))  begin
       $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
      end
     end
   end 


  //
  // RESET operation
  // 
 
  always @ ( negedge RESET_int )
    begin
      fifo_depth;
      fifo_r_cnt         = 0;
      fifo_w_cnt         = 0;
      hold_empty_low     = 0;
      hold_eqth_high     = 0;
      hold_geqth_high    = 0;
      hold_full_low      = 0;
      hold_empty_high    = 0;
      hold_eqth_low      = 0;
      hold_geqth_low     = 0;
      fifo_flags;
      WCLKS_previous     = 1'bx;
      WRITE_AT_PREV_EDGE =1'b0;
      WBLKB_previous     = 1'bx;
      WRB_previous       = 1'bx;
      RBLKB_previous     = 1'bx;
      RDB_previous       = 1'bx;
    end



  // Mimic unusual flag behavior of silicon when WCLKS held high
  // as RESET deasserted.

  always @ ( posedge WCLKS_int )
    begin
      WCLKS_re = $time;
    end


  always @ ( posedge WB_int )
    begin
      WB_re = $time;
    end


  always @ ( posedge RESET_int )
    begin
      RESET_re = $time;
      if ( WCLKS_int == 1'b1 ) begin
        if ( WCLKS_re == WB_re ) begin
          hold_full_low   = 1; // until next reset
          hold_empty_high = 1;
          hold_eqth_low   = 1;
          hold_geqth_low  = 1;
          fifo_flags;
        end else if ( WB_int == 1'b0 ) begin
          hold_empty_low  = 1; // until next WCLKS falling edge
          hold_eqth_high  = 1;
          hold_geqth_high = 1;
          fifo_flags;
        end else if ( WCLKS_re < WB_re ) begin
          hold_empty_low  = 1; // until next WCLKS falling edge
          hold_eqth_high  = 1;
          hold_geqth_high = 1;
          fifo_flags;
        end else if ( WB_re < WCLKS_re ) begin
          hold_empty_low  = 0; // expected behavior
          hold_eqth_high  = 0;
          hold_geqth_high = 0;
          hold_full_low   = 0;
          hold_empty_high = 0;
          hold_eqth_low   = 0;
          hold_geqth_low  = 0;
          fifo_flags;
        end
      end
    end


  always @ ( negedge WCLKS_int )
    begin
      WCLKS_fe_prev = WCLKS_fe;
      WCLKS_fe = $time;
      if ( RESET_int == 1'b1 ) begin
        hold_empty_low  = 0; // return to normal behavior
        hold_eqth_high  = 0;
        hold_geqth_high = 0;
        if ( WCLKS_fe_prev < RESET_re )
          fifo_flags;
      end
    end






  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      WPE_int  = ~ WPE_int;
    end






/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: SYNC with WCLK
 always @(posedge WCLKS_int)
   begin 
        fifo_wpar; // WPE triggered by rising CLK edge in sync write mode 
                   // independent of WB
        WRITE_AT_PREV_EDGE = 1'b0;
        if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
             begin
                 if(WB_int === 1'b0) begin 
                    fifo_pargen;
                    write_fifo ( fifo_w_cnt [ 7 : 0 ], `FIFO_pargen_di_in );
                    fifo_incr_counter(fifo_w_cnt,fifo_w_cnt);
                    WRITE_AT_PREV_EDGE = 1'b1;
                  end else if(WB_int === 1'bx) begin
                   $display("Warning : WBLKB or WRB unknown at time %0.1f, can not write FIFO",$realtime);
                  end
             end
   end

 // any time when WCLK unknown, and Write is enabled, the write address is corruptted
 // because the write address pointer could be increased by one or stay the same 
 //
 always @(WCLKS_int === 1'bx )
  begin
    if($time > 0) begin
      if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WB_int === 1'b0) && (WCLKS_previous != 1'bx)) begin 
         $display("Warning : WCLK unknown at time %0.1f",$realtime);
         $display("        : can not write FIFO, ");
      end
    end
 end

 always @(negedge WCLKS_int)
   begin
             if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WRITE_AT_PREV_EDGE === 1'b1))  // i.e. not reset mode
                  begin
                     fifo_flags;     // only do flags on rising edge of WCLK for async fifo
                     WRITE_AT_PREV_EDGE = 1'b0;
                  end
   end


 /************************** VERILOG  FUNCTION SECTION *************************/

 task fifo_depth;
    begin
           depth = `FIFO_depth + 1;
           depth_size = depth;
           depth = 1 << depth;
    end
 endtask

 function fifo_count_compare;
    input [4:0] local_depth_size;
    integer   i;
    begin
     fifo_count_compare = `FIFO_FALSE;
     begin : CHECK_COUNTER_EQUALITY
                    for (i = 0; i < local_depth_size; i = i+1)
                    begin
                            if (fifo_r_cnt[i] !== fifo_w_cnt[i])
                                  begin
                                    fifo_count_compare = `FIFO_FALSE;
                                    disable CHECK_COUNTER_EQUALITY;
                                  end
                            else
                                  fifo_count_compare = `FIFO_TRUE;
                    end
    end
   end
  endfunction

  task fifo_flags;
 
    reg [8:0] temp_write_cnt;
    
    begin
    
      // compare fifo_w_cnt with fifo_r_cnt
      
      if ( hold_empty_high == 1 )
        EMPTY_int = `FIFO_TRUE;
      else if ( hold_empty_low == 1 )
        EMPTY_int = `FIFO_FALSE;
      else begin

        if ( fifo_count_compare ( depth_size )) begin
          if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
            EMPTY_int = `FIFO_TRUE;
          end else begin
            EMPTY_int = `FIFO_FALSE;
          end
        end else begin
          EMPTY_int = `FIFO_FALSE;
        end
      end

      if ( hold_full_low == 1 )
        FULL_int = `FIFO_FALSE;
      else begin

        if ( fifo_count_compare ( depth_size )) begin
          if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
            FULL_int = `FIFO_FALSE;
          end else begin
            FULL_int  = `FIFO_TRUE;
          end
        end else begin
          FULL_int  = `FIFO_FALSE;
        end
      end

      cnt_diff = fifo_w_cnt - fifo_r_cnt; // w_cnt is always bigger

      if ( cnt_diff [ 8 ] == 1 ) begin
        cnt_diff = cnt_diff + ( 2 * depth );
      end

      // Calculate the maximum level allowable for the selected depth
      
      thresh_reg = `FIFO_thresh;
      level      = thresh_reg;
      depth_int  = depth_size;
      max_level  = 2 ** depth_int;

      // compare cnt_diff with FIFO_thresh
      
      if ( hold_eqth_high == 1 )
        EQTH_int = `FIFO_TRUE;
      else if ( hold_eqth_low == 1 )
        EQTH_int = `FIFO_FALSE;
      else begin
        if ( cnt_diff [ 8 : 0 ] == thresh_reg )
          EQTH_int = `FIFO_TRUE;
        else
          EQTH_int = `FIFO_FALSE;
      end
      if ( hold_geqth_high == 1 )
        GEQTH_int = `FIFO_TRUE;
      else if ( hold_geqth_low == 1 )
        GEQTH_int = `FIFO_FALSE;
      else begin
        if ( level > max_level )
          GEQTH_int = FULL_int; // GEQTH mimics FULL
        else begin
          if ( cnt_diff [ 8 : 0 ] >= thresh_reg )
            GEQTH_int = `FIFO_TRUE;
          else
            GEQTH_int = `FIFO_FALSE;
        end
      end

    end
    
  endtask // fifo_flags

 task fifo_incr_counter;
          output [8:0] out_reg;
          input [8:0]  in_reg;

          reg [8:0]        in_reg,out_reg;

        begin
           fifo_depth;
           if (in_reg == ((2 * depth) - 1))
               out_reg = 0;
           else
               out_reg = in_reg + 1;
        end
       endtask

 // make rpe output
  task fifo_rpar;
     begin
        par_f = fifo_par9(`FIFO_do_out);    // previously  `FIFO_par_do_out);
        RPE_int = par_f ^ PARODD_int;
     end

   endtask // fifo_rpar

 // Tasks to check/gen parity depending on PARGEN / PARODD
 // make wpe output
  task fifo_wpar;
     begin
        par_f = fifo_par8(`FIFO_par_di_in);
        WPE_int = par_f ^ PARODD_int;
        DI8_int_reg  = WPE_int;
     end
   endtask

  // Generate parity bit from DI(7:0) and replace DI8 with it.
  
  task fifo_pargen;
    begin
      if ( PARODD_int == 1'b0 ) 
        DI8_int_reg = fifo_par8 ( `FIFO_par_di_in );
      else
        DI8_int_reg = ~ fifo_par8 ( `FIFO_par_di_in );
    end
  endtask


  function  fifo_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par8 = ^temp_reg1;

  endfunction


  function  fifo_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_fifo;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `FIFO_TRUE)
        begin
         temp_reg = 9'hx;
         $display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
   data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_fifo;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `FIFO_TRUE)
     x_memory ;
   else if (f_address_out_of_range == `FIFO_TRUE)
     $display("Warning : Invalid writing because write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `FIFO_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `FIFO_TRUE;
       $display("Warning : Bits on the Address Bus are unknown at time %10g", $realtime);
       $display("        : address is %b ", address);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `FIFO_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `FIFO_TRUE;
       $display("Warning : Bit [%d] on the data out bus is unknown at time %10g.", i, $realtime);
       $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `FIFO_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `FIFO_TRUE;
     $display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify


	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
		$setup(posedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge WRB, 0.0, NOTIFY_REG);
		$setup(negedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge WRB, 0.0, NOTIFY_REG);
		$setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
		$setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

           // recovery/hold timing for WCLKS to RESET signals
                $recovery(posedge RESET, posedge WCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge WCLKS, 0.0, NOTIFY_REG);
                $hold(posedge WCLKS, posedge RESET, 0.0, NOTIFY_REG);
                $hold(negedge WCLKS, posedge RESET, 0.0, NOTIFY_REG);
	    
             // path delay from WCLK to FULL 
		(WCLKS => FULL) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to EMPTY 
		(WCLKS => EMPTY) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to EQTH 
		(WCLKS => EQTH) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to GETH 
		(WCLKS => GEQTH) =  (0.1:0.1:0.1, 0.1:0.1:0.1);


	     // WCLK width
		$width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge WCLKS, 0.0, 0, NOTIFY_REG);
             // WCLK period 
		$period(posedge WCLKS, 0, NOTIFY_REG);
		(RDB => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);

           // path delay from reaf ENABLE signals to DATA OUTPUT
		(RDB => DO0 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO3 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO4 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO5 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO6 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO7 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RDB => DO8 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO0 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO1 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO2 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO3 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO4 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO5 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO6 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO7 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RBLKB => DO8 ) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		$width(posedge RBLKB, 0.0, 0, NOTIFY_REG);
		$width(negedge RBLKB, 0.0, 0, NOTIFY_REG);
		$width(posedge RDB, 0.0, 0, NOTIFY_REG);
		$width(negedge RDB, 0.0, 0, NOTIFY_REG);
                $width(posedge RESET, 0.0, 0, NOTIFY_REG);
                $width(negedge RESET, 0.0, 0, NOTIFY_REG);


             // path delay from DIS to DOS 
		(DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);  

             // path delay from signal to all outputs
		(RESET => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);  



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9SST(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS, WCLKS, RCLKS,  WPE, RPE, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, WCLKS, RCLKS, RBLKB, WBLKB, PARODD;

 output  WPE, RPE, DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 wire DI_WCLK_check_condition;
 wire RBLK_RCLK_setup_check_condition;
 wire RENABLE_RCLK_setup_check_condition;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg WCLKS_previous;
 reg WRITE_AT_PREV_EDGE;
 reg RCLKS_previous;
 reg READ_AT_PREV_EDGE;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;


 // Special variables to control flags

 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer hold_full_low;
 integer hold_empty_high;
 integer hold_eqth_low;
 integer hold_geqth_low;
 integer level;
 integer depth_int;
 integer max_level;
 time    WCLKS_re;
 time    WCLKS_fe;
 time    WCLKS_fe_prev;
 time    WB_re;
 time    RESET_re;

/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 assign DI_WCLK_check_condition = (~WB_int && ~FULL && RESET_int);
 assign RBLK_RCLK_setup_check_condition = (RDB_int && ~EMPTY && RESET_int);
 assign RENABLE_RCLK_setup_check_condition = (RBLKB_int && ~EMPTY && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (WCLKS_int, WCLKS);
 buf BUF_U25 (RCLKS_int, RCLKS);
 buf BUF_U26 (RBLKB_int, RBLKB);
 buf BUF_U27 (WBLKB_int, WBLKB);
 buf BUF_U28 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U29 (DOS, DIS_int);
 buf OUTBUF_U30 (FULL, FULL_int);
 buf OUTBUF_U31 (EMPTY, EMPTY_int);
 buf OUTBUF_U32 (EQTH, EQTH_int);
 buf OUTBUF_U33 (GEQTH, GEQTH_int);
 buf OUTBUF_U34 (DO0, DO0_int);
 buf OUTBUF_U35 (DO1, DO1_int);
 buf OUTBUF_U36 (DO2, DO2_int);
 buf OUTBUF_U37 (DO3, DO3_int);
 buf OUTBUF_U38 (DO4, DO4_int);
 buf OUTBUF_U39 (DO5, DO5_int);
 buf OUTBUF_U40 (DO6, DO6_int);
 buf OUTBUF_U41 (DO7, DO7_int);
 buf OUTBUF_U42 (DO8, DO8_int);
 buf OUTBUF_U43 (WPE, WPE_int);
 buf OUTBUF_U44 (RPE, RPE_int);


 /******************************* initilization ***************************************/

   initial 
     begin
      RCLKS_previous = 1'bx;
      READ_AT_PREV_EDGE =1'b0;
      WCLKS_previous = 1'bx;
      WRITE_AT_PREV_EDGE =1'b0;
      WBLKB_previous = 1'bx;
      WRB_previous = 1'bx;
      RBLKB_previous = 1'bx;
      RDB_previous = 1'bx;
      fifo_r_cnt = 0;
      fifo_w_cnt = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
      hold_full_low   = 0;
      hold_empty_high = 0;
      hold_eqth_low   = 0;
      hold_geqth_low  = 0;
     end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh )
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(WCLKS_int) 
      begin 
          WCLKS_previous = WCLKS_int;
     end

   always @(RCLKS_int) 
      begin 
          RCLKS_previous = RCLKS_int;
     end

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: SYNC with RCLK ;


 always @(posedge RCLKS_int)
   begin
     READ_AT_PREV_EDGE = 1'b0;
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
        begin
         if(RB_int === 1'b0) begin
              read_fifo (`FIFO_do_out, fifo_r_cnt[7:0]);
          READ_AT_PREV_EDGE =1'b1;
          // increase the read address counter
          fifo_incr_counter(fifo_r_cnt,fifo_r_cnt);
          // check the parity 
          fifo_rpar;
         end else if(RB_int === 1'bx) begin 
          $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
         end
        end
   end 

 // check  the situation of RCLK unknown 'X' 
 // if RCLK unknown, READing is ENABLED, and EMPTY is false, READ address will corrput
 //  user should reset the FIFO before continuing reading
 //
 always @(RCLKS_int === 1'bx )
 begin
  if($time > 0) begin
    if ((RB_int == 1'b0) && (EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (RCLKS_previous != 1'bx)) begin
      $display("Warning : RCLK unknown at time %0.1f, can not read FIFO. ",$realtime);
    end
  end
 end

 // set the flags at the falling edge of the rclk
 //
 always @(negedge RCLKS_int)
   begin
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (READ_AT_PREV_EDGE == 1'b1))  // i.e. not reset mode
       begin
        fifo_flags;
        READ_AT_PREV_EDGE =1'b0;
       end
   end


  //
  // RESET operation
  // 
 
  always @ ( negedge RESET_int )
  begin
   fifo_depth;
   fifo_r_cnt = 0;
   fifo_w_cnt = 0;
   hold_empty_low     = 0;
   hold_eqth_high     = 0;
   hold_geqth_high    = 0;
   hold_full_low      = 0;
   hold_empty_high    = 0;
   hold_eqth_low      = 0;
   hold_geqth_low     = 0;
   fifo_flags;
   RCLKS_previous = 1'bx;
   READ_AT_PREV_EDGE =1'b0;
   WCLKS_previous = 1'bx;
   WRITE_AT_PREV_EDGE =1'b0;
   WBLKB_previous = 1'bx;
   WRB_previous = 1'bx;
   RBLKB_previous = 1'bx;
   RDB_previous = 1'bx;
  end



  // Mimic unusual flag behavior of silicon when WCLKS held high
  // as RESET deasserted.

  always @ ( posedge WCLKS_int )
    begin
      WCLKS_re = $time;
    end


  always @ ( posedge WB_int )
    begin
      WB_re = $time;
    end


  always @ ( posedge RESET_int )
    begin
      RESET_re = $time;
      if ( WCLKS_int == 1'b1 ) begin
        if ( WCLKS_re == WB_re ) begin
          hold_full_low   = 1; // until next reset
          hold_empty_high = 1;
          hold_eqth_low   = 1;
          hold_geqth_low  = 1;
          fifo_flags;
        end else if ( WB_int == 1'b0 ) begin
          hold_empty_low  = 1; // until next WCLKS falling edge
          hold_eqth_high  = 1;
          hold_geqth_high = 1;
          fifo_flags;
        end else if ( WCLKS_re < WB_re ) begin
          hold_empty_low  = 1; // until next WCLKS falling edge
          hold_eqth_high  = 1;
          hold_geqth_high = 1;
          fifo_flags;
        end else if ( WB_re < WCLKS_re ) begin
          hold_empty_low  = 0; // expected behavior
          hold_eqth_high  = 0;
          hold_geqth_high = 0;
          hold_full_low   = 0;
          hold_empty_high = 0;
          hold_eqth_low   = 0;
          hold_geqth_low  = 0;
          fifo_flags;
        end
      end
    end


  always @ ( negedge WCLKS_int )
    begin
      WCLKS_fe_prev = WCLKS_fe;
      WCLKS_fe = $time;
      if ( RESET_int == 1'b1 ) begin
        hold_empty_low  = 0; // return to normal behavior
        hold_eqth_high  = 0;
        hold_geqth_high = 0;
        if ( WCLKS_fe_prev < RESET_re )
          fifo_flags;
      end
    end



  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      WPE_int  = ~ WPE_int;
    end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: SYNC with WCLK
 always @(posedge WCLKS_int)
   begin 
        fifo_wpar;  // WPE triggered by rising CLK edge in sync write mode 
                    // independent of WB
        WRITE_AT_PREV_EDGE = 1'b0;
        if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
             begin
                 if(WB_int === 1'b0) begin 
                    write_fifo (fifo_w_cnt[7:0], `FIFO_di_in );
                    fifo_incr_counter(fifo_w_cnt,fifo_w_cnt);
                    WRITE_AT_PREV_EDGE = 1'b1;
                  end else if(WB_int === 1'bx) begin
                   $display("Warning : WBLKB or WRB unknown at time %0.1f, can not write FIFO",$realtime);
                  end
             end
   end

 // any time when WCLK unknown, and Write is enabled, the write address is corruptted
 // because the write address pointer could be increased by one or stay the same 
 //
 always @(WCLKS_int === 1'bx )
  begin
    if($time > 0) begin
      if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WB_int === 1'b0) && (WCLKS_previous != 1'bx)) begin 
         $display("Warning : WCLK unknown at time %0.1f",$realtime);
         $display("        : can not write FIFO, ");
      end
    end
 end

 always @(negedge WCLKS_int)
   begin
             if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WRITE_AT_PREV_EDGE === 1'b1))  // i.e. not reset mode
                  begin
                     fifo_flags;     // only do flags on rising edge of WCLK for async fifo
                     WRITE_AT_PREV_EDGE = 1'b0;
                  end
   end


 /************************** VERILOG  FUNCTION SECTION *************************/

 task fifo_depth;
    begin
           depth = `FIFO_depth + 1;
           depth_size = depth;
           depth = 1 << depth;
    end
 endtask

 function fifo_count_compare;
    input [4:0] local_depth_size;
    integer   i;
    begin
     fifo_count_compare = `FIFO_FALSE;
     begin : CHECK_COUNTER_EQUALITY
                    for (i = 0; i < local_depth_size; i = i+1)
                    begin
                            if (fifo_r_cnt[i] !== fifo_w_cnt[i])
                                  begin
                                    fifo_count_compare = `FIFO_FALSE;
                                    disable CHECK_COUNTER_EQUALITY;
                                  end
                            else
                                  fifo_count_compare = `FIFO_TRUE;
                    end
    end
   end
  endfunction

  task fifo_flags;
 
    reg [8:0] temp_write_cnt;
    
    begin
    
      // compare fifo_w_cnt with fifo_r_cnt
      
      if ( hold_empty_high == 1 )
        EMPTY_int = `FIFO_TRUE;
      else if ( hold_empty_low == 1 )
        EMPTY_int = `FIFO_FALSE;
      else begin

        if ( fifo_count_compare ( depth_size )) begin
          if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
            EMPTY_int = `FIFO_TRUE;
          end else begin
            EMPTY_int = `FIFO_FALSE;
          end
        end else begin
          EMPTY_int = `FIFO_FALSE;
        end
      end

      if ( hold_full_low == 1 )
        FULL_int = `FIFO_FALSE;
      else begin

        if ( fifo_count_compare ( depth_size )) begin
          if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
            FULL_int = `FIFO_FALSE;
          end else begin
            FULL_int  = `FIFO_TRUE;
          end
        end else begin
          FULL_int  = `FIFO_FALSE;
        end
      end

      cnt_diff = fifo_w_cnt - fifo_r_cnt; // w_cnt is always bigger

      if ( cnt_diff [ 8 ] == 1 ) begin
        cnt_diff = cnt_diff + ( 2 * depth );
      end

      // Calculate the maximum level allowable for the selected depth
      
      thresh_reg = `FIFO_thresh;
      level      = thresh_reg;
      depth_int  = depth_size;
      max_level  = 2 ** depth_int;

      // compare cnt_diff with FIFO_thresh
      
      if ( hold_eqth_high == 1 )
        EQTH_int = `FIFO_TRUE;
      else if ( hold_eqth_low == 1 )
        EQTH_int = `FIFO_FALSE;
      else begin
        if ( cnt_diff [ 8 : 0 ] == thresh_reg )
          EQTH_int = `FIFO_TRUE;
        else
          EQTH_int = `FIFO_FALSE;
      end
      if ( hold_geqth_high == 1 )
        GEQTH_int = `FIFO_TRUE;
      else if ( hold_geqth_low == 1 )
        GEQTH_int = `FIFO_FALSE;
      else begin
        if ( level > max_level )
          GEQTH_int = FULL_int; // GEQTH mimics FULL
        else begin
          if ( cnt_diff [ 8 : 0 ] >= thresh_reg )
            GEQTH_int = `FIFO_TRUE;
          else
            GEQTH_int = `FIFO_FALSE;
        end
      end

    end
    
  endtask // fifo_flags

 task fifo_incr_counter;
          output [8:0] out_reg;
          input [8:0]  in_reg;

          reg [8:0]        in_reg,out_reg;

        begin
           fifo_depth;
           if (in_reg == ((2 * depth) - 1))
               out_reg = 0;
           else
               out_reg = in_reg + 1;
        end
       endtask

 // make rpe output
  task fifo_rpar;
     begin
        par_f = fifo_par9(`FIFO_do_out);    // previously  `FIFO_par_do_out);
        RPE_int = par_f ^ PARODD_int;
     end

   endtask // fifo_rpar

 // Tasks to check/gen parity depending on PARGEN / PARODD
 // make wpe output
  task fifo_wpar;
    begin
      par_f = fifo_par8 ( `FIFO_par_di_in );
      par_f2 = par_f ^ DI8_int;
      WPE_int = par_f2 ^ PARODD_int;
      DI8_int_reg  = DI8_int;
    end
  endtask


  // Generate parity bit from DI(7:0) and replace DI8 with it.
  
  task fifo_pargen;
    begin
      if ( PARODD_int == 1'b0 ) 
        DI8_int_reg = fifo_par8 ( `FIFO_par_di_in );
      else
        DI8_int_reg = ~ fifo_par8 ( `FIFO_par_di_in );
    end
  endtask


  function  fifo_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par8 = ^temp_reg1;

  endfunction


  function  fifo_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_fifo;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `FIFO_TRUE)
        begin
         temp_reg = 9'hx;
         $display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
   data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_fifo;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `FIFO_TRUE)
     x_memory ;
   else if (f_address_out_of_range == `FIFO_TRUE)
     $display("Warning : Invalid writing because write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `FIFO_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `FIFO_TRUE;
       $display("Warning : Bits on the Address Bus are unknown at time %10g", $realtime);
       $display("        : address is %b ", address);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `FIFO_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `FIFO_TRUE;
       $display("Warning : Bit [%d] on the data out bus is unknown at time %10g.", i, $realtime);
       $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `FIFO_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `FIFO_TRUE;
     $display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify


	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
		$setup(posedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge WRB, 0.0, NOTIFY_REG);
		$setup(negedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge WRB, 0.0, NOTIFY_REG);
		$setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
		$setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

           // recovery/hold timing for WCLKS to RESET signals
                $recovery(posedge RESET, posedge WCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge WCLKS, 0.0, NOTIFY_REG);
                $hold(posedge WCLKS, posedge RESET, 0.0, NOTIFY_REG);
                $hold(negedge WCLKS, posedge RESET, 0.0, NOTIFY_REG);
	    
	     // path delay from WCLK to WPE 
		(WCLKS => WPE) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to FULL 
		(WCLKS => FULL) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to EMPTY 
		(WCLKS => EMPTY) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to EQTH 
		(WCLKS => EQTH) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to GETH 
		(WCLKS => GEQTH) =  (0.1:0.1:0.1, 0.1:0.1:0.1);


	     // WCLK width
		$width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge WCLKS, 0.0, 0, NOTIFY_REG);
             // WCLK period 
		$period(posedge WCLKS, 0, NOTIFY_REG);
	   // setup and hold time for RBD and RBLKB to RCLK
	     $setup(negedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
	     $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), negedge RDB, 0.0, NOTIFY_REG);
             $setup(negedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
             $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), negedge RBLKB, 0.0, NOTIFY_REG);
             $setup(posedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
             $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), posedge RDB, 0.0, NOTIFY_REG);
             $setup(posedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
             $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), posedge RBLKB, 0.0, NOTIFY_REG);

	  // path delay parameters
		(RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // minimum RCLK  width 
		$width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge RCLKS, 0.0, 0, NOTIFY_REG);
                $width(posedge RESET, 0.0, 0, NOTIFY_REG);
                $width(negedge RESET, 0.0, 0, NOTIFY_REG);


           // recovery/hold timing for RCLKS to RESET signals
                $recovery(posedge RESET, posedge RCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge RCLKS, 0.0, NOTIFY_REG);
                $hold(posedge RCLKS, posedge RESET,  0.0, NOTIFY_REG);
                $hold(negedge RCLKS, posedge RESET, 0.0, NOTIFY_REG);	    

             // path delay from DIS to DOS 
		(DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);  

             // path delay from signal to all outputs
		(RESET => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);  



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9SSTP(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS, WCLKS, RCLKS, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, WCLKS, RCLKS, RBLKB, WBLKB, PARODD;

 output  DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 wire DI_WCLK_check_condition;
 wire RBLK_RCLK_setup_check_condition;
 wire RENABLE_RCLK_setup_check_condition;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg WCLKS_previous;
 reg WRITE_AT_PREV_EDGE;
 reg RCLKS_previous;
 reg READ_AT_PREV_EDGE;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;


 // Special variables to control flags

 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer hold_full_low;
 integer hold_empty_high;
 integer hold_eqth_low;
 integer hold_geqth_low;
 integer level;
 integer depth_int;
 integer max_level;
 time    WCLKS_re;
 time    WCLKS_fe;
 time    WCLKS_fe_prev;
 time    WB_re;
 time    RESET_re;

/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_pargen_di_in  { DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int }
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 assign DI_WCLK_check_condition = (~WB_int && ~FULL && RESET_int);
 assign RBLK_RCLK_setup_check_condition = (RDB_int && ~EMPTY && RESET_int);
 assign RENABLE_RCLK_setup_check_condition = (RBLKB_int && ~EMPTY && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (WCLKS_int, WCLKS);
 buf BUF_U25 (RCLKS_int, RCLKS);
 buf BUF_U26 (RBLKB_int, RBLKB);
 buf BUF_U27 (WBLKB_int, WBLKB);
 buf BUF_U28 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U29 (DOS, DIS_int);
 buf OUTBUF_U30 (FULL, FULL_int);
 buf OUTBUF_U31 (EMPTY, EMPTY_int);
 buf OUTBUF_U32 (EQTH, EQTH_int);
 buf OUTBUF_U33 (GEQTH, GEQTH_int);
 buf OUTBUF_U34 (DO0, DO0_int);
 buf OUTBUF_U35 (DO1, DO1_int);
 buf OUTBUF_U36 (DO2, DO2_int);
 buf OUTBUF_U37 (DO3, DO3_int);
 buf OUTBUF_U38 (DO4, DO4_int);
 buf OUTBUF_U39 (DO5, DO5_int);
 buf OUTBUF_U40 (DO6, DO6_int);
 buf OUTBUF_U41 (DO7, DO7_int);
 buf OUTBUF_U42 (DO8, DO8_int);


 /******************************* initilization ***************************************/

   initial 
     begin
      RCLKS_previous = 1'bx;
      READ_AT_PREV_EDGE =1'b0;
      WCLKS_previous = 1'bx;
      WRITE_AT_PREV_EDGE =1'b0;
      WBLKB_previous = 1'bx;
      WRB_previous = 1'bx;
      RBLKB_previous = 1'bx;
      RDB_previous = 1'bx;
      fifo_r_cnt = 0;
      fifo_w_cnt = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
      hold_full_low   = 0;
      hold_empty_high = 0;
      hold_eqth_low   = 0;
      hold_geqth_low  = 0;
     end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh )
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(WCLKS_int) 
      begin 
          WCLKS_previous = WCLKS_int;
     end

   always @(RCLKS_int) 
      begin 
          RCLKS_previous = RCLKS_int;
     end

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: SYNC with RCLK ;


 always @(posedge RCLKS_int)
   begin
     READ_AT_PREV_EDGE = 1'b0;
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
        begin
         if(RB_int === 1'b0) begin
              read_fifo (`FIFO_do_out, fifo_r_cnt[7:0]);
          READ_AT_PREV_EDGE =1'b1;
          // increase the read address counter
          fifo_incr_counter(fifo_r_cnt,fifo_r_cnt);
          // check the parity 
          fifo_rpar;
         end else if(RB_int === 1'bx) begin 
          $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
         end
        end
   end 

 // check  the situation of RCLK unknown 'X' 
 // if RCLK unknown, READing is ENABLED, and EMPTY is false, READ address will corrput
 //  user should reset the FIFO before continuing reading
 //
 always @(RCLKS_int === 1'bx )
 begin
  if($time > 0) begin
    if ((RB_int == 1'b0) && (EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (RCLKS_previous != 1'bx)) begin
      $display("Warning : RCLK unknown at time %0.1f, can not read FIFO. ",$realtime);
    end
  end
 end

 // set the flags at the falling edge of the rclk
 //
 always @(negedge RCLKS_int)
   begin
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (READ_AT_PREV_EDGE == 1'b1))  // i.e. not reset mode
       begin
        fifo_flags;
        READ_AT_PREV_EDGE =1'b0;
       end
   end


  //
  // RESET operation
  // 
 
  always @ ( negedge RESET_int )
  begin
   fifo_depth;
   fifo_r_cnt = 0;
   fifo_w_cnt = 0;
   hold_empty_low     = 0;
   hold_eqth_high     = 0;
   hold_geqth_high    = 0;
   hold_full_low      = 0;
   hold_empty_high    = 0;
   hold_eqth_low      = 0;
   hold_geqth_low     = 0;
   fifo_flags;
   RCLKS_previous = 1'bx;
   READ_AT_PREV_EDGE =1'b0;
   WCLKS_previous = 1'bx;
   WRITE_AT_PREV_EDGE =1'b0;
   WBLKB_previous = 1'bx;
   WRB_previous = 1'bx;
   RBLKB_previous = 1'bx;
   RDB_previous = 1'bx;
  end



  // Mimic unusual flag behavior of silicon when WCLKS held high
  // as RESET deasserted.

  always @ ( posedge WCLKS_int )
    begin
      WCLKS_re = $time;
    end


  always @ ( posedge WB_int )
    begin
      WB_re = $time;
    end


  always @ ( posedge RESET_int )
    begin
      RESET_re = $time;
      if ( WCLKS_int == 1'b1 ) begin
        if ( WCLKS_re == WB_re ) begin
          hold_full_low   = 1; // until next reset
          hold_empty_high = 1;
          hold_eqth_low   = 1;
          hold_geqth_low  = 1;
          fifo_flags;
        end else if ( WB_int == 1'b0 ) begin
          hold_empty_low  = 1; // until next WCLKS falling edge
          hold_eqth_high  = 1;
          hold_geqth_high = 1;
          fifo_flags;
        end else if ( WCLKS_re < WB_re ) begin
          hold_empty_low  = 1; // until next WCLKS falling edge
          hold_eqth_high  = 1;
          hold_geqth_high = 1;
          fifo_flags;
        end else if ( WB_re < WCLKS_re ) begin
          hold_empty_low  = 0; // expected behavior
          hold_eqth_high  = 0;
          hold_geqth_high = 0;
          hold_full_low   = 0;
          hold_empty_high = 0;
          hold_eqth_low   = 0;
          hold_geqth_low  = 0;
          fifo_flags;
        end
      end
    end


  always @ ( negedge WCLKS_int )
    begin
      WCLKS_fe_prev = WCLKS_fe;
      WCLKS_fe = $time;
      if ( RESET_int == 1'b1 ) begin
        hold_empty_low  = 0; // return to normal behavior
        hold_eqth_high  = 0;
        hold_geqth_high = 0;
        if ( WCLKS_fe_prev < RESET_re )
          fifo_flags;
      end
    end






  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      WPE_int  = ~ WPE_int;
    end






/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: SYNC with WCLK
 always @(posedge WCLKS_int)
   begin 
        fifo_wpar;  // WPE triggered by rising CLK edge in sync write mode 
                    // independent of WB
        WRITE_AT_PREV_EDGE = 1'b0;
        if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
             begin
                 if(WB_int === 1'b0) begin 
                    fifo_pargen;
                    write_fifo ( fifo_w_cnt [ 7 : 0 ], `FIFO_pargen_di_in );
                    fifo_incr_counter(fifo_w_cnt,fifo_w_cnt);
                    WRITE_AT_PREV_EDGE = 1'b1;
                  end else if(WB_int === 1'bx) begin
                   $display("Warning : WBLKB or WRB unknown at time %0.1f, can not write FIFO",$realtime);
                  end
             end
   end

 // any time when WCLK unknown, and Write is enabled, the write address is corruptted
 // because the write address pointer could be increased by one or stay the same 
 //
 always @(WCLKS_int === 1'bx )
  begin
    if($time > 0) begin
      if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WB_int === 1'b0) && (WCLKS_previous != 1'bx)) begin 
         $display("Warning : WCLK unknown at time %0.1f",$realtime);
         $display("        : can not write FIFO, ");
      end
    end
 end

 always @(negedge WCLKS_int)
   begin
             if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WRITE_AT_PREV_EDGE === 1'b1))  // i.e. not reset mode
                  begin
                     fifo_flags;     // only do flags on rising edge of WCLK for async fifo
                     WRITE_AT_PREV_EDGE = 1'b0;
                  end
   end


 /************************** VERILOG  FUNCTION SECTION *************************/

 task fifo_depth;
    begin
           depth = `FIFO_depth + 1;
           depth_size = depth;
           depth = 1 << depth;
    end
 endtask

 function fifo_count_compare;
    input [4:0] local_depth_size;
    integer   i;
    begin
     fifo_count_compare = `FIFO_FALSE;
     begin : CHECK_COUNTER_EQUALITY
                    for (i = 0; i < local_depth_size; i = i+1)
                    begin
                            if (fifo_r_cnt[i] !== fifo_w_cnt[i])
                                  begin
                                    fifo_count_compare = `FIFO_FALSE;
                                    disable CHECK_COUNTER_EQUALITY;
                                  end
                            else
                                  fifo_count_compare = `FIFO_TRUE;
                    end
    end
   end
  endfunction

  task fifo_flags;
 
    reg [8:0] temp_write_cnt;
    
    begin
    
      // compare fifo_w_cnt with fifo_r_cnt
      
      if ( hold_empty_high == 1 )
        EMPTY_int = `FIFO_TRUE;
      else if ( hold_empty_low == 1 )
        EMPTY_int = `FIFO_FALSE;
      else begin

        if ( fifo_count_compare ( depth_size )) begin
          if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
            EMPTY_int = `FIFO_TRUE;
          end else begin
            EMPTY_int = `FIFO_FALSE;
          end
        end else begin
          EMPTY_int = `FIFO_FALSE;
        end
      end

      if ( hold_full_low == 1 )
        FULL_int = `FIFO_FALSE;
      else begin

        if ( fifo_count_compare ( depth_size )) begin
          if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
            FULL_int = `FIFO_FALSE;
          end else begin
            FULL_int  = `FIFO_TRUE;
          end
        end else begin
          FULL_int  = `FIFO_FALSE;
        end
      end

      cnt_diff = fifo_w_cnt - fifo_r_cnt; // w_cnt is always bigger

      if ( cnt_diff [ 8 ] == 1 ) begin
        cnt_diff = cnt_diff + ( 2 * depth );
      end

      // Calculate the maximum level allowable for the selected depth
      
      thresh_reg = `FIFO_thresh;
      level      = thresh_reg;
      depth_int  = depth_size;
      max_level  = 2 ** depth_int;

      // compare cnt_diff with FIFO_thresh
      
      if ( hold_eqth_high == 1 )
        EQTH_int = `FIFO_TRUE;
      else if ( hold_eqth_low == 1 )
        EQTH_int = `FIFO_FALSE;
      else begin
        if ( cnt_diff [ 8 : 0 ] == thresh_reg )
          EQTH_int = `FIFO_TRUE;
        else
          EQTH_int = `FIFO_FALSE;
      end
      if ( hold_geqth_high == 1 )
        GEQTH_int = `FIFO_TRUE;
      else if ( hold_geqth_low == 1 )
        GEQTH_int = `FIFO_FALSE;
      else begin
        if ( level > max_level )
          GEQTH_int = FULL_int; // GEQTH mimics FULL
        else begin
          if ( cnt_diff [ 8 : 0 ] >= thresh_reg )
            GEQTH_int = `FIFO_TRUE;
          else
            GEQTH_int = `FIFO_FALSE;
        end
      end

    end
    
  endtask // fifo_flags

 task fifo_incr_counter;
          output [8:0] out_reg;
          input [8:0]  in_reg;

          reg [8:0]        in_reg,out_reg;

        begin
           fifo_depth;
           if (in_reg == ((2 * depth) - 1))
               out_reg = 0;
           else
               out_reg = in_reg + 1;
        end
       endtask

 // make rpe output
  task fifo_rpar;
     begin
        par_f = fifo_par9(`FIFO_do_out);    // previously  `FIFO_par_do_out);
        RPE_int = par_f ^ PARODD_int;
     end

   endtask // fifo_rpar

 // Tasks to check/gen parity depending on PARGEN / PARODD
 // make wpe output
  task fifo_wpar;
     begin
      par_f = fifo_par8(`FIFO_par_di_in);
      WPE_int = par_f ^ PARODD_int;
      DI8_int_reg  = WPE_int;
     end
   endtask


  // Generate parity bit from DI(7:0) and replace DI8 with it.
  
  task fifo_pargen;
    begin
      if ( PARODD_int == 1'b0 ) 
        DI8_int_reg = fifo_par8 ( `FIFO_par_di_in );
      else
        DI8_int_reg = ~ fifo_par8 ( `FIFO_par_di_in );
    end
  endtask


  function  fifo_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par8 = ^temp_reg1;

  endfunction


  function  fifo_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_fifo;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `FIFO_TRUE)
        begin
         temp_reg = 9'hx;
         $display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
   data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_fifo;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `FIFO_TRUE)
     x_memory ;
   else if (f_address_out_of_range == `FIFO_TRUE)
     $display("Warning : Invalid writing because write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `FIFO_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `FIFO_TRUE;
       $display("Warning : Bits on the Address Bus are unknown at time %10g", $realtime);
       $display("        : address is %b ", address);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `FIFO_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `FIFO_TRUE;
       $display("Warning : Bit [%d] on the data out bus is unknown at time %10g.", i, $realtime);
       $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `FIFO_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `FIFO_TRUE;
     $display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify


	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
		$setup(posedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge WRB, 0.0, NOTIFY_REG);
		$setup(negedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge WRB, 0.0, NOTIFY_REG);
		$setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
		$setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

           // recovery/hold timing for WCLKS to RESET signals
                $recovery(posedge RESET, posedge WCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge WCLKS, 0.0, NOTIFY_REG);
                $hold(posedge WCLKS, posedge RESET, 0.0, NOTIFY_REG);
                $hold(negedge WCLKS, posedge RESET, 0.0, NOTIFY_REG);

             // path delay from WCLK to FULL 
		(WCLKS => FULL) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to EMPTY 
		(WCLKS => EMPTY) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to EQTH 
		(WCLKS => EQTH) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to GETH 
		(WCLKS => GEQTH) =  (0.1:0.1:0.1, 0.1:0.1:0.1);


	     // WCLK width
		$width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge WCLKS, 0.0, 0, NOTIFY_REG);
             // WCLK period 
		$period(posedge WCLKS, 0, NOTIFY_REG);
	   // setup and hold time for RBD and RBLKB to RCLK
	        $setup(negedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
	        $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), negedge RDB, 0.0, NOTIFY_REG);
                $setup(negedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), negedge RBLKB, 0.0, NOTIFY_REG);
                $setup(posedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), posedge RDB, 0.0, NOTIFY_REG);
                $setup(posedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), posedge RBLKB, 0.0, NOTIFY_REG);

	  // path delay parameters
		(RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // minimum RCLK  width 
		$width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge RCLKS, 0.0, 0, NOTIFY_REG);
                $width(posedge RESET, 0.0, 0, NOTIFY_REG);
                $width(negedge RESET, 0.0, 0, NOTIFY_REG);

           // recovery/hold timing for RCLKS to RESET signals
                $recovery(posedge RESET, posedge RCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge RCLKS, 0.0, NOTIFY_REG);
                $hold(posedge RCLKS, posedge RESET,  0.0, NOTIFY_REG);
                $hold(negedge RCLKS, posedge RESET, 0.0, NOTIFY_REG);
	    
             // path delay from DIS to DOS 
		(DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);  

             // path delay from signal to all outputs
		(RESET => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);  



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9SSR(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS, WCLKS, RCLKS,  WPE, RPE, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, WCLKS, RCLKS, RBLKB, WBLKB, PARODD;

 output  WPE, RPE, DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 wire DI_WCLK_check_condition;
 wire RBLK_RCLK_setup_check_condition;
 wire RENABLE_RCLK_setup_check_condition;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] FIFO_do_out_stg1;
 reg       RPE_stg1;
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg WCLKS_previous;
 reg WRITE_AT_PREV_EDGE;
 reg RCLKS_previous;
 reg READ_AT_PREV_EDGE;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;

 // Special variables to control flags

 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer hold_full_low;
 integer hold_empty_high;
 integer hold_eqth_low;
 integer hold_geqth_low;
 integer level;
 integer depth_int;
 integer max_level;
 time    WCLKS_re;
 time    WCLKS_fe;
 time    WCLKS_fe_prev;
 time    WB_re;
 time    RESET_re;


/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 assign DI_WCLK_check_condition = (~WB_int && ~FULL && RESET_int);
 assign RBLK_RCLK_setup_check_condition = (RDB_int && ~EMPTY && RESET_int);
 assign RENABLE_RCLK_setup_check_condition = (RBLKB_int && ~EMPTY && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (WCLKS_int, WCLKS);
 buf BUF_U25 (RCLKS_int, RCLKS);
 buf BUF_U26 (RBLKB_int, RBLKB);
 buf BUF_U27 (WBLKB_int, WBLKB);
 buf BUF_U28 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U29 (DOS, DIS_int);
 buf OUTBUF_U30 (FULL, FULL_int);
 buf OUTBUF_U31 (EMPTY, EMPTY_int);
 buf OUTBUF_U32 (EQTH, EQTH_int);
 buf OUTBUF_U33 (GEQTH, GEQTH_int);
 buf OUTBUF_U34 (DO0, DO0_int);
 buf OUTBUF_U35 (DO1, DO1_int);
 buf OUTBUF_U36 (DO2, DO2_int);
 buf OUTBUF_U37 (DO3, DO3_int);
 buf OUTBUF_U38 (DO4, DO4_int);
 buf OUTBUF_U39 (DO5, DO5_int);
 buf OUTBUF_U40 (DO6, DO6_int);
 buf OUTBUF_U41 (DO7, DO7_int);
 buf OUTBUF_U42 (DO8, DO8_int);
 buf OUTBUF_U43 (WPE, WPE_int);
 buf OUTBUF_U44 (RPE, RPE_int);


 /******************************* initilization ***************************************/

   initial 
     begin
      RCLKS_previous = 1'bx;
      READ_AT_PREV_EDGE =1'b0;
      WCLKS_previous = 1'bx;
      WRITE_AT_PREV_EDGE =1'b0;
      WBLKB_previous = 1'bx;
      WRB_previous = 1'bx;
      RBLKB_previous = 1'bx;
      RDB_previous = 1'bx;
      fifo_r_cnt = 0;
      fifo_w_cnt = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
      hold_full_low   = 0;
      hold_empty_high = 0;
      hold_eqth_low   = 0;
      hold_geqth_low  = 0;
     end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh )
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(WCLKS_int) 
      begin 
          WCLKS_previous = WCLKS_int;
     end

   always @(RCLKS_int) 
      begin 
          RCLKS_previous = RCLKS_int;
     end

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: SYNC with RCLK ;


 always @(posedge RCLKS_int)
   begin
     READ_AT_PREV_EDGE = 1'b0;
     `FIFO_do_out = FIFO_do_out_stg1;
     RPE_int = RPE_stg1;
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
        begin
         if(RB_int === 1'b0) begin
              read_fifo (FIFO_do_out_stg1, fifo_r_cnt[7:0]);
          READ_AT_PREV_EDGE =1'b1;
          // increase the read address counter
          fifo_incr_counter(fifo_r_cnt,fifo_r_cnt);
          // check the parity 
          fifo_rpar;
         end else if(RB_int === 1'bx) begin 
          $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
         end
        end
   end 

 // check  the situation of RCLK unknown 'X' 
 // if RCLK unknown, READing is ENABLED, and EMPTY is false, READ address will corrput
 //  user should reset the FIFO before continuing reading
 //
 always @(RCLKS_int === 1'bx )
 begin
  if($time > 0) begin
    if ((RB_int == 1'b0) && (EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (RCLKS_previous != 1'bx)) begin
      $display("Warning : RCLK unknown at time %0.1f, can not read FIFO. ",$realtime);
    end
  end
 end

 // set the flags at the falling edge of the rclk
 //
 always @(negedge RCLKS_int)
   begin
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE) && (READ_AT_PREV_EDGE == 1'b1))  // i.e. not reset mode
       begin
        fifo_flags;
        READ_AT_PREV_EDGE =1'b0;
       end
   end


  //
  // RESET operation
  // 
 
  always @ ( negedge RESET_int )
  begin
   fifo_depth;
   fifo_r_cnt = 0;
   fifo_w_cnt = 0;
   hold_empty_low     = 0;
   hold_eqth_high     = 0;
   hold_geqth_high    = 0;
   hold_full_low      = 0;
   hold_empty_high    = 0;
   hold_eqth_low      = 0;
   hold_geqth_low     = 0;
   fifo_flags;
   RCLKS_previous = 1'bx;
   READ_AT_PREV_EDGE =1'b0;
   WCLKS_previous = 1'bx;
   WRITE_AT_PREV_EDGE =1'b0;
   WBLKB_previous = 1'bx;
   WRB_previous = 1'bx;
   RBLKB_previous = 1'bx;
   RDB_previous = 1'bx;
  end



  // Mimic unusual flag behavior of silicon when WCLKS held high
  // as RESET deasserted.

  always @ ( posedge WCLKS_int )
    begin
      WCLKS_re = $time;
    end


  always @ ( posedge WB_int )
    begin
      WB_re = $time;
    end


  always @ ( posedge RESET_int )
    begin
      RESET_re = $time;
      if ( WCLKS_int == 1'b1 ) begin
        if ( WCLKS_re == WB_re ) begin
          hold_full_low   = 1; // until next reset
          hold_empty_high = 1;
          hold_eqth_low   = 1;
          hold_geqth_low  = 1;
          fifo_flags;
        end else if ( WB_int == 1'b0 ) begin
          hold_empty_low  = 1; // until next WCLKS falling edge
          hold_eqth_high  = 1;
          hold_geqth_high = 1;
          fifo_flags;
        end else if ( WCLKS_re < WB_re ) begin
          hold_empty_low  = 1; // until next WCLKS falling edge
          hold_eqth_high  = 1;
          hold_geqth_high = 1;
          fifo_flags;
        end else if ( WB_re < WCLKS_re ) begin
          hold_empty_low  = 0; // expected behavior
          hold_eqth_high  = 0;
          hold_geqth_high = 0;
          hold_full_low   = 0;
          hold_empty_high = 0;
          hold_eqth_low   = 0;
          hold_geqth_low  = 0;
          fifo_flags;
        end
      end
    end


  always @ ( negedge WCLKS_int )
    begin
      WCLKS_fe_prev = WCLKS_fe;
      WCLKS_fe = $time;
      if ( RESET_int == 1'b1 ) begin
        hold_empty_low  = 0; // return to normal behavior
        hold_eqth_high  = 0;
        hold_geqth_high = 0;
        if ( WCLKS_fe_prev < RESET_re )
          fifo_flags;
      end
    end


  // When PARODD switches WPE & RPE toggle.
  
  always @ ( PARODD_int )
    begin
      RPE_int  = ~ RPE_int;
      RPE_stg1 = ~ RPE_stg1;
      WPE_int  = ~ WPE_int;
    end



/********************  MEMORY WRITE FUNCTION **********************/
 // WRITE: SYNC with WCLK
 always @(posedge WCLKS_int)
   begin 
        fifo_wpar; // WPE triggered by rising CLK edge in sync write mode 
                   // independent of WB
        WRITE_AT_PREV_EDGE = 1'b0;
        if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
             begin
                 if(WB_int === 1'b0) begin 
                    write_fifo (fifo_w_cnt[7:0], `FIFO_di_in );
                    fifo_incr_counter(fifo_w_cnt,fifo_w_cnt);
                    WRITE_AT_PREV_EDGE = 1'b1;
                  end else if(WB_int === 1'bx) begin
                   $display("Warning : WBLKB or WRB unknown at time %0.1f, can not write FIFO",$realtime);
                  end
             end
   end

 // any time when WCLK unknown, and Write is enabled, the write address is corruptted
 // because the write address pointer could be increased by one or stay the same 
 //
 always @(WCLKS_int === 1'bx )
  begin
    if($time > 0) begin
      if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WB_int === 1'b0) && (WCLKS_previous != 1'bx)) begin 
         $display("Warning : WCLK unknown at time %0.1f",$realtime);
         $display("        : can not write FIFO, ");
      end
    end
 end

 always @(negedge WCLKS_int)
   begin
             if ((FULL_int === `FIFO_FALSE) && (RESET_int === `FIFO_TRUE) && (WRITE_AT_PREV_EDGE === 1'b1))  // i.e. not reset mode
                  begin
                     fifo_flags;     // only do flags on rising edge of WCLK for async fifo
                     WRITE_AT_PREV_EDGE = 1'b0;
                  end
   end


 /************************** VERILOG  FUNCTION SECTION *************************/

 task fifo_depth;
    begin
           depth = `FIFO_depth + 1;
           depth_size = depth;
           depth = 1 << depth;
    end
 endtask

 function fifo_count_compare;
    input [4:0] local_depth_size;
    integer   i;
    begin
     fifo_count_compare = `FIFO_FALSE;
     begin : CHECK_COUNTER_EQUALITY
                    for (i = 0; i < local_depth_size; i = i+1)
                    begin
                            if (fifo_r_cnt[i] !== fifo_w_cnt[i])
                                  begin
                                    fifo_count_compare = `FIFO_FALSE;
                                    disable CHECK_COUNTER_EQUALITY;
                                  end
                            else
                                  fifo_count_compare = `FIFO_TRUE;
                    end
    end
   end
  endfunction

  task fifo_flags;
 
    reg [8:0] temp_write_cnt;
    
    begin
    
      // compare fifo_w_cnt with fifo_r_cnt
      
      if ( hold_empty_high == 1 )
        EMPTY_int = `FIFO_TRUE;
      else if ( hold_empty_low == 1 )
        EMPTY_int = `FIFO_FALSE;
      else begin

        if ( fifo_count_compare ( depth_size )) begin
          if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
            EMPTY_int = `FIFO_TRUE;
          end else begin
            EMPTY_int = `FIFO_FALSE;
          end
        end else begin
          EMPTY_int = `FIFO_FALSE;
        end
      end

      if ( hold_full_low == 1 )
        FULL_int = `FIFO_FALSE;
      else begin

        if ( fifo_count_compare ( depth_size )) begin
          if ( fifo_w_cnt [ depth_size ] == fifo_r_cnt [ depth_size ] ) begin
            FULL_int = `FIFO_FALSE;
          end else begin
            FULL_int  = `FIFO_TRUE;
          end
        end else begin
          FULL_int  = `FIFO_FALSE;
        end
      end

      cnt_diff = fifo_w_cnt - fifo_r_cnt; // w_cnt is always bigger

      if ( cnt_diff [ 8 ] == 1 ) begin
        cnt_diff = cnt_diff + ( 2 * depth );
      end

      // Calculate the maximum level allowable for the selected depth
      
      thresh_reg = `FIFO_thresh;
      level      = thresh_reg;
      depth_int  = depth_size;
      max_level  = 2 ** depth_int;

      // compare cnt_diff with FIFO_thresh
      
      if ( hold_eqth_high == 1 )
        EQTH_int = `FIFO_TRUE;
      else if ( hold_eqth_low == 1 )
        EQTH_int = `FIFO_FALSE;
      else begin
        if ( cnt_diff [ 8 : 0 ] == thresh_reg )
          EQTH_int = `FIFO_TRUE;
        else
          EQTH_int = `FIFO_FALSE;
      end
      if ( hold_geqth_high == 1 )
        GEQTH_int = `FIFO_TRUE;
      else if ( hold_geqth_low == 1 )
        GEQTH_int = `FIFO_FALSE;
      else begin
        if ( level > max_level )
          GEQTH_int = FULL_int; // GEQTH mimics FULL
        else begin
          if ( cnt_diff [ 8 : 0 ] >= thresh_reg )
            GEQTH_int = `FIFO_TRUE;
          else
            GEQTH_int = `FIFO_FALSE;
        end
      end

    end
    
  endtask // fifo_flags

 task fifo_incr_counter;
          output [8:0] out_reg;
          input [8:0]  in_reg;

          reg [8:0]        in_reg,out_reg;

        begin
           fifo_depth;
           if (in_reg == ((2 * depth) - 1))
               out_reg = 0;
           else
               out_reg = in_reg + 1;
        end
       endtask

 // make rpe output
  task fifo_rpar;
     begin
        par_f = fifo_par9(FIFO_do_out_stg1);    // get parity of the intermediate output
        RPE_stg1 = par_f ^ PARODD_int;
     end

   endtask // fifo_rpar

 // Tasks to check/gen parity depending on PARGEN / PARODD
 // make wpe output
  task fifo_wpar;
     begin
      par_f = fifo_par8(`FIFO_par_di_in);
      par_f2 = par_f ^ DI8_int;
      WPE_int = par_f2 ^ PARODD_int;
      DI8_int_reg  = DI8_int;
     end
   endtask

  function  fifo_par8;
   input [7:0] temp_reg1;
   reg [7:0]   temp_reg1;
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par8 = ^temp_reg1;

  endfunction


  function  fifo_par9;
   input [8:0] temp_reg2;
   reg [8:0]   temp_reg2; 
   // odd number  of bits ^ gives a 1
   // even number of bits ^ gives a 0
   fifo_par9 = ^temp_reg2;

  endfunction

 // Task to read the contents of an addressed memory location.

 task  read_fifo;
  output   [8:0]data_out;
  input [7:0]   address; 
  reg [8:0]    temp_reg;
  reg     f_address_out_of_range;
  begin
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_out_of_range == `FIFO_TRUE)
        begin
         temp_reg = 9'hx;
         $display("Warning : Data on output bus unknown because  read address is out of range");
        end
   else
     temp_reg = memory_array[address];
   data_out =  temp_reg;
   end
  endtask


 // Task to write onto the memory
 // It checks to see if the address bits are unknowns in
 // which case it Xs the whole memory

 task  write_fifo;
  input [7:0] address;
  input [8:0] data_in;

  integer       i,j;
  reg [8:0]     temp_reg;
  reg           f_address_is_x;
  reg           f_address_out_of_range;
  begin
   f_address_is_x = address_is_x(address);
   f_address_out_of_range = address_out_of_range(address);
   if (f_address_is_x == `FIFO_TRUE)
     x_memory ;
   else if (f_address_out_of_range == `FIFO_TRUE)
     $display("Warning : Invalid writing because write address is out of range ");
   else
    begin
     temp_reg = memory_array[address];
     for (j = 0; j <9; j=j+1)
       temp_reg[j] = data_in[j];
      memory_array[address] = temp_reg;
     end
    end
  endtask
 // Function to check if address bits are unknown.

 function address_is_x;
  input [7:0] address;
  integer        i;
  begin
   address_is_x = `FIFO_FALSE;
   begin : CHECK_ADDRESS
    for (i = 0; i <8; i = i+1) 
     if ( address[i] === 1'bx)
      begin
       address_is_x = `FIFO_TRUE;
       $display("Warning : Bits on the Address Bus are unknown at time %10g", $realtime);
       $display("        : address is %b ", address);
       disable CHECK_ADDRESS;
      end
     end
    end
  endfunction // address_is_x


 // Function to check if data out bits are unknown.

 function do_is_x;
  input [8:0] dout;
  integer  i;
  begin
   do_is_x = `FIFO_FALSE;
   begin : CHECK_DOUT
    for (i = 0; i < 9; i = i+1)
     if ( dout[i] === 1'bx)
      begin
       do_is_x = `FIFO_TRUE;
       $display("Warning : Bit [%d] on the data out bus is unknown at time %10g.", i, $realtime);
       $display("        : Current bits on the data out bus are %b ", dout);
       disable CHECK_DOUT;
      end
     end
   end
 endfunction


 // Function to check address out of range
 function address_out_of_range;
  input [7:0] address;
  integer     adr;
  begin
   address_out_of_range = `FIFO_FALSE;
   adr = address;
   if (adr > 256 -1)
    begin
     address_out_of_range = `FIFO_TRUE;
     $display("Warning : Address out of range at time %10g.", $realtime);
    end
   end
 endfunction

 // Task to X out the complete memory by writing unknowns

 task x_memory;

  reg     [10:0] temp_reg;
  integer    i, j;
  begin
   $display("Warning : The entire memory contents  unknown at time %10g ", $realtime);
   for (i=0; i < 256; i=i+1)
    begin
      temp_reg = memory_array[i];
      for (j = 0; j < 9; j = j+1)
       temp_reg[j] = 1'bx;
       memory_array[i] = temp_reg;
    end
   end
  endtask


 // Task to X the appropriate data bits in the addressed
 // location corresponding to which the data in bits have
 // undergone a timing violation.
 task x_data_bits;
  input [7:0] address;
  input       bit_position;
  integer     bit_position;
  reg [8:0]   temp_reg;
  begin
   $display("Warning : The data bit %d in memory word at address [%d] unknown at time %10g.",bit_position, address, $realtime);
   temp_reg = memory_array[address];
   temp_reg[bit_position] = 1'bx;
   memory_array[address] = temp_reg;
    end
  endtask


 // This task Xs a particular addressed location.
 // Used for cases of corrupting a particular location
 task x_data_word;
  input [7:0] address;
  reg [8:0]   temp_reg;
  integer         i;
  begin
   $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
   temp_reg = memory_array[address];
   for (i=0; i < 9; i=i+1)
    temp_reg[i] = 1'bx;
    memory_array[address] = temp_reg;
  end
 endtask


 // This task Xs a particular addressed location.
 // Also this is done only in the case when the input
 // data bits are not the same as the contents of the
 // addressed memory location.
 // Used when write enable is unknown.

 task x_addr_location;

  input [7:0] address;

  input [8:0] data_in;
  reg [8:0]   temp_reg;

  integer     i, j;
  begin
   temp_reg = memory_array[address];
   begin : CHECK_DATA_BIT
    for (j=0; j < 9; j=j+1)
      begin
        if (data_in[j] !== temp_reg[j])
           begin
            $display("Warning : The Data in memory word at address [%d] unknown at time %10g.", address, $realtime);
            for (i=0; i < 9; i=i+1)
             temp_reg[i] = 1'bx;
             disable CHECK_DATA_BIT;
           end
      end
    end
   memory_array[address] = temp_reg;
  end
 endtask


//--------------------------------------------------------------
//              Timing Checking Section 
//-------------------------------------------------------------

	specify


	     // setup for Data in, DI[7:0]
		$setup(posedge DI0, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI0, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI1, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI1, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI2, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI2, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI3, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI3, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI4, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI4, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI5, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI5, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI6, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI6, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI7, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI7, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(posedge DI8, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
		$setup(negedge DI8, posedge WCLKS &&& (DI_WCLK_check_condition), 0.0, NOTIFY_REG);
	     // holdup time for Data IN to WCLK;
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI0, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI1, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI2, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI3, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI4, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI5, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI6, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI7, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), posedge DI8, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS &&& (DI_WCLK_check_condition), negedge DI8, 0.0, NOTIFY_REG);

	    // setup/hold time for enable signal
		$setup(posedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge WRB, 0.0, NOTIFY_REG);
		$setup(negedge WRB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge WRB, 0.0, NOTIFY_REG);
		$setup(posedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, posedge WBLKB, 0.0, NOTIFY_REG);
		$setup(negedge WBLKB, posedge WCLKS, 0.0, NOTIFY_REG);
		$hold(posedge WCLKS, negedge WBLKB, 0.0, NOTIFY_REG);

           // recovery/hold timing for WCLKS to RESET signals
                $recovery(posedge RESET, posedge WCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge WCLKS, 0.0, NOTIFY_REG);
                $hold(posedge WCLKS, posedge RESET, 0.0, NOTIFY_REG);
                $hold(negedge WCLKS, posedge RESET, 0.0, NOTIFY_REG);
	    
	     // path delay from WCLK to WPE 
		(WCLKS => WPE) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to FULL 
		(WCLKS => FULL) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to EMPTY 
		(WCLKS => EMPTY) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to EQTH 
		(WCLKS => EQTH) =  (0.1:0.1:0.1, 0.1:0.1:0.1);

             // path delay from WCLK to GETH 
		(WCLKS => GEQTH) =  (0.1:0.1:0.1, 0.1:0.1:0.1);


	     // WCLK width
		$width(posedge WCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge WCLKS, 0.0, 0, NOTIFY_REG);
             // WCLK period 
		$period(posedge WCLKS, 0, NOTIFY_REG);
	   // setup and hold time for RBD and RBLKB to RCLK
	        $setup(negedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
	        $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), negedge RDB, 0.0, NOTIFY_REG);
                $setup(negedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), negedge RBLKB, 0.0, NOTIFY_REG);
                $setup(posedge RDB, posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RENABLE_RCLK_setup_check_condition), posedge RDB, 0.0, NOTIFY_REG);
                $setup(posedge RBLKB, posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), 0.0, NOTIFY_REG);
                $hold(posedge RCLKS &&& (RBLK_RCLK_setup_check_condition), posedge RBLKB, 0.0, NOTIFY_REG);

	  // path delay parameters
		(RCLKS => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => RPE) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);
		(RCLKS => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);

	   // minimum RCLK  width 
		$width(posedge RCLKS, 0.0, 0, NOTIFY_REG);
		$width(negedge RCLKS, 0.0, 0, NOTIFY_REG);
                $width(posedge RESET, 0.0, 0, NOTIFY_REG);
                $width(negedge RESET, 0.0, 0, NOTIFY_REG);

           // recovery/hold timing for RCLKS to RESET signals
                $recovery(posedge RESET, posedge RCLKS, 0.0, NOTIFY_REG);
                $recovery(posedge RESET, negedge RCLKS, 0.0, NOTIFY_REG);
                $hold(posedge RCLKS, posedge RESET,  0.0, NOTIFY_REG);
                $hold(negedge RCLKS, posedge RESET, 0.0, NOTIFY_REG);
	    
             // path delay from DIS to DOS 
		(DIS => DOS) = (0.1:0.1:0.1, 0.1:0.1:0.1);  

             // path delay from signal to all outputs
		(RESET => FULL) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EMPTY) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => EQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => GEQTH) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO0) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO1) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO2) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO3) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO4) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO5) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO6) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO7) = (0.1:0.1:0.1, 0.1:0.1:0.1);  
		(RESET => DO8) = (0.1:0.1:0.1, 0.1:0.1:0.1);  



 endspecify



endmodule

`endcelldefine
`disable_portfaults
`nosuppress_faults


`suppress_faults
`enable_portfaults
`celldefine
`delay_mode_path
`timescale 1 ns / 100 ps

 module FIFO256x9SSRP(
		LGDEP0, LGDEP1, LGDEP2, 
		LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, 
		DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, RBLKB, WBLKB, 
		RDB, WRB, PARODD, RESET, DIS, DOS, WCLKS, RCLKS, 
                FULL, EMPTY, EQTH, GEQTH,
		DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8
                   );


 input LGDEP0, LGDEP1, LGDEP2;
 input LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7;
 input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8;
 input RESET, RDB, WRB, DIS, WCLKS, RCLKS, RBLKB, WBLKB, PARODD;

 output  DOS, FULL, EMPTY, EQTH, GEQTH;
 output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8;

 wire LGDEP0_int, LGDEP1_int, LGDEP2_int;
 wire LEVEL0_int, LEVEL1_int, LEVEL2_int, LEVEL3_int, LEVEL4_int, LEVEL5_int, LEVEL6_int, LEVEL7_int;
 wire DI0_int, DI1_int, DI2_int, DI3_int, DI4_int, DI5_int, DI6_int, DI7_int, DI8_int;
 wire RDB_int, WRB_int, DIS_int, WCLKS_int, RCLKS_int, RBLKB_int, WBLKB_int, PARODD_int;
 wire RESET_int, RB_int, WB_int;

 wire DI_WCLK_check_condition;
 wire RBLK_RCLK_setup_check_condition;
 wire RENABLE_RCLK_setup_check_condition;

/********************* REGISTER DECLARATIONS *****************************/
 reg [8:0] memory_array [255:0];
 reg [8:0] FIFO_do_out_stg1;
 reg       RPE_stg1;
 reg [8:0] fifo_w_cnt, fifo_r_cnt, cnt_diff;
 reg [8:0] thresh_reg;
 reg DI8_int_reg;
 reg f_address_is_x_g, f_dout_is_x;
 reg par_f, par_f2;
 reg WPE_int, RPE_int, NOTIFY_REG;
 reg [4:0] depth_size;
 reg [8:0] depth;
 reg FULL_int, EMPTY_int, EQTH_int, GEQTH_int;
 reg DO8_int,DO7_int,DO6_int,DO5_int,DO4_int,DO3_int,DO2_int,DO1_int,DO0_int;
 reg WCLKS_previous;
 reg WRITE_AT_PREV_EDGE;
 reg RCLKS_previous;
 reg READ_AT_PREV_EDGE;
 reg WRB_previous, WBLKB_previous, RDB_previous, RBLKB_previous;


/********************* TEXT MACRO DEFINITIONS SECTION ******************/

 `define FIFO_TRUE  1'b1
 `define FIFO_FALSE 1'b0
 `define FIFO_do_out  {DO8_int, DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_par_do_out   {DO7_int, DO6_int, DO5_int, DO4_int, DO3_int, DO2_int, DO1_int, DO0_int}
 `define FIFO_di_in  {DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_par_di_in   {DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int}
 `define FIFO_pargen_di_in  { DI8_int_reg, DI7_int, DI6_int, DI5_int, DI4_int, DI3_int, DI2_int, DI1_int, DI0_int }
 `define FIFO_depth {LGDEP2_int, LGDEP1_int, LGDEP0_int}
 `define FIFO_thresh {LEVEL7_int, LEVEL6_int, LEVEL5_int, LEVEL4_int, LEVEL3_int, LEVEL2_int, LEVEL1_int, LEVEL0_int}

 // Special variables to control flags

 integer hold_empty_low;
 integer hold_eqth_high;
 integer hold_geqth_high;
 integer hold_full_low;
 integer hold_empty_high;
 integer hold_eqth_low;
 integer hold_geqth_low;
 integer level;
 integer depth_int;
 integer max_level;
 time    WCLKS_re;
 time    WCLKS_fe;
 time    WCLKS_fe_prev;
 time    WB_re;
 time    RESET_re;

/********************* Instantiate Input Input Buffers *****************************/
 assign RB_int = RDB_int || RBLKB_int;
 assign WB_int = WRB_int || WBLKB_int;

 assign DI_WCLK_check_condition = (~WB_int && ~FULL && RESET_int);
 assign RBLK_RCLK_setup_check_condition = (RDB_int && ~EMPTY && RESET_int);
 assign RENABLE_RCLK_setup_check_condition = (RBLKB_int && ~EMPTY && RESET_int);

 // input data  bufs 
 buf BUF_U0 (LGDEP0_int, LGDEP0);
 buf BUF_U1 (LGDEP1_int, LGDEP1);
 buf BUF_U2 (LGDEP2_int, LGDEP2);
 buf BUF_U3 (LEVEL0_int, LEVEL0);
 buf BUF_U4 (LEVEL1_int, LEVEL1);
 buf BUF_U5 (LEVEL2_int, LEVEL2);
 buf BUF_U6 (LEVEL3_int, LEVEL3);
 buf BUF_U7 (LEVEL4_int, LEVEL4);
 buf BUF_U8 (LEVEL5_int, LEVEL5);
 buf BUF_U9 (LEVEL6_int, LEVEL6);
 buf BUF_U10 (LEVEL7_int, LEVEL7);
 buf BUF_U11 (DI0_int, DI0);
 buf BUF_U12 (DI1_int, DI1);
 buf BUF_U13 (DI2_int, DI2);
 buf BUF_U14 (DI3_int, DI3);
 buf BUF_U15 (DI4_int, DI4);
 buf BUF_U16 (DI5_int, DI5);
 buf BUF_U17 (DI6_int, DI6);
 buf BUF_U18 (DI7_int, DI7);
 buf BUF_U19 (DI8_int, DI8);
 buf BUF_U20 (RDB_int, RDB);
 buf BUF_U21 (WRB_int, WRB);
 buf BUF_U22 (PARODD_int, PARODD);
 buf BUF_U23 (DIS_int, DIS);
 buf BUF_U24 (WCLKS_int, WCLKS);
 buf BUF_U25 (RCLKS_int, RCLKS);
 buf BUF_U26 (RBLKB_int, RBLKB);
 buf BUF_U27 (WBLKB_int, WBLKB);
 buf BUF_U28 (RESET_int, RESET);

 // output data buffers
 buf OUTBUF_U29 (DOS, DIS_int);
 buf OUTBUF_U30 (FULL, FULL_int);
 buf OUTBUF_U31 (EMPTY, EMPTY_int);
 buf OUTBUF_U32 (EQTH, EQTH_int);
 buf OUTBUF_U33 (GEQTH, GEQTH_int);
 buf OUTBUF_U34 (DO0, DO0_int);
 buf OUTBUF_U35 (DO1, DO1_int);
 buf OUTBUF_U36 (DO2, DO2_int);
 buf OUTBUF_U37 (DO3, DO3_int);
 buf OUTBUF_U38 (DO4, DO4_int);
 buf OUTBUF_U39 (DO5, DO5_int);
 buf OUTBUF_U40 (DO6, DO6_int);
 buf OUTBUF_U41 (DO7, DO7_int);
 buf OUTBUF_U42 (DO8, DO8_int);


 /******************************* initilization ***************************************/

   initial 
     begin
      RCLKS_previous = 1'bx;
      READ_AT_PREV_EDGE =1'b0;
      WCLKS_previous = 1'bx;
      WRITE_AT_PREV_EDGE =1'b0;
      WBLKB_previous = 1'bx;
      WRB_previous = 1'bx;
      RBLKB_previous = 1'bx;
      RDB_previous = 1'bx;
      fifo_r_cnt = 0;
      fifo_w_cnt = 0;
      hold_empty_low  = 0;
      hold_eqth_high  = 0;
      hold_geqth_high = 0;
      hold_full_low   = 0;
      hold_empty_high = 0;
      hold_eqth_low   = 0;
      hold_geqth_low  = 0;
     end

   // Though LEVEL is a static configuration, but to make checks on LEVEL work in simulation
   always @ ( `FIFO_thresh )
     begin
       if ( `FIFO_thresh == 8'hFF || `FIFO_thresh == 8'h00 ) begin
         $display ( "Error: Illegal level configuration, LEVEL = %d is not allowed", `FIFO_thresh );
         $stop;
       end
     end

 /****************************** track signal changes *********************************/

   always @(WCLKS_int) 
      begin 
          WCLKS_previous = WCLKS_int;
     end

   always @(RCLKS_int) 
      begin 
          RCLKS_previous = RCLKS_int;
     end

   always @(WBLKB_int) 
      begin 
          WBLKB_previous = WBLKB_int;
     end

   always @(RBLKB_int) 
      begin 
          RBLKB_previous = RBLKB_int;
     end

   always @(WRB_int) 
      begin 
          WRB_previous = WRB_int;
     end

   always @(RDB_int) 
      begin 
          RDB_previous = RDB_int;
     end


/************************ the FIFO read section *********************************/

 // READ: SYNC with RCLK ;


 always @(posedge RCLKS_int)
   begin
     READ_AT_PREV_EDGE = 1'b0;
     `FIFO_do_out = FIFO_do_out_stg1;
     RPE_int = RPE_stg1;
     if ((EMPTY_int === `FIFO_FALSE)  && (RESET_int === `FIFO_TRUE))  // i.e. not reset mode
        begin
         if(RB_int === 1'b0) begin
              read_fifo (FIFO_do_out_stg1, fifo_r_cnt[7:0]);
          READ_AT_PREV_EDGE =1'b1;
          // increase the read address counter
          fifo_incr_counter(fifo_r_cnt,fifo_r_cnt);
          // check the parity 
          fifo_rpar;
         end else if(RB_int === 1'bx) begin 
          $display("Warning : RDB or RBLKB  unknown at time %0.1f, can not read FIFO. ",$realtime);
         end
        end
   end 

 // check  the situation of RCLK unknown 'X' 
 // if RCLK unknown, READing is ENABLED, and EMPTY is false, READ address will corrput
 //  user should reset the FIFO before continuing reading
 //
 always @(RCLKS_int === 1'bx )
 begin
  if($time > 0) begin
    if ((RB_int == 1'b0) && (EMPTY